/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.logger;

import com.iscobol.logger.LoggerFactory;
import com.iscobol.rts.Config;
import com.iscobol.rts.RtsUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ServletLogger {
    public static final String K_rest_logmethod_property = "iscobol.rest.log";
    public static final String K_rest_logfolder_property = "iscobol.rest.log.folder";
    public static final String K_soap_logmethod_property = "iscobol.soap.log";
    public static final String K_soap_logfolder_property = "iscobol.soap.log.folder";
    private static final SimpleDateFormat sdf = new SimpleDateFormat("YYYY-MM-dd - HH.mm.ss.SSSS");
    private String logFilename;
    private File logFile;

    public File getLogFile() {
        return this.logFile;
    }

    public void setLogFile(File logFile) {
        this.logFile = logFile;
    }

    public String getLogFilename() {
        return this.logFilename;
    }

    public void setLogFilename(String logFilename) {
        this.logFilename = logFilename;
    }

    public static String reportTimestamp() {
        Date date = new Date();
        return sdf.format(date);
    }

    public void reportLog(String logString) {
        try {
            PrintWriter pw = new PrintWriter(new FileOutputStream(this.logFile, true));
            StringBuffer sb = new StringBuffer();
            sb.append(logString);
            pw.println(sb.toString());
            pw.flush();
            pw.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static String prettyPrint(String xml) {
        try {
            Document document = RtsUtil.newDocumentBuilderFactory().newDocumentBuilder().parse(new InputSource(new ByteArrayInputStream(xml.getBytes("utf-8"))));
            XPath xPath = XPathFactory.newInstance().newXPath();
            NodeList nodeList = (NodeList)xPath.evaluate("//text()[normalize-space()='']", document, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                node.getParentNode().removeChild(node);
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            try {
                transformerFactory.setAttribute("indent-number", "2");
            }
            catch (IllegalArgumentException ex) {
                System.err.println(ex);
            }
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "yes");
            StringWriter stringWriter = new StringWriter();
            transformer.transform(new DOMSource(document), new StreamResult(stringWriter));
            return stringWriter.toString();
        }
        catch (Exception e) {
            return xml;
        }
    }

    public static ServletLogger getInstance(String logMethodProperty, String logFolderProperty, String cobolProgram, String sessionId) {
        ServletLogger logger = null;
        boolean enableLog = Config.getProperty(logMethodProperty, false);
        if (cobolProgram != null) {
            enableLog = Config.getProperty(logMethodProperty + "." + cobolProgram.toLowerCase(), enableLog);
        }
        if (enableLog &= Config.getProperty(logFolderProperty, null) != null) {
            logger = new ServletLogger();
            String dir = Config.getProperty(logFolderProperty, "");
            if (dir.length() > 0) {
                dir = LoggerFactory.decodeName(dir + "/");
                dir = dir.substring(0, dir.lastIndexOf(47));
            }
            logger.setLogFile(new File(dir, (cobolProgram != null ? cobolProgram + "-" : "") + sessionId + ".log"));
        }
        return logger;
    }
}

