/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.misc.image;

import com.iscobol.gui.BarcodeCreator;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.krysalis.barcode4j.BarcodeDimension;
import org.krysalis.barcode4j.HumanReadablePlacement;
import org.krysalis.barcode4j.impl.AbstractBarcodeBean;
import org.krysalis.barcode4j.impl.codabar.CodabarBean;
import org.krysalis.barcode4j.impl.code128.Code128Bean;
import org.krysalis.barcode4j.impl.code128.EAN128Bean;
import org.krysalis.barcode4j.impl.code39.Code39Bean;
import org.krysalis.barcode4j.impl.datamatrix.DataMatrixBean;
import org.krysalis.barcode4j.impl.datamatrix.SymbolShapeHint;
import org.krysalis.barcode4j.impl.fourstate.RoyalMailCBCBean;
import org.krysalis.barcode4j.impl.fourstate.USPSIntelligentMailBean;
import org.krysalis.barcode4j.impl.int2of5.ITF14Bean;
import org.krysalis.barcode4j.impl.int2of5.Interleaved2Of5Bean;
import org.krysalis.barcode4j.impl.pdf417.PDF417Bean;
import org.krysalis.barcode4j.impl.postnet.POSTNETBean;
import org.krysalis.barcode4j.impl.qr.QRCodeBean;
import org.krysalis.barcode4j.impl.upcean.EAN13Bean;
import org.krysalis.barcode4j.impl.upcean.EAN8Bean;
import org.krysalis.barcode4j.impl.upcean.UPCABean;
import org.krysalis.barcode4j.impl.upcean.UPCEBean;
import org.krysalis.barcode4j.output.CanvasProvider;
import org.krysalis.barcode4j.output.bitmap.BitmapCanvasProvider;
import org.krysalis.barcode4j.output.bitmap.BitmapEncoder;
import org.krysalis.barcode4j.output.bitmap.BitmapEncoderRegistry;
import org.krysalis.barcode4j.tools.UnitConv;

public class Barcode4JCreator
implements BarcodeCreator {
    @Override
    public BufferedImage createImage(String text, int width, int height, int type, int dpi, int orientation, int antialiasing, int textPosition, Color background, Color foreground, Image logo) throws IOException {
        boolean changeColors;
        boolean aa;
        int or;
        HumanReadablePlacement hrp;
        if (type != 16) {
            logo = null;
        }
        AbstractBarcodeBean bean = Barcode4JCreator.createBean(type);
        try {
            bean.doQuietZone(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        switch (textPosition) {
            case 1: {
                hrp = HumanReadablePlacement.HRP_BOTTOM;
                break;
            }
            case 2: {
                hrp = HumanReadablePlacement.HRP_TOP;
                break;
            }
            default: {
                hrp = HumanReadablePlacement.HRP_NONE;
            }
        }
        switch (orientation) {
            case 1: {
                or = 90;
                int tmp = width;
                width = height;
                height = tmp;
                break;
            }
            default: {
                or = 0;
            }
        }
        switch (antialiasing) {
            case 1: {
                aa = true;
                break;
            }
            default: {
                aa = false;
            }
        }
        if (dpi <= 0) {
            dpi = Toolkit.getDefaultToolkit().getScreenResolution();
        }
        switch (type) {
            case 4: {
                DataMatrixBean dmBean = (DataMatrixBean)bean;
                if (width == height) {
                    dmBean.setShape(SymbolShapeHint.FORCE_SQUARE);
                    break;
                }
                if (width < height) {
                    dmBean.setShape(SymbolShapeHint.FORCE_RECTANGLE);
                    break;
                }
                dmBean.setShape(SymbolShapeHint.FORCE_RECTANGLE);
                break;
            }
            case 16: {
                height = width = Math.min(width, height);
            }
        }
        bean.setMsgPosition(hrp);
        double mw = bean.getModuleWidth();
        Barcode4JCreator.setPreferredWidth(bean, width, dpi, text);
        bean.setFontSize(bean.getFontSize() * bean.getModuleWidth() / mw);
        Barcode4JCreator.setPreferredHeight(bean, height, dpi, text);
        BitmapCanvasProvider canvas = new BitmapCanvasProvider(dpi, 12, aa, or);
        bean.generateBarcode((CanvasProvider)canvas, text);
        canvas.finish();
        BufferedImage Return2 = canvas.getBufferedImage();
        final int bgRgb = background != null ? background.getRGB() : -1;
        final int fgRgb = foreground != null ? foreground.getRGB() : -16777216;
        boolean bl = changeColors = bgRgb != -1 || fgRgb != -16777216;
        if (changeColors || logo != null) {
            Image im;
            BufferedImage newImage = new BufferedImage(Return2.getWidth(), Return2.getHeight(), 2);
            Graphics2D g = newImage.createGraphics();
            if (aa) {
                g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            if (changeColors) {
                RGBImageFilter filter = new RGBImageFilter(){

                    @Override
                    public final int filterRGB(int x, int y, int rgb) {
                        switch (rgb) {
                            case -1: {
                                rgb = bgRgb;
                                break;
                            }
                            case -16777216: {
                                rgb = fgRgb;
                            }
                        }
                        return rgb;
                    }
                };
                FilteredImageSource ip = new FilteredImageSource(Return2.getSource(), filter);
                im = Toolkit.getDefaultToolkit().createImage(ip);
            } else {
                im = Return2;
            }
            g.drawImage(im, 0, 0, null);
            if (logo != null) {
                g.drawImage(logo, (Return2.getWidth() - logo.getWidth(null)) / 2, (Return2.getHeight() - logo.getHeight(null)) / 2, null);
            }
            g.dispose();
            Return2 = newImage;
        }
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] createImageAsStream(String text, int width, int height, int type, int dpi, int orientation, int antialiasing, int textPosition, Color background, Color foreground, Image logo) throws IOException {
        BufferedImage bitmap = this.createImage(text, width, height, type, dpi, orientation, antialiasing, textPosition, background, foreground, logo);
        String mime = "image/png";
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            BitmapEncoder encoder = BitmapEncoderRegistry.getInstance((String)mime);
            encoder.encode(bitmap, (OutputStream)out, mime, dpi);
        }
        return out.toByteArray();
    }

    private static AbstractBarcodeBean createBean(int type) throws IOException {
        switch (type) {
            case 1: {
                return new CodabarBean();
            }
            case 2: {
                return new Code128Bean();
            }
            case 3: {
                return new Code39Bean();
            }
            case 4: {
                return new DataMatrixBean();
            }
            case 5: {
                return new RoyalMailCBCBean();
            }
            case 6: {
                return new USPSIntelligentMailBean();
            }
            case 7: {
                return new POSTNETBean();
            }
            case 8: {
                return new Interleaved2Of5Bean();
            }
            case 9: {
                return new ITF14Bean();
            }
            case 10: {
                return new PDF417Bean();
            }
            case 11: {
                return new EAN128Bean();
            }
            case 12: {
                return new EAN13Bean();
            }
            case 13: {
                return new EAN8Bean();
            }
            case 14: {
                return new UPCABean();
            }
            case 15: {
                return new UPCEBean();
            }
            case 16: {
                return new QRCodeBean();
            }
        }
        throw new IOException("Unknown type: " + type);
    }

    static BarcodeDimension setPreferredWidth(AbstractBarcodeBean bean, int preferredWidth, int dpi, String msg) {
        int realWidth = 0;
        BarcodeDimension d = null;
        boolean foundLs = false;
        boolean foundGt = false;
        double inc = 0.01;
        int count = 0;
        int lastWidth = 0;
        int MAX_ATTEMPTS = 10;
        double px = 1.0;
        while (px > 0.0) {
            bean.setModuleWidth(UnitConv.in2mm((double)(px / (double)dpi)));
            d = bean.calcDimensions(msg);
            realWidth = Math.round(UnitConv.mm2px((double)d.getWidth(), (int)dpi));
            if (realWidth == lastWidth) {
                if (++count == 10) {
                    break;
                }
            } else {
                count = 0;
            }
            if (realWidth < preferredWidth) {
                if (foundGt) break;
                foundLs = true;
                px += 0.01;
            } else {
                if (realWidth <= preferredWidth || foundLs) break;
                foundGt = true;
                px -= 0.01;
            }
            lastWidth = realWidth;
        }
        return d;
    }

    static BarcodeDimension setPreferredHeight(AbstractBarcodeBean bean, int preferredHeight, int dpi, String msg) {
        double mm2px = 1.0 / (double)UnitConv.mm2px((double)1.0, (int)dpi);
        int realHeight = 0;
        BarcodeDimension d = null;
        boolean foundLs = false;
        boolean foundGt = false;
        int count = 0;
        int lastHeight = 0;
        int MAX_ATTEMPTS = 10;
        int i = 0;
        while (true) {
            bean.setHeight((double)(preferredHeight + i) * mm2px);
            d = bean.calcDimensions(msg);
            realHeight = Math.round(UnitConv.mm2px((double)d.getHeight(), (int)dpi));
            if (realHeight == lastHeight) {
                if (++count == 10) {
                    break;
                }
            } else {
                count = 0;
            }
            if (realHeight < preferredHeight) {
                if (foundGt) break;
                foundLs = true;
                ++i;
            } else {
                if (realHeight <= preferredHeight || foundLs) break;
                foundGt = true;
                --i;
            }
            lastHeight = realHeight;
        }
        return d;
    }
}

