/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.report;

import com.iscobol.report.ReportVariable;
import com.iscobol.rts.CobValue;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.IscobolRuntimeException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

public class ReportGroup {
    private int groupLine;
    private int vSize;
    private int vPos;
    int nextGroup;
    ICobolVar control;
    private Vector children = new Vector();
    final Method declaratives;
    final Object program;
    final Integer declStart;
    final Integer declEnd;
    private ArrayList sums = new ArrayList();

    public ReportGroup() {
        this.program = null;
        this.declaratives = null;
        this.declEnd = null;
        this.declStart = null;
    }

    public ReportGroup(Object cm, int start, int end) {
        this.program = cm;
        this.declStart = new Integer(start);
        this.declEnd = new Integer(end);
        Method m = null;
        try {
            m = cm.getClass().getDeclaredMethod("declaratives", Integer.TYPE, Integer.TYPE);
            m.setAccessible(true);
        }
        catch (NoSuchMethodException _ex) {
            System.err.println("ReportGroup " + _ex);
        }
        this.declaratives = m;
    }

    void setGroupLine(int n) {
        this.groupLine = n;
    }

    void setNextGroup(int n) {
        this.nextGroup = n;
    }

    void setControl(ICobolVar v) {
        this.control = v;
    }

    void addVar(ReportVariable rv) {
        this.children.add(rv);
    }

    void init() {
        this.vSize = 0;
        this.vPos = 0;
        for (int i = 0; i < this.children.size(); ++i) {
            ReportVariable rv = (ReportVariable)this.children.elementAt(i);
            if (rv.line == 0) continue;
            if ((rv.line & 0x20000000) != 0) {
                this.vSize = -1;
                break;
            }
            if ((rv.line & 0x10000000) != 0) {
                this.vSize += rv.line & 0xFFFFFFF;
                continue;
            }
            if (this.vPos == 0) {
                this.vPos = rv.line;
                continue;
            }
            this.vSize = rv.line - this.vPos;
        }
        if ((this.groupLine & 0x10000000) != 0) {
            this.vSize += this.groupLine & 0xFFFFFFF;
        }
    }

    void declaratives() {
        if (this.declaratives != null) {
            try {
                this.declaratives.invoke(this.program, (Object[])new Integer[]{this.declStart, this.declEnd});
            }
            catch (Throwable _ex) {
                if (_ex.getCause() != null && (_ex = _ex.getCause()) instanceof RuntimeException) {
                    throw (RuntimeException)_ex;
                }
                throw new IscobolRuntimeException(_ex);
            }
        }
    }

    final int getGroupLine() {
        return this.groupLine;
    }

    final int getVSize() {
        return this.vSize;
    }

    Iterator iterator() {
        return this.children.iterator();
    }

    void setSum(ReportVariable rv, CobValue cv) {
        this.sums.add(new Sums(rv, cv));
    }

    void evalSums() {
        for (int i = 0; i < this.sums.size(); ++i) {
            Sums c = (Sums)this.sums.get(i);
            c.doSum();
        }
    }

    private static class Sums {
        ReportVariable rv;
        CobValue cv;

        private Sums(ReportVariable rv, CobValue cv) {
            this.rv = rv;
            this.cv = cv;
        }

        private void doSum() {
            this.rv.sumToMe(this.cv);
        }
    }
}

