/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import com.iscobol.as.ClientInfo;
import com.iscobol.gui.GuiFactory;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.server.DisplayWindow;
import com.iscobol.gui.server.ScrFactory;
import com.iscobol.rts.Config;
import com.iscobol.rts.DumpCreator;
import com.iscobol.rts.Factory;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.LayoutExceptionCobol;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class ErrorBox {
    public static final String DUMP_EXT = ".ads.log";

    public static void show(Throwable ex) {
        LayoutExceptionCobol e = new LayoutExceptionCobol(ex, new DumpCreator());
        if (!Factory.errorShow(e)) {
            ErrorBox.showDirect(e, true);
        }
    }

    public static void showDirect(Throwable ex) {
        ErrorBox.showDirect(new LayoutExceptionCobol(ex, new DumpCreator()), true);
    }

    public static void showError(String prg, String stack) {
        ErrorBox.showError(prg, prg, stack);
    }

    private static void showError(String prg, String msg, String stack) {
        int propValue = Config.getProperty(".exception.message", ".exception_message", -1);
        if (propValue == -1) {
            propValue = Config.getProperty(".display_message", 0);
        }
        switch (propValue) {
            case 0: {
                GuiFactory gf = ScreenUtility.getGuiFactory();
                try {
                    DisplayWindow dw = ScrFactory.getGUIEnviroment().getGlobActiveWindow();
                    gf.showError(msg, stack, dw != null && !dw.isDestroyed() ? dw.getTheObjectId() : -1);
                }
                catch (Exception dw) {}
                break;
            }
            case 1: {
                System.out.println(stack);
                break;
            }
            default: {
                System.err.println(stack);
                break;
            }
            case 3: {
                ClientInfo ci = (ClientInfo)IscobolSystem.get(ClientInfo.class);
                ErrorBox.dumpfile(prg, ci != null ? ci.getHostAddress() : null, ci != null ? ci.getUserName() : null, stack);
            }
        }
    }

    public static void showDirect(LayoutExceptionCobol e, boolean exit) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        String prg = e.getName();
        String msg = e.getLocalizedMessage();
        if (msg == null || msg.length() == 0) {
            msg = e.getClass().getName() + " caught!";
        }
        ErrorBox.showError(prg, msg, sw.getBuffer().toString());
        Factory.stopRun(255, exit);
    }

    public static void dumpfile(String name, String content) {
        ErrorBox.dumpfile(name, null, null, content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpfile(String progName, String hostName, String userName, String content) {
        PrintWriter pf = null;
        String fileName = Config.getProperty("iscobol.exception.dumpfile", null);
        if (fileName != null && (fileName = fileName.trim()).length() > 0) {
            boolean append = false;
            if (fileName.charAt(0) == '+') {
                append = true;
                if ((fileName = fileName.substring(1)).length() == 0) {
                    fileName = progName;
                }
            }
            try {
                if (fileName.indexOf("%p") >= 0) {
                    fileName = fileName.replace("%p", progName);
                }
                GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
                if (fileName.indexOf("%d") >= 0) {
                    String d = "" + cal.get(1);
                    int m = cal.get(2) + 1;
                    if (m < 10) {
                        d = d + "0";
                    }
                    d = d + m;
                    m = cal.get(5);
                    if (m < 10) {
                        d = d + "0";
                    }
                    d = d + m;
                    fileName = fileName.replace("%d", d);
                }
                if (fileName.indexOf("%t") >= 0) {
                    String t = "";
                    int h = cal.get(11);
                    if (h < 10) {
                        t = t + "0";
                    }
                    t = t + h;
                    h = cal.get(12);
                    if (h < 10) {
                        t = t + "0";
                    }
                    t = t + h;
                    h = cal.get(13);
                    if (h < 10) {
                        t = t + "0";
                    }
                    t = t + h;
                    h = cal.get(14);
                    if (h < 10) {
                        t = t + "00";
                    } else if (h < 100) {
                        t = t + "0";
                    }
                    t = t + h;
                    fileName = fileName.replace("%t", t);
                }
                if (fileName.indexOf("%u") >= 0) {
                    if (userName == null) {
                        userName = System.getProperty("user.name");
                    }
                    fileName = fileName.replace("%u", userName);
                }
                if (fileName.indexOf("%h") >= 0) {
                    if (hostName == null) {
                        try {
                            hostName = InetAddress.getLocalHost().getHostAddress();
                            fileName = fileName.replace("%h", hostName);
                        }
                        catch (UnknownHostException unknownHostException) {}
                    } else {
                        fileName = fileName.replace("%h", hostName);
                    }
                }
                pf = new PrintWriter(new FileOutputStream(fileName, append));
                pf.print(content);
            }
            catch (IOException _ex) {
                _ex.printStackTrace();
            }
            finally {
                if (pf != null) {
                    pf.close();
                }
            }
        } else {
            progName = Config.getProperty(".exception.prefix", "") + progName;
            try {
                for (int i = 0; i >= 0; ++i) {
                    fileName = i < 10 ? progName + "000" + i + DUMP_EXT : (i < 100 ? progName + "00" + i + DUMP_EXT : (i < 1000 ? progName + "0" + i + DUMP_EXT : progName + i + DUMP_EXT));
                    File f = new File(fileName);
                    if (!f.createNewFile()) continue;
                    pf = new PrintWriter(new FileOutputStream(f));
                    pf.print(content);
                    return;
                }
            }
            catch (IOException _ex) {
                _ex.printStackTrace();
            }
            finally {
                if (pf != null) {
                    pf.close();
                }
            }
        }
    }
}

