/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import com.iscobol.rts.Base64;
import com.iscobol.rts.Config;
import com.iscobol.rts.Factory;
import com.iscobol.rts.File;
import com.iscobol.rts.HTTPData;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.JSONStream;
import com.iscobol.rts.RtsUtil;
import com.iscobol.rts.XMLStream;
import com.iscobol.types.PicX;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class HTTPClient {
    private static IHTTPClientHelper httpClientHelper;
    private String httpRequestMethod;
    private static int javaVersion;
    private static final Map<Integer, String> STATUS_CODES;
    private static final String eol;
    private final String K_POST = "POST";
    private final String K_PUT = "PUT";
    private final String K_PATCH = "PATCH";
    private final String K_DELETE = "DELETE";
    private final String K_HEAD = "HEAD";
    private HttpURLConnection httpConn;
    private Proxy proxy = null;
    private HTTPData.Params parameters;
    private ArrayList headerProperties;
    private String user;
    private String password;
    private int responseCode;
    private String responseMessage;
    private byte[] response;
    private String responseContentType;
    private LinkedHashMap<String, Attachment> responseAttachments;
    private String encoding;
    private String lastRequest;
    private Double connectTimeout = -1.0;
    private Double readTimeout = -1.0;
    private int debugFlg = Config.getProperty("iscobol.tracelevel", -1);
    private byte[] contentToLog = null;

    public String decodeHttpStatusCode(int code) {
        String res = STATUS_CODES.get(code);
        if (res == null) {
            return "Unknown Status Code";
        }
        return res;
    }

    private void setConnection(String strUrl) throws MalformedURLException, IOException {
        String lcu = strUrl.toLowerCase();
        this.logString(null, "===============================");
        this.logString(null, "Connection requested at " + new SimpleDateFormat("yyyy-MM-dd - HH:mm:ss.ms").format(new Date()));
        this.logString(null, "Connecting to: " + lcu);
        if (lcu.startsWith("https://")) {
            String prop = Config.getProperty(".net.ssl.trust_store", null);
            if (prop != null && prop.length() > 0 && !"*".equals(prop)) {
                System.setProperty("javax.net.ssl.trustStore", prop);
                prop = Config.getProperty(".net.ssl.trust_store_password", null);
                if (prop != null) {
                    System.setProperty("javax.net.ssl.trustStorePassword", prop);
                }
            }
        } else if (!strUrl.toLowerCase().startsWith("http://")) {
            strUrl = "http://" + strUrl;
        }
        URL url = new URL(strUrl);
        if (this.httpConn != null) {
            this.httpConn.disconnect();
            this.httpConn = null;
        }
        try {
            this.httpConn = this.proxy == null ? (HttpURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection(this.proxy);
        }
        catch (Exception ex) {
            this.logString(null, "An exception occurred opening connection:");
            this.logString(null, ex.getMessage());
            throw ex;
        }
        int ct = this.connectTimeout.intValue();
        int rt = this.readTimeout.intValue();
        this.httpConn.setConnectTimeout(ct >= 0 ? ct * 1000 : 0);
        this.httpConn.setReadTimeout(rt >= 0 ? rt * 1000 : 0);
        if (this.user != null) {
            String auth = this.password != null ? "Basic " + new String(Base64.encode((this.user + ":" + this.password).getBytes())) : "Bearer " + this.user;
            this.httpConn.setRequestProperty("Authorization", auth);
        }
        if (this.headerProperties != null) {
            int num = this.headerProperties.size();
            for (int i = 0; i < num; ++i) {
                HTTPData.Pair cp = (HTTPData.Pair)this.headerProperties.get(i);
                this.httpConn.setRequestProperty(cp.key, cp.value);
            }
        }
    }

    private void sendPostPut(HTTPData.ByteBuilder outContent) {
        OutputStream out = this.getOutputStream();
        try {
            out.write(outContent.getBytes(), 0, outContent.length());
            out.flush();
            if (this.isLoggingEnabled()) {
                this.contentToLog = (byte[])outContent.getBytes().clone();
            }
        }
        catch (Exception _ex) {
            this.logError(this.httpConn, _ex);
            throw new IscobolRuntimeException(_ex);
        }
    }

    private void sendPostPut(String outContent) {
        OutputStream out = this.getOutputStream();
        try {
            byte[] content = outContent.getBytes("UTF-8");
            out.write(content, 0, content.length);
            out.flush();
            if (this.isLoggingEnabled()) {
                this.contentToLog = (byte[])content.clone();
            }
        }
        catch (Exception _ex) {
            this.logError(this.httpConn, _ex);
            throw new IscobolRuntimeException(_ex);
        }
    }

    private OutputStream getOutputStream() {
        OutputStream out;
        try {
            out = this.httpConn.getOutputStream();
        }
        catch (SSLHandshakeException ex) {
            if (this.httpConn instanceof HttpsURLConnection && Config.getProperty("iscobol.http.ignore_certificates", false)) {
                HttpsURLConnection httpsConn = (HttpsURLConnection)this.httpConn;
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }};
                try {
                    SSLContext sc = SSLContext.getInstance("SSL");
                    sc.init(null, trustAllCerts, null);
                    httpsConn.setSSLSocketFactory(sc.getSocketFactory());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    out = this.httpConn.getOutputStream();
                }
                catch (Exception _ex) {
                    this.logError(this.httpConn, _ex);
                    throw new IscobolRuntimeException(_ex);
                }
            }
            this.logError(this.httpConn, ex);
            throw new IscobolRuntimeException(ex);
        }
        catch (Exception _ex) {
            this.logError(this.httpConn, _ex);
            throw new IscobolRuntimeException(_ex);
        }
        return out;
    }

    private void connectPost(String strUrl) {
        try {
            this.setConnection(strUrl);
        }
        catch (Exception _ex) {
            this.logError(this.httpConn, _ex);
            throw new IscobolRuntimeException(_ex);
        }
        try {
            this.httpConn.setRequestMethod("POST");
        }
        catch (Exception _ex) {
            this.logError(this.httpConn, _ex);
            throw new IscobolRuntimeException(_ex);
        }
        this.httpConn.setDoOutput(true);
        this.httpConn.setDoInput(true);
    }

    private void connectWithMethod(String strUrl, String verb) {
        this.httpRequestMethod = verb;
        try {
            this.setConnection(strUrl);
        }
        catch (Exception _ex) {
            this.logError(this.httpConn, _ex);
            throw new IscobolRuntimeException(_ex);
        }
        try {
            this.httpConn.setRequestMethod(verb);
        }
        catch (Exception _ex) {
            this.logError(this.httpConn, _ex);
            throw new IscobolRuntimeException(_ex);
        }
        this.httpConn.setDoOutput(true);
        this.httpConn.setDoInput(true);
    }

    private void doRequest() {
        String val;
        try {
            this.responseCode = this.httpConn.getResponseCode();
            this.responseMessage = this.decodeHttpStatusCode(this.responseCode);
        }
        catch (Exception _ex) {
            this.logError(this.httpConn, _ex);
            throw new IscobolRuntimeException(_ex);
        }
        this.logRequestContent();
        this.logString(this.httpConn, "");
        this.logString(this.httpConn, "Response code: " + this.responseCode);
        this.logString(this.httpConn, "Response Headers:");
        this.encoding = "UTF-8";
        int i = 0;
        while ((val = this.httpConn.getHeaderField(i)) != null) {
            int idx;
            String key = this.httpConn.getHeaderFieldKey(i);
            this.logString(this.httpConn, (key != null ? key + ":" : "") + val);
            if ("Content-Type".equalsIgnoreCase(key) && (idx = val.indexOf("charset=")) >= 0) {
                char c;
                this.encoding = "";
                for (int j = idx + 8; j < val.length() && (c = val.charAt(j)) != ' ' && c != ';'; ++j) {
                    this.encoding = this.encoding + c;
                }
            }
            ++i;
        }
        try {
            this.response = null;
            this.responseAttachments = null;
            InputStream isr = this.responseCode >= 400 ? this.httpConn.getErrorStream() : this.httpConn.getInputStream();
            byte[] buffer = new byte[8192];
            if (isr != null) {
                int rc;
                while ((rc = isr.read(buffer, 0, buffer.length)) >= 0) {
                    if (this.response == null) {
                        if (rc == buffer.length) {
                            this.response = buffer;
                            buffer = new byte[buffer.length];
                            continue;
                        }
                        this.response = new byte[rc];
                        System.arraycopy(buffer, 0, this.response, 0, rc);
                        continue;
                    }
                    byte[] newb = new byte[this.response.length + rc];
                    System.arraycopy(this.response, 0, newb, 0, this.response.length);
                    System.arraycopy(buffer, 0, newb, this.response.length, rc);
                    this.response = newb;
                }
            } else {
                this.response = new byte[0];
            }
            this.logResponseContent(this.response);
        }
        catch (Exception _ex) {
            this.logError(this.httpConn, _ex);
            throw new IscobolRuntimeException(_ex);
        }
    }

    public void setAuth(ICobolVar usr, ICobolVar pwd) {
        this.user = usr.toStringNoGui();
        this.password = pwd.toStringNoGui();
        if (httpClientHelper != null) {
            httpClientHelper.setAuth(usr, pwd);
        }
    }

    public void setAuth(ICobolVar tok) {
        this.user = tok.toStringNoGui();
        this.password = null;
        if (httpClientHelper != null) {
            httpClientHelper.setAuth(tok, null);
        }
    }

    private void setHeaderProperty(String key, String value) {
        if (this.headerProperties == null) {
            this.headerProperties = new ArrayList();
        }
        this.headerProperties.add(new HTTPData.Pair(key, value));
    }

    public void setHeaderProperty(ICobolVar key, ICobolVar value) {
        this.setHeaderProperty(key.toStringNoGui().trim(), value.toStringNoGui().trim());
    }

    public void getHeaderProperty(ICobolVar key, ICobolVar value) {
        if (this.httpConn != null) {
            String prop = this.httpConn.getHeaderField(key.toStringNoGui().trim());
            if (prop != null) {
                value.set(this.httpConn.getHeaderField(key.toStringNoGui().trim()));
            } else {
                value.set("");
            }
        }
    }

    public void setParameter(ICobolVar name, ICobolVar value) {
        if (this.parameters == null) {
            this.parameters = new HTTPData.Params();
        }
        this.parameters.add(name, value);
    }

    public void doPostEx(ICobolVar strUrl, ICobolVar content) {
        PicX type = Config.getProperty(".rest.default_stream", "json").equalsIgnoreCase("xml") ? Factory.getStrLiteral("application/xml") : Factory.getStrLiteral("application/json");
        this.doPostEx(strUrl, type, content);
    }

    public void doPostEx(ICobolVar strUrl, ICobolVar type, ICobolVar content) {
        this.httpRequestMethod = "POST";
        String contentType = type.toStringNoGui().trim();
        String url = this.getUrlString(strUrl);
        if (content.getIXMLAttributes() == null) {
            this.setHeaderProperty("Content-Type", contentType);
            this.connectWithMethod(url, "POST");
            this.sendPostPut(content.toStringNoGui().trim());
            this.lastRequest = this.buildRequestLog(content.toStringNoGui().trim());
        } else {
            XMLStream stream = contentType.contains("/json") ? new JSONStream(content) : new XMLStream(content);
            StringBuffer sb = new StringBuffer();
            stream.writeToStringBuffer(sb);
            Map<String, ICobolVar> mtomItems = stream.getMtomItems();
            if (!(stream instanceof JSONStream) && !mtomItems.isEmpty()) {
                HTTPData.Params p = new HTTPData.Params();
                p.list.add(new HTTPData.Pair("myenvelope", sb.toString(), "<rootpart@veryant.com>", 0));
                for (String key : mtomItems.keySet()) {
                    HTTPData.MPFile mpfile = new HTTPData.MPFile(key, key, null, "<" + key + ">", 2);
                    mpfile.contents = mtomItems.get(key).getBytes();
                    p.list.add(mpfile);
                    this.doPostMTOM(strUrl.toStringNoGui(), p);
                }
                return;
            }
            this.setHeaderProperty("Content-Type", contentType);
            this.connectWithMethod(url, "POST");
            this.sendPostPut(sb.toString());
            this.lastRequest = this.buildRequestLog(sb.toString());
        }
        this.doRequest();
    }

    private String getUrlString(String strUrl) {
        String url = strUrl.toString().trim();
        if (this.parameters != null) {
            StringBuffer newUrl = new StringBuffer(url);
            newUrl.append(url.indexOf(63) >= 0 ? "&" : "?");
            this.parameters.getUrlencodedParameters(newUrl);
            url = newUrl.toString();
            this.parameters = null;
        }
        return url;
    }

    private String getUrlString(ICobolVar strUrl) {
        String url = strUrl.toStringNoGui().trim();
        if (this.parameters != null) {
            StringBuffer newUrl = new StringBuffer(url);
            newUrl.append(url.indexOf(63) >= 0 ? "&" : "?");
            this.parameters.getUrlencodedParameters(newUrl);
            url = newUrl.toString();
            this.parameters = null;
        }
        return url;
    }

    public void doPostEx(ICobolVar strUrl, ICobolVar type, ICobolVar content, ICobolVar hasDummyRoot) {
        this.httpRequestMethod = "POST";
        String contentType = type.toStringNoGui().trim();
        String url = this.getUrlString(strUrl);
        if (content.getIXMLAttributes() == null) {
            this.setHeaderProperty("Content-Type", contentType);
            this.connectWithMethod(url, "POST");
            this.sendPostPut(content.toStringNoGui().trim());
        } else {
            XMLStream stream = contentType.contains("/json") ? new JSONStream(content, hasDummyRoot) : new XMLStream(content);
            StringBuffer sb = new StringBuffer();
            stream.writeToStringBuffer(sb);
            Map<String, ICobolVar> mtomItems = stream.getMtomItems();
            if (!(stream instanceof JSONStream) && !mtomItems.isEmpty()) {
                HTTPData.Params p = new HTTPData.Params();
                p.list.add(new HTTPData.Pair("myenvelope", sb.toString(), "<rootpart@veryant.com>", 0));
                for (String key : mtomItems.keySet()) {
                    HTTPData.MPFile mpfile = new HTTPData.MPFile(key, key, null, "<" + key + ">", 2);
                    mpfile.contents = mtomItems.get(key).getBytes();
                    p.list.add(mpfile);
                    this.doPostMTOM(strUrl.toStringNoGui(), p);
                }
                return;
            }
            this.setHeaderProperty("Content-Type", contentType);
            this.connectWithMethod(url, "POST");
            this.sendPostPut(sb.toString());
            this.lastRequest = this.buildRequestLog(sb.toString());
        }
        this.doRequest();
    }

    public void doPost(ICobolVar strUrl, HTTPData.Params p) {
        this.parameters = p;
        this.doPost(strUrl);
    }

    public void doPostMultipart(ICobolVar strUrl) {
        String boundary = "--------isCOBOL-FormBoundary-" + System.currentTimeMillis();
        this.setHeaderProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
        this.doPostMultipart0(strUrl.toStringNoGui(), boundary);
    }

    public void doPutMultipart(ICobolVar strUrl) {
        String boundary = "--------isCOBOL-FormBoundary-" + System.currentTimeMillis();
        this.setHeaderProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
        this.doPutMultipart0(strUrl.toStringNoGui(), boundary);
    }

    private void doPutMultipart0(String strUrl, String boundary) {
        this.connectWithMethod(strUrl.toString(), "PUT");
        if (this.parameters != null) {
            this.sendPostPut(this.parameters.getMultipartParameters(boundary));
            this.parameters = null;
        }
        this.doRequest();
    }

    private void doPostMTOM(String strUrl, HTTPData.Params p) {
        String boundary = "--------isCOBOL-FormBoundary-" + System.currentTimeMillis();
        this.parameters = p;
        this.setHeaderProperty("SOAPAction", "soap");
        this.setHeaderProperty("Content-Type", "multipart/related; type=\"application/xop+xml\"; start=\"<rootpart@veryant.com>\"; start-info=\"text/xml\"; boundary=" + boundary);
        this.doPostMultipart0(strUrl, boundary);
    }

    private void doPostMultipart0(String strUrl, String boundary) {
        this.connectPost(strUrl.toString());
        if (this.parameters != null) {
            this.sendPostPut(this.parameters.getMultipartParameters(boundary));
            this.parameters = null;
        }
        this.doRequest();
    }

    public void doPostMultipart(ICobolVar strUrl, HTTPData.Params p) {
        this.parameters = p;
        this.doPostMultipart(strUrl);
    }

    public void doPost(ICobolVar strUrl) {
        this.connectWithMethod(strUrl.toStringNoGui(), "POST");
        if (this.parameters != null) {
            StringBuffer outParms = new StringBuffer();
            this.parameters.getUrlencodedParameters(outParms);
            this.sendPostPut(outParms.toString());
            this.parameters = null;
        }
        this.doRequest();
        this.lastRequest = this.buildRequestLog();
        this.logString(null, this.lastRequest);
    }

    public void doGet(String strUrl, HTTPData.Params p) {
        this.parameters = p;
        this.doGet(strUrl);
    }

    public void doGet(String strUrl) {
        try {
            this.httpRequestMethod = "GET";
            String url = this.getUrlString(strUrl);
            this.setConnection(url);
            this.lastRequest = this.buildRequestLog();
            this.logString(null, this.lastRequest);
        }
        catch (Exception _ex) {
            throw new IscobolRuntimeException(_ex);
        }
        this.doRequest();
    }

    public void doHead(String strUrl, HTTPData.Params p) {
        this.parameters = p;
        this.doHead(strUrl);
    }

    public void doHead(String strUrl) {
        this.httpRequestMethod = "HEAD";
        if (this.parameters != null) {
            StringBuffer newUrl = new StringBuffer(strUrl);
            newUrl.append(strUrl.indexOf(63) >= 0 ? "&" : "?");
            this.parameters.getUrlencodedParameters(newUrl);
            strUrl = newUrl.toString();
            this.parameters = null;
        }
        try {
            this.connectWithMethod(strUrl, "HEAD");
        }
        catch (Exception _ex) {
            throw new IscobolRuntimeException(_ex);
        }
        this.doRequest();
    }

    public void doDeleteEx(ICobolVar strUrl, ICobolVar content) {
        PicX type = Config.getProperty(".rest.default_stream", "json").equalsIgnoreCase("xml") ? Factory.getStrLiteral("application/xml") : Factory.getStrLiteral("application/json");
        this.doActionEx("DELETE", strUrl, type, content, null);
    }

    public void doDeleteEx(ICobolVar strUrl, ICobolVar type, ICobolVar content) {
        this.doActionEx("DELETE", strUrl, type, content, null);
    }

    public void doDeleteEx(ICobolVar strUrl, ICobolVar type, ICobolVar content, ICobolVar hasDummyRoot) {
        this.doActionEx("DELETE", strUrl, type, content, hasDummyRoot);
    }

    public void doDelete(ICobolVar strUrl, HTTPData.Params p) {
        this.parameters = p;
        this.doDelete(strUrl);
    }

    public void doDelete(ICobolVar strUrl) {
        this.connectWithMethod(strUrl.toStringNoGui(), "DELETE");
        if (this.parameters != null) {
            StringBuffer outParms = new StringBuffer();
            this.parameters.getUrlencodedParameters(outParms);
            this.sendPostPut(outParms.toString());
            this.parameters = null;
        }
        this.doRequest();
        this.lastRequest = this.buildRequestLog();
        this.logString(null, this.lastRequest);
    }

    public void doPutEx(ICobolVar strUrl, ICobolVar content) {
        PicX type = Config.getProperty(".rest.default_stream", "json").equalsIgnoreCase("xml") ? Factory.getStrLiteral("application/xml") : Factory.getStrLiteral("application/json");
        this.doPutEx(strUrl, type, content);
    }

    public void doPutEx(ICobolVar strUrl, ICobolVar type, ICobolVar content) {
        String contentType = type.toStringNoGui().trim();
        String url = this.getUrlString(strUrl);
        if (content.getIXMLAttributes() == null) {
            this.setHeaderProperty("Content-Type", contentType);
            this.connectWithMethod(url, "PUT");
            this.sendPostPut(content.toStringNoGui().trim());
        } else {
            XMLStream stream = contentType.contains("/json") ? new JSONStream(content) : new XMLStream(content);
            StringBuffer sb = new StringBuffer();
            stream.writeToStringBuffer(sb);
            Map<String, ICobolVar> mtomItems = stream.getMtomItems();
            if (!(stream instanceof JSONStream) && !mtomItems.isEmpty()) {
                HTTPData.Params p = new HTTPData.Params();
                p.list.add(new HTTPData.Pair("myenvelope", sb.toString(), "<rootpart@veryant.com>", 0));
                for (String key : mtomItems.keySet()) {
                    HTTPData.MPFile mpfile = new HTTPData.MPFile(key, key, null, "<" + key + ">", 2);
                    mpfile.contents = mtomItems.get(key).getBytes();
                    p.list.add(mpfile);
                    this.doPostMTOM(strUrl.toStringNoGui(), p);
                }
                return;
            }
            this.setHeaderProperty("Content-Type", contentType);
            this.connectWithMethod(url, "PUT");
            this.sendPostPut(sb.toString());
            this.lastRequest = this.buildRequestLog(sb.toString());
        }
        this.doRequest();
    }

    public void doPutEx(ICobolVar strUrl, ICobolVar type, ICobolVar content, ICobolVar hasDummyRoot) {
        String contentType = type.toStringNoGui().trim();
        String url = this.getUrlString(strUrl);
        if (content.getIXMLAttributes() == null) {
            this.setHeaderProperty("Content-Type", contentType);
            this.connectWithMethod(url, "PUT");
            this.sendPostPut(content.toStringNoGui().trim());
            this.lastRequest = this.buildRequestLog(content.toStringNoGui().trim());
        } else {
            XMLStream stream = contentType.contains("/json") ? new JSONStream(content, hasDummyRoot) : new XMLStream(content);
            StringBuffer sb = new StringBuffer();
            stream.writeToStringBuffer(sb);
            Map<String, ICobolVar> mtomItems = stream.getMtomItems();
            if (!(stream instanceof JSONStream) && !mtomItems.isEmpty()) {
                HTTPData.Params p = new HTTPData.Params();
                p.list.add(new HTTPData.Pair("myenvelope", sb.toString(), "<rootpart@veryant.com>", 0));
                for (String key : mtomItems.keySet()) {
                    HTTPData.MPFile mpfile = new HTTPData.MPFile(key, key, null, "<" + key + ">", 2);
                    mpfile.contents = mtomItems.get(key).getBytes();
                    p.list.add(mpfile);
                    this.doPostMTOM(strUrl.toStringNoGui(), p);
                }
                return;
            }
            this.setHeaderProperty("Content-Type", contentType);
            this.connectWithMethod(url, "PUT");
            this.sendPostPut(sb.toString());
            this.lastRequest = this.buildRequestLog(sb.toString());
        }
        this.doRequest();
    }

    public void doPut(ICobolVar strUrl, HTTPData.Params p) {
        this.parameters = p;
        this.doPut(strUrl);
    }

    public void doPut(ICobolVar strUrl) {
        this.connectWithMethod(strUrl.toStringNoGui(), "PUT");
        if (this.parameters != null) {
            StringBuffer outParms = new StringBuffer();
            this.parameters.getUrlencodedParameters(outParms);
            this.sendPostPut(outParms.toString());
            this.parameters = null;
        }
        this.doRequest();
    }

    public void doPatchEx(ICobolVar strUrl, ICobolVar content) {
        PicX type = Config.getProperty(".rest.default_stream", "json").equalsIgnoreCase("xml") ? Factory.getStrLiteral("application/xml") : Factory.getStrLiteral("application/json");
        this.doPatchEx(strUrl, type, content, null);
    }

    public void doPatchEx(ICobolVar strUrl, ICobolVar type, ICobolVar content) {
        this.doPatchEx(strUrl, type, content, null);
    }

    public void doPatchEx(ICobolVar strUrl, ICobolVar type, ICobolVar content, ICobolVar hasDummyRoot) {
        this.httpRequestMethod = "PATCH";
        String url = this.getUrlString(strUrl);
        String contentType = type.toStringNoGui().trim();
        if (javaVersion > 8 && httpClientHelper != null) {
            try {
                if (this.parameters != null) {
                    httpClientHelper.setParameters(this.parameters);
                }
                if (this.headerProperties != null) {
                    httpClientHelper.setHeaderProperties(this.headerProperties);
                }
                httpClientHelper.setConnectionTimeout(this.connectTimeout.intValue());
                String strContent = this.cobVarToString(contentType, content, hasDummyRoot);
                httpClientHelper.doPatchEx(url, contentType, strContent, hasDummyRoot);
                this.responseCode = httpClientHelper.getResponseCode();
                this.responseMessage = httpClientHelper.getResponseMessage();
                this.response = httpClientHelper.getResponse();
                this.responseContentType = httpClientHelper.getContentType();
            }
            catch (Exception ex) {
                this.logString(this.httpConn, ex.getMessage());
            }
        } else {
            if (content.getIXMLAttributes() == null) {
                this.setHeaderProperty("Content-Type", contentType);
                HTTPClient.allowMethods("PATCH");
                this.connectWithMethod(url, "PATCH");
                this.sendPostPut(content.toStringNoGui().trim());
            } else {
                XMLStream stream = contentType.contains("/json") ? new JSONStream(content, hasDummyRoot) : new XMLStream(content);
                StringBuffer sb = new StringBuffer();
                stream.writeToStringBuffer(sb);
                Map<String, ICobolVar> mtomItems = stream.getMtomItems();
                if (!(stream instanceof JSONStream) && !mtomItems.isEmpty()) {
                    HTTPData.Params p = new HTTPData.Params();
                    p.list.add(new HTTPData.Pair("myenvelope", sb.toString(), "<rootpart@veryant.com>", 0));
                    for (String key : mtomItems.keySet()) {
                        HTTPData.MPFile mpfile = new HTTPData.MPFile(key, key, null, "<" + key + ">", 2);
                        mpfile.contents = mtomItems.get(key).getBytes();
                        p.list.add(mpfile);
                        this.doPostMTOM(strUrl.toStringNoGui(), p);
                    }
                    return;
                }
                this.setHeaderProperty("Content-Type", contentType);
                HTTPClient.allowMethods("PATCH");
                this.connectWithMethod(url, "PATCH");
                this.sendPostPut(sb.toString());
                this.lastRequest = this.buildRequestLog(sb.toString());
            }
            this.doRequest();
        }
    }

    public void doPatch(ICobolVar strUrl, HTTPData.Params p) {
        this.parameters = p;
        this.doPatch(strUrl);
    }

    public void doPatch(ICobolVar strUrl) {
        if (javaVersion > 8 && httpClientHelper != null) {
            try {
                String url = this.getUrlString(strUrl);
                Class<?> HTTPClientHelper2 = Class.forName("com.iscobol.rts.HTTPClientHelper");
                Constructor<?> constructor = HTTPClientHelper2.getConstructor(new Class[0]);
                IHTTPClientHelper httpClientHelper = (IHTTPClientHelper)constructor.newInstance(new Object[0]);
                if (this.parameters != null) {
                    httpClientHelper.setParameters(this.parameters);
                }
                if (this.headerProperties != null) {
                    httpClientHelper.setHeaderProperties(this.headerProperties);
                }
                httpClientHelper.setConnectionTimeout(this.connectTimeout.intValue());
                httpClientHelper.doPatchEx(url, null, null, null);
                this.responseCode = httpClientHelper.getResponseCode();
                this.responseMessage = httpClientHelper.getResponseMessage();
                this.response = httpClientHelper.getResponse();
                this.responseContentType = httpClientHelper.getContentType();
            }
            catch (Exception ex) {
                this.logString(this.httpConn, ex.getMessage());
            }
        } else {
            HTTPClient.allowMethods("PATCH");
            this.connectWithMethod(strUrl.toStringNoGui(), "PATCH");
            if (this.parameters != null) {
                StringBuffer outParms = new StringBuffer();
                this.parameters.getUrlencodedParameters(outParms);
                this.sendPostPut(outParms.toString());
                this.parameters = null;
            }
            this.doRequest();
        }
    }

    public void getResponseCode(ICobolVar rc) {
        rc.set(this.responseCode);
    }

    public void getResponseMessage(ICobolVar rc) {
        if (this.httpConn != null) {
            try {
                rc.set(this.responseMessage);
                this.logString(this.httpConn, "Response from server:");
                this.logString(this.httpConn, this.responseMessage);
            }
            catch (Exception _ex) {
                throw new IscobolRuntimeException(_ex);
            }
        } else {
            rc.set(new byte[]{32});
        }
    }

    private String getResponseString() {
        return this.getResponseString(this.response);
    }

    private String getResponseString(byte[] rsp) {
        if (rsp != null) {
            if (this.encoding != null) {
                try {
                    return new String(rsp, 0, rsp.length, this.encoding);
                }
                catch (UnsupportedEncodingException _ex) {
                    throw new IscobolRuntimeException(_ex);
                }
            }
            return new String(rsp, 0, rsp.length);
        }
        return "";
    }

    public void getResponsePlain(ICobolVar res) {
        if (this.response != null) {
            res.set(this.getResponseString());
        } else {
            res.set(new byte[]{32});
        }
    }

    public void getRequestPlain(ICobolVar res) {
        if (this.lastRequest != null) {
            res.set(this.lastRequest);
        } else {
            res.set(new byte[]{32});
        }
    }

    public void getResponseEx(ICobolVar res) {
        this.getResponseEx(res, null);
    }

    public void getResponseAttachmentIDs(ICobolVar res) {
        if (this.responseAttachments != null) {
            String ids = "";
            for (String id : this.responseAttachments.keySet()) {
                if (ids.length() > 0) {
                    ids = ids + ",";
                }
                ids = ids + id;
            }
            res.set(ids);
        }
    }

    public void getResponseAttachmentBody(ICobolVar id, ICobolVar res) {
        Attachment a;
        if (this.responseAttachments != null && (a = this.responseAttachments.get(id.toStringNoGui())) != null && a.body != null) {
            res.set(a.body);
        } else {
            res.set("");
        }
    }

    public void getResponseAttachmentAttrNames(ICobolVar id, ICobolVar res) {
        Attachment a;
        if (this.responseAttachments != null && (a = this.responseAttachments.get(id.toStringNoGui())) != null) {
            String names = "";
            for (String name : a.attrs.keySet()) {
                if (names.length() > 0) {
                    names = names + ",";
                }
                names = names + name;
            }
            res.set(names);
        } else {
            res.set("");
        }
    }

    public void getResponseAttachmentAttr(ICobolVar id, ICobolVar attrName, ICobolVar res) {
        String val;
        Attachment a;
        if (this.responseAttachments != null && (a = this.responseAttachments.get(id.toStringNoGui())) != null && (val = a.attrs.get(attrName.toStringNoGui())) != null) {
            res.set(val);
        } else {
            res.set("");
        }
    }

    public void getResponseEx(ICobolVar res, String encoding) {
        if (this.response != null) {
            this.responseAttachments = new LinkedHashMap();
            HashMap<String, PicX> mtomItems = null;
            boolean mtomEnabled = Config.getProperty("iscobol.http.mtom_enabled", false);
            String contentType = this.getResponseContentType();
            byte[] rsp = this.response;
            if (contentType.startsWith("multipart")) {
                String[] args = RtsUtil.parseArguments(contentType, ";");
                String start = null;
                byte[] boundaryStart = null;
                byte[] boundaryEnd = null;
                byte[] crlf = new byte[]{13, 10};
                for (String arg : args) {
                    String arglc = (arg = arg.trim()).toLowerCase();
                    if (arglc.startsWith("start=")) {
                        start = arg.substring(6);
                        continue;
                    }
                    if (!arglc.startsWith("boundary=")) continue;
                    boundaryStart = ("--" + arg.substring(9) + "\r\n").getBytes();
                    boundaryEnd = ("--" + arg.substring(9) + "--").getBytes();
                }
                if (boundaryStart != null) {
                    int endIdx;
                    int startIdx;
                    int fromIdx = 0;
                    while ((startIdx = RtsUtil.indexOf(this.response, boundaryStart, fromIdx)) >= 0 && ((endIdx = RtsUtil.indexOf(this.response, boundaryStart, startIdx + boundaryStart.length)) >= 0 || (endIdx = RtsUtil.indexOf(this.response, boundaryEnd, startIdx + boundaryStart.length)) >= 0)) {
                        int lineEndIdx;
                        fromIdx = endIdx;
                        byte[] part = new byte[endIdx - startIdx - boundaryStart.length];
                        System.arraycopy(this.response, startIdx + boundaryStart.length, part, 0, part.length);
                        byte[] partBody = null;
                        int lineStartIdx = 0;
                        Attachment attach = null;
                        while ((lineEndIdx = RtsUtil.indexOf(part, crlf, lineStartIdx)) >= 0) {
                            if (lineEndIdx == lineStartIdx) {
                                String partContentType;
                                partBody = new byte[part.length - lineStartIdx - crlf.length];
                                System.arraycopy(part, lineStartIdx + crlf.length, partBody, 0, partBody.length);
                                String partContentID = attach != null ? attach.attrs.get("content-id") : null;
                                String string = partContentType = attach != null ? attach.attrs.get("content-type") : null;
                                if (rsp == this.response && partBody != null && partContentID != null && start != null && partContentID.equals(start)) {
                                    rsp = partBody;
                                    if (partContentType != null) {
                                        contentType = partContentType;
                                    }
                                } else if (attach != null) {
                                    attach.body = partBody;
                                    this.responseAttachments.put(attach.attrs.get("content-id"), attach);
                                    if (mtomEnabled && partContentID != null && partContentID.length() > 2) {
                                        if (mtomItems == null) {
                                            mtomItems = new HashMap<String, PicX>();
                                        }
                                        mtomItems.put(partContentID.substring(1, partContentID.length() - 1), new PicX(attach.body));
                                    }
                                }
                                attach = null;
                            } else {
                                String line = new String(part, lineStartIdx, lineEndIdx - lineStartIdx);
                                int idx = line.indexOf(58);
                                if (idx > 0 && idx < line.length() - 1) {
                                    if (attach == null) {
                                        attach = new Attachment();
                                    }
                                    attach.attrs.put(line.substring(0, idx).trim(), line.substring(idx + 1).trim());
                                }
                            }
                            lineStartIdx = lineEndIdx + crlf.length;
                        }
                    }
                }
            }
            if (contentType.contains("xml") || Config.getProperty(".rest.default_stream", "json").equalsIgnoreCase("xml")) {
                this.getResponseXML(rsp, res, encoding, mtomItems);
            } else {
                this.getResponseJSON(rsp, res, encoding, null);
            }
        } else {
            res.set(new byte[]{32});
        }
    }

    public void getResponseXML(ICobolVar res) {
        this.getResponseXML(this.response, res, null, null);
    }

    public void getResponseXML(ICobolVar res, String encoding) {
        this.getResponseXML(this.response, res, encoding, null);
    }

    private void getResponseXML(byte[] rsp, ICobolVar res, String encoding, Map<String, ICobolVar> mtomItems) {
        if (rsp != null) {
            XMLStream xml = new XMLStream(res);
            xml.setMtomItems(mtomItems);
            if (encoding == null) {
                encoding = this.encoding;
            }
            xml.readFromStream(new ByteArrayInputStream(rsp), encoding);
        } else {
            res.set(new byte[]{32});
        }
    }

    public void getResponseJSON(ICobolVar res) {
        this.getResponseJSON(this.response, res, null, null);
    }

    public void getResponseJSON(ICobolVar res, String encoding) {
        this.getResponseJSON(this.response, res, encoding, null);
    }

    public void getResponseJSON(ICobolVar res, String encoding, ICobolVar hasDummyRoot) {
        this.getResponseJSON(this.response, res, encoding, hasDummyRoot);
    }

    private void getResponseJSON(byte[] rsp, ICobolVar res, String encoding, ICobolVar hasDummyRoot) {
        if (rsp != null) {
            JSONStream json = new JSONStream(res, hasDummyRoot);
            if (encoding == null) {
                encoding = this.encoding;
            }
            json.readFromStream(new ByteArrayInputStream(rsp), encoding);
        } else {
            res.set(new byte[]{32});
        }
    }

    public void saveResponseRaw(ICobolVar fileName) {
        try {
            FileOutputStream out = new FileOutputStream(File.get(fileName.toStringNoGui().trim()));
            out.write(this.response, 0, this.response.length);
            out.close();
        }
        catch (IOException _ex) {
            throw new IscobolRuntimeException(_ex);
        }
    }

    public String getMethod() {
        if (this.httpConn != null) {
            return this.httpConn.getRequestMethod();
        }
        return this.httpRequestMethod;
    }

    public void doActionEx(String action, ICobolVar strUrl, ICobolVar type, ICobolVar content) {
        String contentType = type.toStringNoGui().trim();
        if (content.getIXMLAttributes() == null) {
            this.setHeaderProperty("Content-Type", contentType);
            this.connectWithMethod(strUrl.toStringNoGui().trim(), action);
            this.sendPostPut(content.toStringNoGui().trim());
        } else {
            XMLStream stream = contentType.contains("/json") ? new JSONStream(content) : new XMLStream(content);
            StringBuffer sb = new StringBuffer();
            stream.writeToStringBuffer(sb);
            Map<String, ICobolVar> mtomItems = stream.getMtomItems();
            if (!(stream instanceof JSONStream) && !mtomItems.isEmpty()) {
                HTTPData.Params p = new HTTPData.Params();
                p.list.add(new HTTPData.Pair("myenvelope", sb.toString(), "<rootpart@veryant.com>", 0));
                for (String key : mtomItems.keySet()) {
                    HTTPData.MPFile mpfile = new HTTPData.MPFile(key, key, null, "<" + key + ">", 2);
                    mpfile.contents = mtomItems.get(key).getBytes();
                    p.list.add(mpfile);
                    this.doPostMTOM(strUrl.toStringNoGui(), p);
                }
                return;
            }
            this.setHeaderProperty("Content-Type", contentType);
            this.connectWithMethod(strUrl.toStringNoGui().trim(), action);
            this.sendPostPut(sb.toString());
            this.lastRequest = this.buildRequestLog(sb.toString());
        }
        this.doRequest();
    }

    public void doActionEx(String action, ICobolVar strUrl, ICobolVar type, ICobolVar content, ICobolVar hasDummyRoot) {
        this.httpRequestMethod = action;
        String contentType = type.toStringNoGui().trim();
        if (content.getIXMLAttributes() == null) {
            this.setHeaderProperty("Content-Type", contentType);
            this.connectWithMethod(strUrl.toStringNoGui().trim(), action);
            this.sendPostPut(content.toStringNoGui().trim());
        } else {
            XMLStream stream = contentType.contains("/json") ? new JSONStream(content, hasDummyRoot) : new XMLStream(content);
            StringBuffer sb = new StringBuffer();
            stream.writeToStringBuffer(sb);
            Map<String, ICobolVar> mtomItems = stream.getMtomItems();
            if (!(stream instanceof JSONStream) && !mtomItems.isEmpty()) {
                HTTPData.Params p = new HTTPData.Params();
                p.list.add(new HTTPData.Pair("myenvelope", sb.toString(), "<rootpart@veryant.com>", 0));
                for (String key : mtomItems.keySet()) {
                    HTTPData.MPFile mpfile = new HTTPData.MPFile(key, key, null, "<" + key + ">", 2);
                    mpfile.contents = mtomItems.get(key).getBytes();
                    p.list.add(mpfile);
                    this.doPostMTOM(strUrl.toStringNoGui(), p);
                }
                return;
            }
            this.setHeaderProperty("Content-Type", contentType);
            this.connectWithMethod(strUrl.toStringNoGui().trim(), action);
            this.sendPostPut(sb.toString());
            this.lastRequest = this.buildRequestLog(sb.toString());
        }
        this.doRequest();
    }

    private static void allowMethods(String ... methods) {
        try {
            Field methodsField = HttpURLConnection.class.getDeclaredField("methods");
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(methodsField, methodsField.getModifiers() & 0xFFFFFFEF);
            methodsField.setAccessible(true);
            String[] oldMethods = (String[])methodsField.get(null);
            LinkedHashSet<String> methodsSet = new LinkedHashSet<String>(Arrays.asList(oldMethods));
            methodsSet.addAll(Arrays.asList(methods));
            String[] newMethods = methodsSet.toArray(new String[0]);
            methodsField.set(null, newMethods);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setConnectTimeout(Double timeout) {
        this.connectTimeout = timeout;
    }

    public void setReadTimeout(Double timeout) {
        this.readTimeout = timeout;
    }

    public Double getConnectTimeout() {
        return this.connectTimeout;
    }

    public Double getReadTimeout() {
        return this.readTimeout;
    }

    public void setProxy(String host, int port) {
        if (javaVersion < 11 || httpClientHelper == null) {
            this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port));
        } else {
            httpClientHelper.setProxy(host, port);
        }
    }

    private String buildRequestLog() {
        return this.buildRequestLog(null);
    }

    private String buildRequestLog(String content) {
        String res = null;
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(eol);
            sb.append("URL: " + this.httpConn.getURL());
            sb.append(eol);
            sb.append(eol);
            sb.append("Method: " + this.httpConn.getRequestMethod());
            sb.append(eol);
            this.appendParameters(sb);
            this.appendHeaderFields(sb);
            res = this.safeGetResponseCode(this.httpConn);
            if (res != null) {
                sb.append(res);
            }
            res = sb.toString() + eol + eol + (content != null ? "Content:" + eol + content : "");
            this.logString(this.httpConn, res);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return res;
    }

    private void appendHeaderFields(StringBuilder sb) {
        try {
            Map<String, List<String>> headers = this.httpConn.getHeaderFields();
            if (headers.size() > 0) {
                sb.append("Request Headers:");
            }
            this.generateHeaderEntry(sb, headers);
            headers = this.httpConn.getRequestProperties();
            if (headers.size() > 0) {
                sb.append("Request Properties:");
            }
            this.generateHeaderEntry(sb, headers);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void appendParameters(StringBuilder sb) {
        try {
            if (this.httpConn.getHeaderFields().size() > 0) {
                sb.append("Header fields:");
                sb.append(eol);
                Map<String, List<String>> fields = this.httpConn.getHeaderFields();
                this.generateHeaderEntry(sb, fields);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void generateHeaderEntry(StringBuilder sb, Map<String, List<String>> headers) {
        try {
            for (String key : headers.keySet()) {
                sb.append(String.format("%s%s", key != null ? key + " = " : "", headers.get(key)));
                sb.append(eol);
            }
            if (headers.size() > 0) {
                sb.append(eol);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void logString(HttpURLConnection connection, String string) {
        block5: {
            if (Config.getProperty("iscobol.httpclient.logging", false) && Config.getProperty("iscobol.httpclient.logfile", null) != null) {
                String logFileName = Config.getProperty("iscobol.httpclient.logfile", null);
                try {
                    java.io.File file = new java.io.File(logFileName);
                    if (!file.exists()) {
                        java.io.File parent = file.getParentFile();
                        if (parent != null && !parent.exists() && !parent.mkdirs()) {
                            parent.mkdirs();
                        }
                        file.createNewFile();
                    }
                    FileWriter fw = new FileWriter(file, true);
                    BufferedWriter out = new BufferedWriter(fw);
                    out.write(string);
                    out.newLine();
                    out.close();
                }
                catch (IOException ex) {
                    if (this.debugFlg <= 10) break block5;
                    System.out.print(String.format("An error occurred creating HTTPClient logfile '%s'%sMessage: %s%s", logFileName, eol, ex.getMessage(), eol));
                }
            }
        }
    }

    private void logError(HttpURLConnection httpConn, Exception ex) {
        this.logString(httpConn, "================>");
        this.logString(httpConn, "An error occurred");
        this.logString(httpConn, String.format("URL: %s", httpConn.getURL().toString()));
        this.logString(httpConn, String.format("Method: %s", httpConn.getRequestMethod()));
        String msg = this.safeGetResponseCode(httpConn);
        if (msg != null) {
            this.logString(httpConn, msg);
        }
        this.logString(httpConn, "Exception class: " + ex.getClass().getName());
        this.logString(httpConn, "Exception message: " + ex.getLocalizedMessage());
        this.logString(httpConn, "<================");
    }

    private String getResponseContentType() {
        if (javaVersion < 11 || this.responseContentType == null) {
            this.responseContentType = this.httpConn.getHeaderField("Content-Type");
        }
        return this.responseContentType;
    }

    private String safeGetResponseCode(HttpURLConnection httpConn) {
        try {
            return String.format("Response code: %d - %s", httpConn.getResponseCode(), httpConn.getResponseMessage());
        }
        catch (Exception ex) {
            return null;
        }
    }

    private boolean isLoggingEnabled() {
        return Config.getProperty("iscobol.httpclient.logging", false);
    }

    private void logRequestContent() {
        if (this.isLoggingEnabled() && this.contentToLog != null) {
            this.logString(this.httpConn, "Request content:");
            this.logString(this.httpConn, new String(this.contentToLog));
        }
    }

    private void logResponseContent(byte[] response) {
        if (this.isLoggingEnabled()) {
            try {
                this.logString(this.httpConn, "Response content:");
                this.logString(this.httpConn, new String(response));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String cobVarToString(String contentType, ICobolVar content, ICobolVar hasDummyRoot) {
        if (contentType.contains("/json")) {
            try {
                JSONStream stream = new JSONStream(content, hasDummyRoot);
                StringBuffer sb = new StringBuffer();
                stream.writeToStringBuffer(sb);
                return sb.toString();
            }
            catch (Exception ex) {
                try {
                    return content.toStringNoGui().trim();
                }
                catch (Exception ex2) {
                    return "";
                }
            }
        }
        return "";
    }

    static {
        javaVersion = 8;
        STATUS_CODES = new HashMap<Integer, String>();
        STATUS_CODES.put(100, "Continue");
        STATUS_CODES.put(101, "Switching Protocols");
        STATUS_CODES.put(102, "Processing");
        STATUS_CODES.put(200, "OK");
        STATUS_CODES.put(201, "Created");
        STATUS_CODES.put(202, "Accepted");
        STATUS_CODES.put(203, "Non-Authoritative Information");
        STATUS_CODES.put(204, "No Content");
        STATUS_CODES.put(205, "Reset Content");
        STATUS_CODES.put(206, "Partial Content");
        STATUS_CODES.put(207, "Multi-Status");
        STATUS_CODES.put(208, "Already Reported");
        STATUS_CODES.put(226, "IM Used");
        STATUS_CODES.put(300, "Multiple Choices");
        STATUS_CODES.put(301, "Moved Permanently");
        STATUS_CODES.put(302, "Found");
        STATUS_CODES.put(303, "See Other");
        STATUS_CODES.put(304, "Not Modified");
        STATUS_CODES.put(305, "Use Proxy");
        STATUS_CODES.put(307, "Temporary Redirect");
        STATUS_CODES.put(308, "Permanent Redirect");
        STATUS_CODES.put(400, "Bad Request");
        STATUS_CODES.put(401, "Unauthorized");
        STATUS_CODES.put(402, "Payment Required");
        STATUS_CODES.put(403, "Forbidden");
        STATUS_CODES.put(404, "Not Found");
        STATUS_CODES.put(405, "Method Not Allowed");
        STATUS_CODES.put(406, "Not Acceptable");
        STATUS_CODES.put(407, "Proxy Authentication Required");
        STATUS_CODES.put(408, "Request Timeout");
        STATUS_CODES.put(409, "Conflict");
        STATUS_CODES.put(410, "Gone");
        STATUS_CODES.put(411, "Length Required");
        STATUS_CODES.put(412, "Precondition Failed");
        STATUS_CODES.put(413, "Payload Too Large");
        STATUS_CODES.put(414, "URI Too Long");
        STATUS_CODES.put(415, "Unsupported Media Type");
        STATUS_CODES.put(416, "Range Not Satisfiable");
        STATUS_CODES.put(417, "Expectation Failed");
        STATUS_CODES.put(418, "I'm a teapot");
        STATUS_CODES.put(421, "Misdirected Request");
        STATUS_CODES.put(422, "Unprocessable Entity");
        STATUS_CODES.put(423, "Locked");
        STATUS_CODES.put(424, "Failed Dependency");
        STATUS_CODES.put(426, "Upgrade Required");
        STATUS_CODES.put(428, "Precondition Required");
        STATUS_CODES.put(429, "Too Many Requests");
        STATUS_CODES.put(431, "Request Header Fields Too Large");
        STATUS_CODES.put(451, "Unavailable For Legal Reasons");
        STATUS_CODES.put(500, "Internal Server Error");
        STATUS_CODES.put(501, "Not Implemented");
        STATUS_CODES.put(502, "Bad Gateway");
        STATUS_CODES.put(503, "Service Unavailable");
        STATUS_CODES.put(504, "Gateway Timeout");
        STATUS_CODES.put(505, "HTTP Version Not Supported");
        STATUS_CODES.put(506, "Variant Also Negotiates");
        STATUS_CODES.put(507, "Insufficient Storage");
        STATUS_CODES.put(508, "Loop Detected");
        STATUS_CODES.put(510, "Not Extended");
        STATUS_CODES.put(511, "Network Authentication Required");
        String[] version = System.getProperty("java.version").split("\\.");
        javaVersion = Integer.parseInt(version[0]);
        if (javaVersion < 11) {
            httpClientHelper = null;
        } else {
            try {
                Class<?> c = Class.forName("com.iscobol.rts.HTTPClientHelper");
                Class<?> HTTPClientHelper2 = Class.forName("com.iscobol.rts.HTTPClientHelper");
                Constructor<?> constructor = HTTPClientHelper2.getConstructor(new Class[0]);
                httpClientHelper = (IHTTPClientHelper)constructor.newInstance(new Object[0]);
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
                httpClientHelper = null;
            }
        }
        eol = System.getProperty("line.separator", "\n");
    }

    static interface IHTTPClientHelper {
        public void setConnectionTimeout(int var1);

        public void setAuth(ICobolVar var1, ICobolVar var2);

        public void setParameters(HTTPData.Params var1);

        public void setHeaderProperties(ArrayList var1);

        public void setProxy(String var1, int var2);

        public void doPatchEx(String var1, String var2, String var3, ICobolVar var4) throws IOException, InterruptedException;

        public int getResponseCode();

        public byte[] getResponse();

        public String getResponseMessage();

        public String getContentType();

        public void test();
    }

    private static class Attachment
    implements Comparator<String> {
        byte[] body;
        Map<String, String> attrs = new TreeMap<String, String>(this);

        private Attachment() {
        }

        @Override
        public int compare(String o1, String o2) {
            return o1.compareToIgnoreCase(o2);
        }
    }
}

