/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts.print;

import com.iscobol.gui.GuiFactory;
import com.iscobol.rts.FileImage;
import com.iscobol.rts.UserHandles;
import com.iscobol.rts.print.PrintCommand;
import com.iscobol.rts.print.PrintContext;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.io.IOException;
import java.io.RandomAccessFile;

public class PrintBitmapSrv
extends PrintCommand {
    private Image bitmap;
    private int imageId;
    private double row;
    private double col;
    private double height;
    private double width;
    private boolean locCells;
    private boolean sizeCells;

    public PrintBitmapSrv(GuiFactory gf, int imageId, double row, double col, boolean locCells, double height, double width, boolean sizeCells) {
        super(gf, 14);
        this.imageId = imageId;
        Object lim = UserHandles.getId(imageId);
        this.bitmap = lim != null && lim instanceof FileImage ? ((FileImage)lim).getNativeImage() : null;
        this.row = row;
        this.col = col;
        this.locCells = locCells;
        this.height = height;
        this.width = width;
        this.sizeCells = sizeCells;
    }

    PrintBitmapSrv(GuiFactory gf, RandomAccessFile inOut) throws IOException {
        super(gf, 14);
        this.imageId = inOut.readInt();
        Object lim = UserHandles.getId(this.imageId);
        this.bitmap = lim != null && lim instanceof FileImage ? ((FileImage)lim).getNativeImage() : null;
        this.row = inOut.readDouble();
        this.col = inOut.readDouble();
        this.locCells = inOut.readBoolean();
        this.height = inOut.readDouble();
        this.width = inOut.readDouble();
        this.sizeCells = inOut.readBoolean();
    }

    @Override
    void toFile(RandomAccessFile inOut) throws IOException {
        inOut.writeInt(this.imageId);
        inOut.writeDouble(this.row);
        inOut.writeDouble(this.col);
        inOut.writeBoolean(this.locCells);
        inOut.writeDouble(this.height);
        inOut.writeDouble(this.width);
        inOut.writeBoolean(this.sizeCells);
    }

    @Override
    public boolean testPrint(PrintContext pc, Graphics2D g2d, PageFormat pf) {
        return this.print(pc, null, pf);
    }

    @Override
    public boolean print(PrintContext pc, Graphics2D g2d, PageFormat pf) {
        if (g2d != null) {
            if (this.locCells || this.sizeCells) {
                FontRenderContext frc = g2d.getFontRenderContext();
                TextLayout layout = new TextLayout("0", g2d.getFont(), frc);
                float fh = PrintBitmapSrv.getCellHeight(pc, layout);
                float fw = layout.getAdvance();
                if (this.locCells) {
                    if (this.sizeCells) {
                        PrintBitmapSrv.draw(g2d, this.bitmap, this.col * (double)fw, this.row * (double)fh, this.width * (double)fw, this.height * (double)fh);
                    } else {
                        PrintBitmapSrv.draw(g2d, this.bitmap, this.col * (double)fw, this.row * (double)fh, this.width, this.height);
                    }
                } else if (this.sizeCells) {
                    PrintBitmapSrv.draw(g2d, this.bitmap, this.col, this.row, this.width * (double)fw, this.height * (double)fh);
                }
            } else {
                PrintBitmapSrv.draw(g2d, this.bitmap, this.col, this.row, this.width, this.height);
            }
        }
        return true;
    }

    private static void draw(Graphics2D g2d, Image bitmap, double x, double y, double w, double h) {
        if (bitmap == null) {
            return;
        }
        AffineTransform scale = new AffineTransform();
        scale.translate(x, y);
        if (h == 0.0 && w == 0.0) {
            g2d.drawImage(bitmap, scale, null);
            return;
        }
        double imgWidth = bitmap.getWidth(null);
        double imgHeight = bitmap.getHeight(null);
        if (imgWidth == w && imgHeight == h) {
            g2d.drawImage(bitmap, scale, null);
            return;
        }
        if (h == 0.0 ^ w == 0.0) {
            if (h == 0.0) {
                h = w * (imgHeight / imgWidth);
            } else if (w == 0.0) {
                w = h * (imgWidth / imgHeight);
            }
        }
        scale.scale(w / imgWidth, h / imgHeight);
        g2d.drawImage(bitmap, scale, null);
    }
}

