/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types;

import com.iscobol.rts.Factory;
import com.iscobol.rts.IPicNumEdit;
import com.iscobol.types.CobolNum;
import com.iscobol.types.CobolVar;
import com.iscobol.types.EncBytes;
import com.iscobol.types.PicN;
import com.iscobol.types.PicNumEdit;
import com.iscobol.types.PicX;

public final class PicNumEditN
extends PicNumEdit
implements EncBytes,
IPicNumEdit {
    public PicNumEditN(byte[] m, int offs, int phisicLen, int[] dimSize, int[] dim, String name, String pic, boolean pComma, boolean blWhen0, char currChar) {
        super(m, offs, phisicLen, dimSize, dim, name, pic, pComma, blWhen0, currChar);
    }

    public PicNumEditN(CobolVar parent, int offs, int phisicLen, int[] dimSize, int[] dim, String name, String pic, boolean pComma, boolean blWhen0, char currChar) {
        super(parent, offs, phisicLen, dimSize, dim, name, pic, pComma, blWhen0, currChar);
    }

    public PicNumEditN(byte[] m, int offs, int phisicLen, int[] dimSize, int[] dim, String name, String pic, boolean pComma) {
        super(m, offs, phisicLen, dimSize, dim, name, pic, pComma);
    }

    public PicNumEditN(CobolVar parent, int offs, int phisicLen, int[] dimSize, int[] dim, String name, String pic, boolean pComma) {
        super(parent, offs, phisicLen, dimSize, dim, name, pic, pComma);
    }

    @Override
    void updateMemory(byte[] mem, CobolNum value) {
        if (value.signum() == 0) {
            if (this.blankWhenZero) {
                int end = this.curOffset + this.length();
                for (int i = this.curOffset; i < end; ++i) {
                    mem[i++] = 0;
                    mem[i] = C_SPACE;
                }
                return;
            }
            if (this.format.isStarWhenZero()) {
                int end = this.curOffset + this.length();
                int i = this.curOffset;
                int j = 0;
                while (i < end) {
                    mem[i++] = 0;
                    byte c = this.format.getByte(j);
                    mem[i] = c == 0 ? C_STAR : c;
                    ++i;
                    ++j;
                }
                return;
            }
        }
        super.updateMemory(mem, value);
    }

    @Override
    protected void internalSet(byte[] src, int srcOffs, int srcEnd, boolean isString, byte[] mem) {
        super.internalSet(src, srcOffs, srcEnd, isString, mem);
        if (Factory.UTF16LE) {
            int i = this.curOffset + this.getLength() - 1;
            for (int j = this.curOffset + this.getLen() - 1; i >= this.curOffset && j >= this.curOffset; --i, --j) {
                if (mem[i] == this.format.currencyByte) {
                    mem[j--] = (byte)((this.format.currencyChar & 0xFF00) >> 8);
                    mem[j] = (byte)(this.format.currencyChar & 0xFF);
                    continue;
                }
                mem[j--] = 0;
                mem[j] = mem[i];
            }
        } else {
            int i = this.curOffset + this.getLength() - 1;
            for (int j = this.curOffset + this.getLen() - 1; i >= this.curOffset && j >= this.curOffset; --i, --j) {
                if (mem[i] == this.format.currencyByte) {
                    mem[j--] = (byte)(this.format.currencyChar & 0xFF);
                    mem[j] = (byte)((this.format.currencyChar & 0xFF00) >> 8);
                    continue;
                }
                mem[j--] = mem[i];
                mem[j] = 0;
            }
        }
    }

    @Override
    void updateCache(byte[] mem, CobolNum cn) {
        if (checkNC != 0) {
            this.checkNumericContent();
        }
        String str = new String(PicN.byteToChar(mem, this.getOffset(), this.getLen()));
        cn.set(CobolNum.get(str, this.format.getDecLen()), false, false);
    }

    @Override
    public String toString() {
        return new String(PicN.byteToChar(this.getMemory(), this.getOffset(), this.getLen()));
    }

    @Override
    public CobolVar moveTo(PicX dest) {
        dest.set(this.toString());
        return this;
    }

    @Override
    public int getLength() {
        return this.getLen() / 2;
    }

    @Override
    public void valueToTable(CobolVar cv, int[] idxs, int[] nDim, int dim) {
        PicN value = new PicN(this.getMemory(), this.getOffset(), this.getMaxLength(), this.dimensionsSize, this.dimensions, null, this.isDecPointComma, this.isJustified);
        cv.moveToTable(value, idxs, nDim, dim);
    }
}

