/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.ast;

import com.veryant.cobol.compiler.Collector;
import com.veryant.cobol.compiler.Context;
import com.veryant.cobol.compiler.ast.AstNode;
import com.veryant.cobol.compiler.ast.AstStringLiteral;
import com.veryant.cobol.compiler.frontend.Token;
import java.util.ArrayList;

public class AstPicture
extends AstNode {
    public static final short NO_TYPE = 0;
    public static final short NUMERIC = 1;
    public static final short NUM_EDIT = 2;
    public static final short ALPHA = 4;
    public static final short ALPHA_NUM = 8;
    public static final short ALPHA_NUM_EDIT = 16;
    public static final short NATIONAL = 32;
    public static final short NATIONAL_EDIT = 64;
    public static final short BIT = 128;
    public static final short TYPE_MASK = 255;
    private char decimalChar = (char)46;
    private char thousandsChar = (char)44;
    private char currencyChar = (char)36;
    private ArrayList<Byte> editMask;
    private int type;
    private int size;
    private boolean signed;
    private int digits;
    private int scale;

    @Override
    public boolean isUniqueNode() {
        return true;
    }

    public boolean isEditedPicture() {
        return this.type == 16 || this.type == 2 || this.type == 64;
    }

    public byte[] getEditMask() {
        byte[] byArray = new byte[this.editMask.size()];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = this.editMask.get(i);
        }
        return byArray;
    }

    public AstPicture(Collector collector, Token token) {
        super(collector, token);
    }

    private void pushEditChar(int n) {
        byte by;
        if (this.editMask == null) {
            this.editMask = new ArrayList();
        }
        byte by2 = (byte)(n << 4 & 0xF0);
        int n2 = 0;
        if (!this.editMask.isEmpty() && by2 == (byte)((by = this.editMask.get(this.editMask.size() - 1).byteValue()) & 0xF0)) {
            n2 = (by & 0xF) + 1;
            this.editMask.remove(this.editMask.size() - 1);
        }
        do {
            this.editMask.add((byte)(by2 | n2 & 0xF));
        } while ((n2 >>= 4) != 0);
    }

    private boolean parse(byte[] byArray) {
        this.type = 255;
        int n = byArray.length;
        block14: for (int i = 0; i < n; ++i) {
            char c = (char)byArray[i];
            switch (c) {
                case '1': {
                    this.type &= 0x80;
                    continue block14;
                }
                case 'N': {
                    this.type &= 0x60;
                    continue block14;
                }
                case 'X': {
                    this.type &= 0x18;
                    continue block14;
                }
                case 'A': {
                    this.type &= 0x1C;
                    continue block14;
                }
                case '/': 
                case '0': 
                case 'B': {
                    this.type &= 0x52;
                    continue block14;
                }
                case '9': {
                    this.type &= 0x1B;
                    continue block14;
                }
                case 'S': {
                    this.type &= 1;
                    continue block14;
                }
                case 'P': 
                case 'V': {
                    this.type &= 3;
                    continue block14;
                }
                case '*': 
                case '+': 
                case '-': 
                case 'Z': {
                    this.type &= 2;
                    continue block14;
                }
                case 'C': {
                    if (i < n - 1 && byArray[i + 1] == 82) {
                        ++i;
                        this.type &= 2;
                        continue block14;
                    }
                    return false;
                }
                case 'D': {
                    if (i < n - 1 && byArray[i + 1] == 66) {
                        ++i;
                        this.type &= 2;
                        continue block14;
                    }
                    return false;
                }
                case '(': {
                    do {
                        if (++i >= n) {
                            return false;
                        }
                        c = (char)byArray[i];
                        if (c == ')') continue block14;
                    } while (Character.isDigit(c));
                    return false;
                }
                default: {
                    if (c == this.currencyChar || c == this.decimalChar || c == this.thousandsChar) {
                        this.type &= 2;
                        continue block14;
                    }
                    return false;
                }
            }
        }
        if (this.type == 0) {
            return false;
        }
        this.type = (this.type & 0x80) != 0 ? 128 : ((this.type & 1) != 0 ? 1 : ((this.type & 4) != 0 ? 4 : ((this.type & 0x20) != 0 ? 32 : ((this.type & 8) != 0 ? 8 : ((this.type & 2) != 0 ? 2 : ((this.type & 0x10) != 0 ? 16 : 64))))));
        return this.check(byArray);
    }

    private boolean check(byte[] byArray) {
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        int n = 0;
        int n2 = 0;
        int n3 = byArray.length;
        char c = ' ';
        this.size = 0;
        for (int i = 0; i < n3; ++i) {
            int n4;
            if (bl4) {
                return false;
            }
            char c2 = (char)byArray[i];
            if (bl5 && c2 != 'P') {
                return false;
            }
            if (i < n3 - 1 && byArray[i + 1] == 40) {
                char c3;
                n4 = 0;
                ++i;
                while ((c3 = (char)byArray[++i]) != ')') {
                    if ((n4 = 10 * n4 + (c3 - 48)) >= 0) continue;
                    this.errorNumberTooLarge();
                    while (c3 != ')') {
                        c3 = (char)byArray[++i];
                    }
                    n4 = 1;
                    break;
                }
            } else {
                n4 = 1;
            }
            while (n4 > 0) {
                if (this.isEditedPicture()) {
                    switch (c2) {
                        case 'B': {
                            this.pushEditChar(0);
                            break;
                        }
                        case '-': {
                            this.pushEditChar(1);
                            break;
                        }
                        case '+': {
                            this.pushEditChar(2);
                            break;
                        }
                        case '0': {
                            this.pushEditChar(3);
                            break;
                        }
                        case '9': {
                            this.pushEditChar(4);
                            break;
                        }
                        case 'Z': {
                            this.pushEditChar(5);
                            break;
                        }
                        case 'A': {
                            this.pushEditChar(5);
                            break;
                        }
                        case 'X': {
                            this.pushEditChar(5);
                            break;
                        }
                        case 'N': {
                            this.pushEditChar(5);
                            break;
                        }
                        case '*': {
                            this.pushEditChar(6);
                            break;
                        }
                        case '/': {
                            this.pushEditChar(7);
                            break;
                        }
                        case 'C': {
                            this.pushEditChar(11);
                            break;
                        }
                        case 'V': {
                            this.pushEditChar(12);
                            break;
                        }
                        case 'D': {
                            this.pushEditChar(13);
                            break;
                        }
                        case 'P': {
                            this.pushEditChar(14);
                            break;
                        }
                        default: {
                            if (c2 == this.decimalChar) {
                                this.pushEditChar(9);
                                break;
                            }
                            if (c2 == this.thousandsChar) {
                                this.pushEditChar(10);
                                break;
                            }
                            this.pushEditChar(8);
                        }
                    }
                }
                switch (c2) {
                    case 'A': 
                    case 'N': 
                    case 'X': {
                        bl2 = false;
                        this.size += n4;
                        n += n4;
                        n4 = 0;
                        break;
                    }
                    case '/': 
                    case '0': 
                    case 'B': {
                        bl2 = false;
                        this.size += n4;
                        n4 = 0;
                        break;
                    }
                    case '1': 
                    case '9': {
                        bl2 = false;
                        this.size += n4;
                        n += n4;
                        if (bl3) {
                            n2 += n4;
                        }
                        n4 = 0;
                        break;
                    }
                    case 'V': {
                        bl2 = false;
                        if (!bl3) {
                            bl3 = true;
                            break;
                        }
                        return false;
                    }
                    case 'S': {
                        if (bl2 && !bl6 && n2 == 0) {
                            bl6 = true;
                            break;
                        }
                        return false;
                    }
                    case 'P': {
                        if (bl2 && c == ' ') {
                            bl3 = true;
                            n2 += n4;
                            n4 = 0;
                            break;
                        }
                        if (!bl2 && !bl3) {
                            bl5 = true;
                            n2 -= n4;
                            n4 = 0;
                            break;
                        }
                        return false;
                    }
                    case '*': 
                    case 'Z': {
                        if (bl2) {
                            bl2 = false;
                            c = c2;
                            ++this.size;
                            ++n;
                            break;
                        }
                        if (c2 == c) {
                            ++this.size;
                            ++n;
                            if (!bl3) break;
                            ++n2;
                            break;
                        }
                        return false;
                    }
                    case '+': 
                    case '-': {
                        if (!bl6) {
                            bl6 = true;
                            boolean bl7 = bl4 = !bl2;
                            if (bl2) {
                                c = c2;
                            }
                            ++this.size;
                            break;
                        }
                        if (c2 == c) {
                            bl2 = false;
                            ++this.size;
                            ++n;
                            if (!bl3) break;
                            ++n2;
                            break;
                        }
                        return false;
                    }
                    case 'C': 
                    case 'D': {
                        if (!bl6) {
                            bl6 = true;
                            bl4 = true;
                            this.size += 2;
                            ++i;
                            break;
                        }
                        return false;
                    }
                    default: {
                        if (c2 == this.decimalChar) {
                            bl2 = false;
                            if (!bl3) {
                                ++this.size;
                                bl3 = true;
                                break;
                            }
                        } else {
                            if (c2 == this.thousandsChar) {
                                bl2 = false;
                                ++this.size;
                                break;
                            }
                            if (c2 == this.currencyChar) {
                                if (!bl && bl2) {
                                    bl = true;
                                    c = c2;
                                    ++this.size;
                                    break;
                                }
                                if (c2 == c) {
                                    bl2 = false;
                                    ++this.size;
                                    ++n;
                                    if (!bl3) break;
                                    ++n2;
                                    break;
                                }
                            }
                        }
                        return false;
                    }
                }
                --n4;
            }
        }
        if (n == 0) {
            this.errorPicNoSize();
        } else if (this.type == 1 || this.type == 2) {
            this.signed = bl6;
            this.digits = n;
            this.scale = -n2;
            if (this.digits > this.getContext().getARITH().getArithOption().getDigits()) {
                this.errorPicTooLarge();
            }
        }
        return true;
    }

    @Override
    public void validate() {
        AstStringLiteral astStringLiteral = (AstStringLiteral)this.getChild(0);
        byte[] byArray = astStringLiteral.getOperand().getValue().getBytes();
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)Character.toUpperCase(byArray[i]);
        }
        Context context = this.getContext();
        if (context.isDecimalPointIsComma()) {
            this.decimalChar = (char)44;
            this.thousandsChar = (char)46;
        }
        this.currencyChar = (char)context.getCurrencySymbol();
        if (byArray.length == 0) {
            this.errorEmptyPic();
        } else if (!this.parse(byArray)) {
            this.errorIllegalPic();
        }
    }

    private void errorNumberTooLarge() {
        this.consoleWrite(16, ((AstNode)this.getChild(0)).getToken(), new Object[0]);
    }

    private void errorPicNoSize() {
        this.consoleWrite(17, ((AstNode)this.getChild(0)).getToken(), new Object[0]);
    }

    private void errorPicTooLarge() {
        Token token = ((AstNode)this.getChild(0)).getToken();
        this.consoleWrite(19, token, token.image);
    }

    private void errorEmptyPic() {
        this.consoleWrite(18, ((AstNode)this.getChild(0)).getToken(), new Object[0]);
    }

    private void errorIllegalPic() {
        Token token = ((AstNode)this.getChild(0)).getToken();
        this.consoleWrite(15, token, token.image);
    }

    public int getType() {
        return this.type;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public int getDigits() {
        return this.digits;
    }

    public int getScale() {
        return this.scale;
    }
}

