/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.ast.statements;

import com.veryant.cobol.compiler.Collector;
import com.veryant.cobol.compiler.ast.AstNode;
import com.veryant.cobol.compiler.ast.AstOperandsList;
import com.veryant.cobol.compiler.ast.common.AstTo;
import com.veryant.cobol.compiler.ast.statements.AstUpDown;
import com.veryant.cobol.compiler.frontend.Token;
import com.veryant.cobol.compiler.stmts.Add;
import com.veryant.cobol.compiler.stmts.Move;
import com.veryant.cobol.compiler.stmts.Subtract;
import com.veryant.cobol.compiler.types.AbstractOperand;

public class AstSetStatement
extends AstNode {
    public AstSetStatement(Collector collector, Token token) {
        super(collector, token);
    }

    @Override
    public void walk() {
        AstOperandsList astOperandsList = this.getUniqueChild(AstOperandsList.class);
        AstTo astTo = this.getUniqueChild(AstTo.class);
        if (astTo != null) {
            this.getCode().addStatement(new Move(this.getToken(), astTo.getOperands()[0], astOperandsList.getOperands()[0]));
        } else {
            AstUpDown astUpDown = this.getUniqueChild(AstUpDown.class);
            if (astUpDown.isUp()) {
                this.getCode().addStatement(new Add(this.getToken(), new AbstractOperand[]{astUpDown.getAmount()}, astOperandsList.getOperands()));
            } else {
                this.getCode().addStatement(new Subtract(this.getToken(), new AbstractOperand[]{astUpDown.getAmount()}, astOperandsList.getOperands()));
            }
        }
    }
}

