/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.directives;

import com.veryant.cobol.compiler.Directives;
import com.veryant.cobol.compiler.directives.BaseDirective;
import com.veryant.cobol.compiler.directives.CCSID;
import com.veryant.cobol.compiler.directives.NUMPROC;
import com.veryant.cobol.exceptions.InvalidDirectiveException;

public final class CHARSET
extends BaseDirective {
    public static final String NAME = "CHARSET";
    private EnvironmentCharset environmentCharset;

    @Override
    public void setValues() throws InvalidDirectiveException {
        this.checkParameterCount(1);
        this.environmentCharset = this.getEnumValue(0, true, EnvironmentCharset.class);
        switch (this.environmentCharset) {
            case ASCII: {
                this.immediateSet = "DEFAULTBYTE\"32\" SIGN\"ASCII\" NATIVE\"ASCII\"";
                this.atEndSet = null;
                break;
            }
            case EBCDIC: {
                this.immediateSet = "DEFAULTBYTE\"0\"";
                this.atEndSet = "SIGN\"EBCDIC\" NATIVE\"EBCDIC\"";
            }
        }
    }

    @Override
    public BaseDirective checkCompatibility(Directives directives) {
        BaseDirective baseDirective;
        if (this.environmentCharset == EnvironmentCharset.EBCDIC && ((NUMPROC)(baseDirective = (NUMPROC)directives.getDirective(211))).getSystem() == NUMPROC.Systems.ACOS) {
            return baseDirective;
        }
        baseDirective = (CCSID)directives.getDirective(37);
        if (((CCSID)baseDirective).getCodepage().isAscii() && this.environmentCharset != EnvironmentCharset.ASCII) {
            return baseDirective;
        }
        if (!((CCSID)baseDirective).getCodepage().isAscii() && this.environmentCharset != EnvironmentCharset.EBCDIC) {
            return baseDirective;
        }
        return null;
    }

    @Override
    public boolean hasParameters() {
        return true;
    }

    @Override
    public boolean isNoAllowed() {
        return false;
    }

    @Override
    public BaseDirective.Set getSet() {
        return BaseDirective.Set.Init;
    }

    public EnvironmentCharset getEnvironmentCharset() {
        return this.environmentCharset;
    }

    public CHARSET(boolean bl) {
        super(bl, null, null);
    }

    @Override
    public int getIndex() {
        return 39;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public static enum EnvironmentCharset {
        ASCII,
        EBCDIC;

    }
}

