/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.directives;

import com.veryant.cobol.compiler.Directives;
import com.veryant.cobol.compiler.directives.BaseDirective;
import com.veryant.cobol.exceptions.InvalidDirectiveException;
import java.util.ArrayList;

public final class ILCUTPREFIX
extends BaseDirective {
    public static final String NAME = "ILCUTPREFIX";
    private ArrayList<String> prefixes;

    @Override
    protected void initialize() {
        this.prefixes = new ArrayList();
    }

    @Override
    public void setValues() throws InvalidDirectiveException {
        if (this.isNo() && this.getTokenCount() == 0) {
            this.prefixes.clear();
            return;
        }
        this.checkParameterCount(1);
        this.addPrefix(this.getTokenValue(0));
    }

    @Override
    protected boolean merge(BaseDirective.Phase phase, BaseDirective baseDirective) {
        for (String string : ((ILCUTPREFIX)baseDirective).prefixes) {
            this.addPrefix(string);
        }
        return true;
    }

    private Boolean addPrefix(String string) {
        if (!this.prefixes.contains(string = string.toUpperCase())) {
            this.prefixes.add(string);
            return true;
        }
        return false;
    }

    @Override
    public boolean hasParameters() {
        return true;
    }

    @Override
    public boolean isNoAllowed() {
        return true;
    }

    @Override
    public BaseDirective.Set getSet() {
        return BaseDirective.Set.Init;
    }

    public static void setDefault(Directives directives) throws InvalidDirectiveException {
        directives.setDefault("NOILCUTPREFIX");
    }

    public ArrayList<String> getPrefixes() {
        return this.prefixes;
    }

    public ILCUTPREFIX(boolean bl) {
        super(bl, null, null);
    }

    @Override
    public int getIndex() {
        return 147;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

