/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.emitters.jvm.core;

import com.veryant.cobol.compiler.ISourceReference;
import com.veryant.cobol.compiler.Magnitude;
import com.veryant.cobol.compiler.Operators;
import com.veryant.cobol.compiler.StringFormat;
import com.veryant.cobol.compiler.Utils;
import com.veryant.cobol.compiler.emitters.jvm.JvmCode;
import com.veryant.cobol.compiler.emitters.jvm.JvmCodeSnippet;
import com.veryant.cobol.compiler.emitters.jvm.Label;
import com.veryant.cobol.compiler.emitters.jvm.Local;
import com.veryant.cobol.compiler.emitters.jvm.MathPrecision;
import com.veryant.cobol.compiler.emitters.jvm.VMType;
import com.veryant.cobol.compiler.emitters.jvm.core.Errors;
import com.veryant.cobol.compiler.emitters.jvm.core.Functions;
import com.veryant.cobol.compiler.emitters.jvm.core.Templates;
import com.veryant.cobol.compiler.emitters.jvm.core.VMTypeEx;

public abstract class Opcodes {
    private static final String ZEROS = "0000000000000000000000000000000000000000";
    private static final String ONEZEROS = "10000000000000000000000000000000000000000";
    private static final String FIVEZEROS = "50000000000000000000000000000000000000000";
    private static final String F = ".0F";
    private static final String D = ".0D";

    public static void INJECT(JvmCode jvmCode, VMType vMType, String string, Magnitude magnitude) {
        jvmCode.push(vMType, string, magnitude);
    }

    public static void INJECT(JvmCode jvmCode, VMType vMType, String string) {
        Opcodes.INJECT(jvmCode, vMType, string, vMType.getDefaultMagnitude());
    }

    public static void INJECT(JvmCode jvmCode, String string) {
        Opcodes.INJECT(jvmCode, VMType.VOID, string);
    }

    public static void INJECT(JvmCode jvmCode, VMType vMType, StringFormat stringFormat, Magnitude magnitude) {
        int n = stringFormat.getArgumentsCount();
        if (n > 0) {
            JvmCodeSnippet[] jvmCodeSnippetArray = new JvmCodeSnippet[n];
            while (n-- > 0) {
                jvmCodeSnippetArray[n] = (JvmCodeSnippet)jvmCode.pop();
            }
            jvmCode.push(vMType, stringFormat, magnitude, (Object[])jvmCodeSnippetArray);
        } else {
            jvmCode.push(vMType, stringFormat.toString(), magnitude);
        }
    }

    public static void INJECT(JvmCode jvmCode, VMType vMType, StringFormat stringFormat) {
        Opcodes.INJECT(jvmCode, vMType, stringFormat, vMType.getDefaultMagnitude());
    }

    public static void INJECT(JvmCode jvmCode, StringFormat stringFormat) {
        Opcodes.INJECT(jvmCode, VMType.VOID, stringFormat);
    }

    public static void LOAD_CONST(JvmCode jvmCode, VMType vMType, boolean bl) {
        Opcodes.INJECT(jvmCode, VMTypeEx.VM_TYPE, bl ? vMType.getClassName() : vMType.getName());
    }

    public static void LOAD_CONST(JvmCode jvmCode, VMType vMType) {
        Opcodes.LOAD_CONST(jvmCode, vMType, true);
    }

    public static void LOAD_CONST(JvmCode jvmCode, int n) {
        Opcodes.INJECT(jvmCode, VMType.INT32, "" + n, new Magnitude(true, Functions.f_number_of_digits(n)));
    }

    public static void LOAD_CONST(JvmCode jvmCode, long l) {
        Opcodes.INJECT(jvmCode, VMType.INT64, l + "L", new Magnitude(true, Functions.f_number_of_digits(l)));
    }

    public static void LOAD_CONST(JvmCode jvmCode, float f) {
        Opcodes.INJECT(jvmCode, VMType.FLOAT32, f + "F", Magnitude.FLOAT);
    }

    public static void LOAD_CONST(JvmCode jvmCode, double d) {
        Opcodes.INJECT(jvmCode, VMType.FLOAT64, d + "D", Magnitude.DOUBLE);
    }

    public static void LOAD_CONST(JvmCode jvmCode, boolean bl) {
        Opcodes.INJECT(jvmCode, VMType.BOOLEAN, "" + bl);
    }

    public static void LOAD_CONST(JvmCode jvmCode, String string) {
        Opcodes.INJECT(jvmCode, VMType.STRING, Utils.quoteString(string));
    }

    public static void LOAD_LOCAL(JvmCode jvmCode, Local local) {
        Opcodes.INJECT(jvmCode, local.getVmType(), local.getName(), local.getMagnitude());
    }

    public static void LOAD_SCALER(JvmCode jvmCode, int n) {
        Opcodes.LOAD_SCALER(jvmCode, n, 0);
    }

    public static void LOAD_SCALER(JvmCode jvmCode, int n, int n2) {
        Magnitude magnitude = new Magnitude(false, 1 + n, n2);
        if (n > VMType.INT32.getDefaultMagnitude().getDigits()) {
            Opcodes.INJECT(jvmCode, VMType.INT64, ONEZEROS.substring(0, magnitude.getDigits()) + "L", magnitude);
        } else {
            Opcodes.INJECT(jvmCode, VMType.INT32, ONEZEROS.substring(0, magnitude.getDigits()), magnitude);
        }
    }

    public static void LOAD_ROUNDER(JvmCode jvmCode, int n, int n2) {
        Magnitude magnitude = new Magnitude(false, n, n2);
        if (n > VMType.INT32.getDefaultMagnitude().getDigits()) {
            Opcodes.INJECT(jvmCode, VMType.INT64, FIVEZEROS.substring(0, magnitude.getDigits()) + "L", magnitude);
        } else {
            Opcodes.INJECT(jvmCode, VMType.INT32, FIVEZEROS.substring(0, magnitude.getDigits()), magnitude);
        }
    }

    public static void STORE_LOCAL(JvmCode jvmCode, Local local) {
        Opcodes.INJECT(jvmCode, VMType.VOID, "" + local.getName() + '=' + Opcodes.cast((JvmCodeSnippet)jvmCode.pop(), local.getVmType()) + ';');
    }

    public static Local STORE_LOCAL(JvmCode jvmCode) {
        return Opcodes.STORE_LOCAL(jvmCode, jvmCode.nextFreeIdentifier());
    }

    public static Local STORE_LOCAL(JvmCode jvmCode, String string) {
        JvmCodeSnippet jvmCodeSnippet = (JvmCodeSnippet)jvmCode.pop();
        VMType vMType = (VMType)jvmCodeSnippet.getVmType();
        if (vMType == VMType.ADDRESS) {
            jvmCode.push(VMType.VOID, VMTypeEx.DATA_REF.getClassName() + ' ' + string + "=new " + VMTypeEx.DATA_REF.getClassName() + '(' + jvmCodeSnippet + ");");
            return new Local(VMTypeEx.DATA_REF, string);
        }
        jvmCode.push(VMType.VOID, vMType.getClassName() + ' ' + string + '=' + jvmCodeSnippet + ';');
        return new Local(vMType, string, jvmCodeSnippet.getMagnitude());
    }

    public static Local[] STORE_LOCALS(JvmCode jvmCode, int n) {
        Local[] localArray = new Local[n];
        while (n > 0) {
            localArray[--n] = Opcodes.STORE_LOCAL(jvmCode);
        }
        return localArray;
    }

    public static Local DUP_LOCAL(JvmCode jvmCode, Local local) {
        Opcodes.LOAD_LOCAL(jvmCode, local);
        return Opcodes.STORE_LOCAL(jvmCode);
    }

    public static void GET_MEMORY(JvmCode jvmCode, Local local) {
        if (local.getVmType() == VMTypeEx.IMEMORY) {
            Opcodes.INJECT(jvmCode, VMTypeEx.BYTE, local + ".get(" + Opcodes.cast((JvmCodeSnippet)jvmCode.pop(), VMType.INT32) + ")");
            return;
        }
        throw Errors.e_imemory_expected(local.getVmType());
    }

    public static void PUT_MEMORY(JvmCode jvmCode, Local local) {
        if (local.getVmType() == VMTypeEx.IMEMORY) {
            Opcodes.INJECT(jvmCode, VMType.VOID, local + ".put(" + Opcodes.cast((JvmCodeSnippet)jvmCode.pop(), VMType.INT32) + ", " + jvmCode.pop() + ");");
            return;
        }
        throw Errors.e_imemory_expected(local.getVmType());
    }

    private static Magnitude flattening(JvmCode jvmCode, Operators operators, MathPrecision mathPrecision, int n, boolean bl) {
        VMType vMType;
        Magnitude magnitude;
        int n2 = operators.getOperandsCount();
        int n3 = 0;
        int n4 = n2;
        Magnitude[] magnitudeArray = new Magnitude[n2];
        while (n4-- > 0) {
            magnitudeArray[n4] = ((JvmCodeSnippet)jvmCode.peek(n3--)).getMagnitude();
            if (mathPrecision == MathPrecision.NO_PRECISION) {
                if (!magnitudeArray[n4].isFloatingPoint()) continue;
                mathPrecision = MathPrecision.FLOATING_POINT_PRECISION;
                break;
            }
            if (mathPrecision != MathPrecision.FIXED_POINT_PRECISION || !magnitudeArray[n4].isFloatingPoint()) continue;
            throw Errors.e_types_system_fail();
        }
        switch (mathPrecision) {
            case FLOATING_POINT_PRECISION: {
                magnitude = Magnitude.DOUBLE;
                vMType = VMType.FLOAT64;
                break;
            }
            default: {
                magnitude = Operators.intermediate(operators, n, magnitudeArray);
                vMType = VMType.from(magnitude);
            }
        }
        Opcodes.CAST(jvmCode, vMType, n2);
        if (bl && vMType.isPrimitiveInteger()) {
            Opcodes.SCALE(jvmCode, magnitude.getScale(), n2);
        }
        return magnitude;
    }

    private static void relationalCondition(JvmCode jvmCode, Operators operators, StringFormat stringFormat, StringFormat stringFormat2, StringFormat stringFormat3) {
        if (Functions.f_type_peeking(jvmCode, VMType.ADDRESS, VMType.ADDRESS)) {
            Opcodes.INJECT(jvmCode, VMType.BOOLEAN, stringFormat);
        } else if (Functions.f_is_numeric_peek(jvmCode, 2)) {
            Magnitude magnitude = Opcodes.flattening(jvmCode, operators, MathPrecision.NO_PRECISION, Integer.MIN_VALUE, true);
            if (VMType.from(magnitude) == VMType.INT128) {
                Opcodes.INJECT(jvmCode, VMType.BOOLEAN, stringFormat2);
            } else {
                Opcodes.INJECT(jvmCode, VMType.BOOLEAN, stringFormat3);
            }
        } else {
            Opcodes.INJECT(jvmCode, VMType.BOOLEAN, stringFormat3);
        }
    }

    public static void EQ(JvmCode jvmCode) {
        Opcodes.relationalCondition(jvmCode, Operators.EQ, Templates.T_ALPHA_EQ, Templates.T_CBD_EQ, Templates.T_SIMPLE_EQ);
    }

    public static void NE(JvmCode jvmCode) {
        Opcodes.relationalCondition(jvmCode, Operators.NE, Templates.T_ALPHA_NE, Templates.T_CBD_NE, Templates.T_SIMPLE_NE);
    }

    public static void LE(JvmCode jvmCode) {
        Opcodes.relationalCondition(jvmCode, Operators.LE, Templates.T_ALPHA_LE, Templates.T_CBD_LE, Templates.T_SIMPLE_LE);
    }

    public static void LT(JvmCode jvmCode) {
        Opcodes.relationalCondition(jvmCode, Operators.LT, Templates.T_ALPHA_LT, Templates.T_CBD_LT, Templates.T_SIMPLE_LT);
    }

    public static void GE(JvmCode jvmCode) {
        Opcodes.relationalCondition(jvmCode, Operators.GE, Templates.T_ALPHA_GE, Templates.T_CBD_GE, Templates.T_SIMPLE_GE);
    }

    public static void GT(JvmCode jvmCode) {
        Opcodes.relationalCondition(jvmCode, Operators.GT, Templates.T_ALPHA_GT, Templates.T_CBD_GT, Templates.T_SIMPLE_GT);
    }

    public static void AND(JvmCode jvmCode) {
        Functions.f_type_checking(jvmCode, VMType.BOOLEAN, VMType.BOOLEAN);
        Opcodes.INJECT(jvmCode, VMType.BOOLEAN, Templates.T_BOOL_AND);
    }

    public static void OR(JvmCode jvmCode) {
        Functions.f_type_checking(jvmCode, VMType.BOOLEAN, VMType.BOOLEAN);
        Opcodes.INJECT(jvmCode, VMType.BOOLEAN, Templates.T_BOOL_OR);
    }

    public static void NOT(JvmCode jvmCode) {
        Functions.f_type_checking(jvmCode, VMType.BOOLEAN);
        Opcodes.INJECT(jvmCode, VMType.BOOLEAN, Templates.T_BOOL_NOT);
    }

    public static void INC(JvmCode jvmCode) {
        Opcodes.LOAD_CONST(jvmCode, 1);
        Opcodes.ADD(jvmCode);
    }

    public static void DEC(JvmCode jvmCode) {
        Opcodes.LOAD_CONST(jvmCode, 1);
        Opcodes.SUB(jvmCode);
    }

    public static void ADD(JvmCode jvmCode) {
        Opcodes.ADD(jvmCode, MathPrecision.NO_PRECISION);
    }

    public static void ADD(JvmCode jvmCode, MathPrecision mathPrecision) {
        Functions.f_is_numeric_check(jvmCode, 2);
        Magnitude magnitude = Opcodes.flattening(jvmCode, Operators.ADD, mathPrecision, Integer.MIN_VALUE, true);
        VMType vMType = VMType.from(magnitude);
        Opcodes.INJECT(jvmCode, vMType, vMType == VMType.INT128 ? Templates.T_CBD_ADD : Templates.T_SIMPLE_ADD, magnitude);
    }

    public static void SUB(JvmCode jvmCode) {
        Opcodes.SUB(jvmCode, MathPrecision.NO_PRECISION);
    }

    public static void SUB(JvmCode jvmCode, MathPrecision mathPrecision) {
        Functions.f_is_numeric_check(jvmCode, 2);
        Magnitude magnitude = Opcodes.flattening(jvmCode, Operators.SUB, mathPrecision, Integer.MIN_VALUE, true);
        VMType vMType = VMType.from(magnitude);
        Opcodes.INJECT(jvmCode, vMType, vMType == VMType.INT128 ? Templates.T_CBD_SUB : Templates.T_SIMPLE_SUB, magnitude);
    }

    public static void MUL(JvmCode jvmCode) {
        Opcodes.MUL(jvmCode, MathPrecision.NO_PRECISION);
    }

    public static void MUL(JvmCode jvmCode, MathPrecision mathPrecision) {
        Functions.f_is_numeric_check(jvmCode, 2);
        Magnitude magnitude = Opcodes.flattening(jvmCode, Operators.MUL, mathPrecision, Integer.MIN_VALUE, false);
        VMType vMType = VMType.from(magnitude);
        if (vMType == VMType.INT128) {
            Opcodes.LOAD_CONST(jvmCode, magnitude.getScale());
            Opcodes.INJECT(jvmCode, vMType, Templates.T_CBD_MUL, magnitude);
        } else {
            Opcodes.INJECT(jvmCode, vMType, Templates.T_SIMPLE_MUL, magnitude);
        }
    }

    public static void DIV(JvmCode jvmCode) {
        Opcodes.DIV(jvmCode, MathPrecision.NO_PRECISION);
    }

    public static void DIV(JvmCode jvmCode, MathPrecision mathPrecision) {
        Opcodes.DIV(jvmCode, mathPrecision, Integer.MIN_VALUE, false);
    }

    public static void DIV(JvmCode jvmCode, MathPrecision mathPrecision, int n, boolean bl) {
        Functions.f_is_numeric_check(jvmCode, 2);
        Magnitude magnitude = Opcodes.flattening(jvmCode, Operators.DIV, mathPrecision, Integer.MIN_VALUE, false);
        VMType vMType = (VMType)((JvmCodeSnippet)jvmCode.peek()).getVmType();
        if (vMType == VMType.INT128) {
            Opcodes.LOAD_CONST(jvmCode, n);
            Opcodes.LOAD_CONST(jvmCode, bl);
            Opcodes.INJECT(jvmCode, vMType, Templates.T_CBD_DIV, magnitude);
        } else {
            Opcodes.INJECT(jvmCode, vMType, Templates.T_SIMPLE_DIV, magnitude);
        }
    }

    public static void DIV_REM(JvmCode jvmCode) {
        Opcodes.DIV_REM(jvmCode, MathPrecision.NO_PRECISION);
    }

    public static void DIV_REM(JvmCode jvmCode, MathPrecision mathPrecision) {
        Opcodes.DIV_REM(jvmCode, mathPrecision, Integer.MIN_VALUE, false);
    }

    public static void DIV_REM(JvmCode jvmCode, MathPrecision mathPrecision, int n, boolean bl) {
        Functions.f_is_numeric_check(jvmCode, 2);
        Magnitude magnitude = Opcodes.flattening(jvmCode, Operators.DIV, mathPrecision, Integer.MIN_VALUE, false);
        VMType vMType = (VMType)((JvmCodeSnippet)jvmCode.peek()).getVmType();
        if (vMType == VMType.INT128) {
            Opcodes.LOAD_CONST(jvmCode, n);
            Opcodes.LOAD_CONST(jvmCode, bl);
            Opcodes.INJECT(jvmCode, vMType, Templates.T_CBD_DIV_REM, magnitude);
            Local local = Opcodes.STORE_LOCAL(jvmCode);
            Opcodes.LOAD_LOCAL(jvmCode, local);
            Opcodes.INJECT(jvmCode, VMType.INT128, Templates.T_CBD_QUO, magnitude);
            Opcodes.LOAD_LOCAL(jvmCode, local);
            Opcodes.INJECT(jvmCode, VMType.INT128, Templates.T_CBD_REM, magnitude);
        } else {
            Opcodes.INJECT(jvmCode, vMType, Templates.T_SIMPLE_DIV, magnitude);
            Opcodes.LOAD_CONST(jvmCode, 0);
        }
    }

    public static void NEG(JvmCode jvmCode) {
        Opcodes.NEG(jvmCode, MathPrecision.NO_PRECISION);
    }

    public static void NEG(JvmCode jvmCode, MathPrecision mathPrecision) {
        VMType vMType;
        if (mathPrecision == MathPrecision.FLOATING_POINT_PRECISION) {
            Opcodes.CAST(jvmCode, VMType.FLOAT64);
        }
        if ((vMType = (VMType)((JvmCodeSnippet)jvmCode.peek()).getVmType()) == VMType.INT128) {
            Opcodes.INJECT(jvmCode, vMType, Templates.T_CBD_NEG);
        } else {
            Opcodes.INJECT(jvmCode, vMType, Templates.T_SIMPLE_NEG);
        }
    }

    public static void POW(JvmCode jvmCode) {
        Opcodes.POW(jvmCode, MathPrecision.NO_PRECISION);
    }

    public static void POW(JvmCode jvmCode, MathPrecision mathPrecision) {
        Functions.f_is_numeric_check(jvmCode, 2);
        Magnitude magnitude = Opcodes.flattening(jvmCode, Operators.POW, mathPrecision, Integer.MIN_VALUE, false);
        VMType vMType = (VMType)((JvmCodeSnippet)jvmCode.peek()).getVmType();
        if (vMType == VMType.INT128) {
            Opcodes.INJECT(jvmCode, VMType.INT128, Templates.T_CBD_POWER, magnitude);
        } else {
            Opcodes.CAST(jvmCode, VMType.FLOAT64, 2);
            Opcodes.INJECT(jvmCode, VMType.INT128, Templates.T_SIMPLE_POWER, VMType.FLOAT64.getDefaultMagnitude());
        }
    }

    public static void BITWISE_OR(JvmCode jvmCode) {
        Opcodes.INJECT(jvmCode, VMType.INT32, Templates.T_BITWISE_OR);
    }

    public static void BITWISE_AND(JvmCode jvmCode) {
        Opcodes.INJECT(jvmCode, VMType.INT32, Templates.T_BITWISE_AND);
    }

    public static void TRUNC(JvmCode jvmCode, int n, int n2) {
        JvmCodeSnippet jvmCodeSnippet = (JvmCodeSnippet)jvmCode.peek();
        boolean bl = jvmCodeSnippet.getMagnitude().isSigned();
        Magnitude magnitude = new Magnitude(bl, n, n2);
        if (jvmCodeSnippet.getVmType() == VMType.INT128) {
            VMType vMType = VMType.from(magnitude);
            Opcodes.LOAD_CONST(jvmCode, n);
            Opcodes.LOAD_CONST(jvmCode, n2);
            Opcodes.LOAD_CONST(jvmCode, bl);
            Opcodes.INJECT(jvmCode, vMType, vMType == VMType.INT64 ? Templates.T_CBD_TO_LONG : Templates.T_CBD_TO_INT, magnitude);
            return;
        }
        Opcodes.SCALE(jvmCode, n2);
        if (jvmCodeSnippet.getMagnitude().getDigits() > n) {
            Opcodes.LOAD_SCALER(jvmCode, n);
            Opcodes.INJECT(jvmCode, (VMType)jvmCodeSnippet.getVmType(), Templates.T_SIMPLE_MOD, magnitude);
        }
    }

    private static JvmCodeSnippet scale(JvmCodeSnippet jvmCodeSnippet, int n) {
        Magnitude magnitude = jvmCodeSnippet.getMagnitude();
        int n2 = magnitude.getScale() - n;
        Magnitude magnitude2 = new Magnitude(magnitude.isSigned(), magnitude.getDigits() + n2, n);
        VMType vMType = VMType.from(magnitude2);
        if (vMType.isPrimitiveInteger()) {
            String string = (vMType == VMType.INT16 ? "(short)" : "") + ONEZEROS.substring(0, Math.abs(n2) + 1) + (vMType == VMType.INT64 ? Character.valueOf('L') : "");
            if (n2 > 0) {
                return new JvmCodeSnippet((ISourceReference)jvmCodeSnippet, vMType, Templates.T_SIMPLE_MUL.format(jvmCodeSnippet, string), magnitude2);
            }
            if (n2 < 0) {
                return new JvmCodeSnippet((ISourceReference)jvmCodeSnippet, vMType, Templates.T_SIMPLE_DIV.format(jvmCodeSnippet, string), magnitude2);
            }
        }
        return jvmCodeSnippet;
    }

    public static void SCALE(JvmCode jvmCode, int n) {
        Opcodes.SCALE(jvmCode, n, 1);
    }

    public static void SCALE(JvmCode jvmCode, int n, int n2) {
        if (n2 == 1) {
            jvmCode.push(Opcodes.scale((JvmCodeSnippet)jvmCode.pop(), n));
        } else if (n2 > 1) {
            JvmCodeSnippet[] jvmCodeSnippetArray = new JvmCodeSnippet[n2];
            while (n2-- > 0) {
                jvmCodeSnippetArray[n2] = (JvmCodeSnippet)jvmCode.pop();
            }
            for (JvmCodeSnippet jvmCodeSnippet : jvmCodeSnippetArray) {
                jvmCode.push(Opcodes.scale(jvmCodeSnippet, n));
            }
        }
    }

    public static void ROUND(JvmCode jvmCode, int n) {
        Functions.f_is_numeric_check(jvmCode, 1);
        Magnitude magnitude = ((JvmCodeSnippet)jvmCode.peek()).getMagnitude();
        if (((JvmCodeSnippet)jvmCode.peek()).getVmType() == VMType.INT128) {
            Opcodes.LOAD_CONST(jvmCode, n);
            Opcodes.INJECT(jvmCode, VMType.INT128, Templates.T_CBD_ROUND, new Magnitude(magnitude.isSigned(), magnitude.getDigits(), n));
        } else {
            int n2 = magnitude.getScale();
            int n3 = n - n2;
            if (n3 > 0) {
                Opcodes.LOAD_ROUNDER(jvmCode, n3, n2);
                Opcodes.ADD(jvmCode);
            }
        }
    }

    public static void CAST(JvmCode jvmCode, VMType vMType) {
        Opcodes.CAST(jvmCode, vMType, 1);
    }

    public static void CAST(JvmCode jvmCode, VMType vMType, int n) {
        if (n == 1) {
            jvmCode.push(Opcodes.cast((JvmCodeSnippet)jvmCode.pop(), vMType));
        } else if (n > 1) {
            JvmCodeSnippet[] jvmCodeSnippetArray = new JvmCodeSnippet[n];
            while (n-- > 0) {
                jvmCodeSnippetArray[n] = (JvmCodeSnippet)jvmCode.pop();
            }
            for (JvmCodeSnippet jvmCodeSnippet : jvmCodeSnippetArray) {
                jvmCode.push(Opcodes.cast(jvmCodeSnippet, vMType));
            }
        }
    }

    private static JvmCodeSnippet cast(JvmCodeSnippet jvmCodeSnippet, VMType vMType) {
        VMType vMType2 = (VMType)jvmCodeSnippet.getVmType();
        vMType2 = Functions.f_normalize_boxed_types(vMType2);
        if ((vMType = Functions.f_normalize_boxed_types(vMType)) == VMType.STRING) {
            if (vMType2 == VMType.ADDRESS) {
                return new JvmCodeSnippet((ISourceReference)jvmCodeSnippet, VMType.STRING, "new CobolString(" + jvmCodeSnippet + "," + "$CHARSET$" + ")", jvmCodeSnippet.getMagnitude());
            }
            if (vMType2 == VMTypeEx.BYTE_ARRAY) {
                return new JvmCodeSnippet((ISourceReference)jvmCodeSnippet, VMType.STRING, "new String(" + jvmCodeSnippet + "," + "$CHARSET$" + ")", jvmCodeSnippet.getMagnitude());
            }
            throw Errors.e_type_clash(jvmCodeSnippet, vMType);
        }
        if (vMType2.isArray() && vMType.isArray()) {
            if (vMType2 == vMType) {
                return jvmCodeSnippet;
            }
            throw Errors.e_type_clash(jvmCodeSnippet, vMType);
        }
        if (vMType2.isArray() || vMType.isArray()) {
            throw Errors.e_type_clash(jvmCodeSnippet, vMType);
        }
        if (vMType2 == vMType) {
            return jvmCodeSnippet;
        }
        if (vMType2 == VMType.VOID || vMType == VMType.VOID) {
            throw Errors.e_type_clash(jvmCodeSnippet, vMType);
        }
        if (vMType2.isPrimitive() && vMType.isPrimitive()) {
            Magnitude magnitude;
            if (vMType2 == VMType.BOOLEAN || vMType == VMType.BOOLEAN) {
                throw Errors.e_type_clash(jvmCodeSnippet, vMType);
            }
            if ((vMType == VMType.FLOAT32 || vMType == VMType.FLOAT64) && (magnitude = jvmCodeSnippet.getMagnitude()).isFixedPoint()) {
                return new JvmCodeSnippet(jvmCodeSnippet, vMType, Templates.T_SIMPLE_DIV.format(jvmCodeSnippet, ONEZEROS.substring(0, -magnitude.getScale() + 1) + (vMType == VMType.FLOAT64 ? D : F)));
            }
            return new JvmCodeSnippet((ISourceReference)jvmCodeSnippet, vMType, Templates.T_CAST.format(vMType.getClassName(), jvmCodeSnippet), jvmCodeSnippet.getMagnitude());
        }
        if (vMType == VMType.INT128) {
            if (vMType2.is(VMType.INT16, VMType.INT32, VMType.INT64)) {
                return new JvmCodeSnippet((ISourceReference)jvmCodeSnippet, VMType.INT128, Templates.T_CBD_FROM_BINARY.format(jvmCodeSnippet, jvmCodeSnippet.getMagnitude().getScale()), jvmCodeSnippet.getMagnitude());
            }
            if (vMType2 == VMType.ADDRESS) {
                return new JvmCodeSnippet((ISourceReference)jvmCodeSnippet, VMType.INT128, Templates.T_CBD_ARR.format(jvmCodeSnippet, 0), VMType.INT128.getDefaultMagnitude());
            }
        }
        if (vMType2 == VMType.INT128 && vMType.is(VMType.INT16, VMType.INT32, VMType.INT64)) {
            Magnitude magnitude = vMType.getDefaultMagnitude();
            return new JvmCodeSnippet((ISourceReference)jvmCodeSnippet, vMType, vMType == VMType.INT64 ? Templates.T_CBD_TO_LONG.format(jvmCodeSnippet, vMType.getName(), magnitude.getDigits(), magnitude.getScale()) : Templates.T_CBD_TO_INT.format(jvmCodeSnippet, vMType.getName(), magnitude.getDigits(), magnitude.getScale()), magnitude);
        }
        if (!vMType.isAssignableFrom(vMType2)) {
            throw Errors.e_type_clash(jvmCodeSnippet, vMType);
        }
        return new JvmCodeSnippet((ISourceReference)jvmCodeSnippet, vMType, Templates.T_CAST.format(vMType.getClassName(), jvmCodeSnippet), vMType.getDefaultMagnitude());
    }

    public static void IF(JvmCode jvmCode) {
        JvmCodeSnippet jvmCodeSnippet = (JvmCodeSnippet)jvmCode.pop();
        if (jvmCodeSnippet.getVmType() != VMType.BOOLEAN) {
            throw Errors.e_type_clash(jvmCodeSnippet, VMType.BOOLEAN);
        }
        Opcodes.INJECT(jvmCode, "if(" + jvmCodeSnippet + "){");
    }

    public static void ELSE(JvmCode jvmCode) {
        Opcodes.INJECT(jvmCode, "}else{");
    }

    public static void ELIF(JvmCode jvmCode) {
        JvmCodeSnippet jvmCodeSnippet = (JvmCodeSnippet)jvmCode.pop();
        if (jvmCodeSnippet.getVmType() != VMType.BOOLEAN) {
            throw Errors.e_type_clash(jvmCodeSnippet, VMType.BOOLEAN);
        }
        Opcodes.INJECT(jvmCode, "}else if(" + jvmCodeSnippet + "){");
    }

    public static void FI(JvmCode jvmCode) {
        Opcodes.INJECT(jvmCode, "}");
    }

    public static void IF_CASE(JvmCode jvmCode) {
        Opcodes.INJECT(jvmCode, "switch(" + jvmCode.pop() + "){");
    }

    public static void CASE(JvmCode jvmCode) {
        Opcodes.INJECT(jvmCode, "case " + jvmCode.pop() + ':');
    }

    public static void DEFAULT(JvmCode jvmCode) {
        Opcodes.INJECT(jvmCode, "default:");
    }

    public static void DO_WHILE(JvmCode jvmCode) {
        JvmCodeSnippet jvmCodeSnippet = (JvmCodeSnippet)jvmCode.pop();
        if (jvmCodeSnippet.getVmType() != VMType.BOOLEAN) {
            throw Errors.e_type_clash(jvmCodeSnippet, VMType.BOOLEAN);
        }
        Opcodes.INJECT(jvmCode, "while(" + jvmCodeSnippet + "){");
    }

    public static void DONE(JvmCode jvmCode) {
        Opcodes.INJECT(jvmCode, "}");
    }

    public static void DO(JvmCode jvmCode) {
        Opcodes.INJECT(jvmCode, "do {");
    }

    public static void DONE_WHILE(JvmCode jvmCode) {
        JvmCodeSnippet jvmCodeSnippet = (JvmCodeSnippet)jvmCode.pop();
        if (jvmCodeSnippet.getVmType() != VMType.BOOLEAN) {
            throw Errors.e_type_clash(jvmCodeSnippet, VMType.BOOLEAN);
        }
        Opcodes.INJECT(jvmCode, "} while(" + jvmCodeSnippet + ");");
    }

    public static Label DECLARE_LABEL(JvmCode jvmCode) {
        return Opcodes.DECLARE_LABEL(jvmCode, new Label(jvmCode.nextFreeIdentifier()));
    }

    public static Label DECLARE_LABEL(JvmCode jvmCode, Label label) {
        Opcodes.LABEL_LOOP(jvmCode, label);
        Opcodes.LOAD_CONST(jvmCode, true);
        Opcodes.DO_WHILE(jvmCode);
        return label;
    }

    public static void JUMP_TO_LABEL(JvmCode jvmCode, Label label) {
        Opcodes.INJECT(jvmCode, "break " + label + ";");
    }

    public static void PLACE_LABEL(JvmCode jvmCode, Label label) {
        Opcodes.JUMP_TO_LABEL(jvmCode, label);
        Opcodes.DONE(jvmCode);
    }

    public static void LABEL_LOOP(JvmCode jvmCode, Label label) {
        Opcodes.INJECT(jvmCode, VMType.VOID, label + ":");
    }

    public static void BREAK_LABEL(JvmCode jvmCode, Label label) {
        Opcodes.INJECT(jvmCode, "break " + label + ";");
    }

    public static void CONTINUE_LABEL(JvmCode jvmCode, Label label) {
        Opcodes.INJECT(jvmCode, "continue " + label + ";");
    }

    public static void BREAK(JvmCode jvmCode) {
        Opcodes.INJECT(jvmCode, "break;");
    }

    public static void RET_TFO(JvmCode jvmCode) {
        Opcodes.INJECT(jvmCode, "return -2;");
    }

    public static void RET_PROC(JvmCode jvmCode) {
        Opcodes.INJECT(jvmCode, "return -1;");
    }

    public static void JMP_RET_PROC(JvmCode jvmCode, int n, int n2) {
        Opcodes.JMP_RET_PROC(jvmCode, n, n2, false);
    }

    public static void JMP_RET_PROC(JvmCode jvmCode, int n, int n2, boolean bl) {
        boolean bl2;
        int n3 = jvmCode.getJmps()[n];
        boolean bl3 = bl2 = jvmCode.getRanges()[n3].getOutboundCount() > 0;
        if (!bl && jvmCode.isRetTfo()) {
            Opcodes.INJECT(jvmCode, "if(");
        }
        if (bl2) {
            Opcodes.INJECT(jvmCode, "$LJ$(");
        }
        Opcodes.INJECT(jvmCode, "$RANGE$" + n3 + '(' + n + ',' + n2 + ',' + "$CLD$" + ')');
        if (bl2) {
            Opcodes.INJECT(jvmCode, "," + n2 + "," + "$CLD$" + ')');
        }
        if (!bl && jvmCode.isRetTfo()) {
            Opcodes.INJECT(jvmCode, "==-2) return -2");
        }
        Opcodes.INJECT(jvmCode, ";");
    }

    public static void JUMP(JvmCode jvmCode, int n) {
        if (jvmCode.isInlineMode()) {
            Opcodes.INJECT(jvmCode, "$from$=" + n + ';');
            Opcodes.INJECT(jvmCode, "continue $RANGE$;");
        } else {
            Opcodes.INJECT(jvmCode, "return " + n + ";");
        }
    }

    public static void LONG_JUMP(JvmCode jvmCode, int n) {
        Opcodes.JUMP(jvmCode, jvmCode.getRanges()[jvmCode.getJmps()[n]].getLongJumpId() << 16 | n);
    }

    public static void THROW(JvmCode jvmCode, String string) {
        Opcodes.INJECT(jvmCode, Templates.T_RUNTIME_EXCEPTION.format(Utils.quoteString(string)));
    }

    public static void INJECT_CAVEMAN_DEBUG_CODE(JvmCode jvmCode, String string, Object ... objectArray) {
    }

    public static void INJECT_COMMENT(JvmCode jvmCode, String string) {
    }

    public static void INJECT_INLINE_COMMENT(JvmCode jvmCode, String string) {
    }
}

