/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.memory;

import com.veryant.cobol.compiler.memory.Chunk;
import com.veryant.cobol.exceptions.COBOLCompilerException;
import java.util.LinkedList;
import java.util.List;

public class DynamicChunk
extends Chunk {
    public static final int MAX_NATURAL_BOUNDARY = 16;
    private final int index;
    private List<DynamicChunk> cluster;
    private int multiplier;
    private boolean sized;
    private DynamicChunk union;

    private static int checkMemoryLimit(long l) {
        if (l < 0L || l > 0x7FFFFFFAL) {
            throw new COBOLCompilerException("Requested memory size exceeds Target limit");
        }
        return (int)l;
    }

    private void checkMemoryLimit() {
        if (this.multiplier > 0) {
            DynamicChunk.checkMemoryLimit((long)this.getOffset() + (long)DynamicChunk.checkMemoryLimit((long)this.getSize() * (long)this.multiplier));
        } else {
            DynamicChunk.checkMemoryLimit((long)this.getOffset() + (long)this.getSize());
        }
    }

    public boolean hasUnion() {
        return this.union != null;
    }

    public final int getPhysicalSize() {
        if (this.multiplier > 0) {
            return this.getSize() * this.multiplier;
        }
        return this.getSize();
    }

    public DynamicChunk(int n, int n2) {
        super(n2);
        this.index = n;
        this.sized = n2 > 0;
    }

    public DynamicChunk(int n, int n2, int n3) {
        this(n, n2);
        this.multiplier = n3;
        this.checkMemoryLimit();
    }

    protected void add(DynamicChunk dynamicChunk) {
        if (this.cluster == null) {
            this.cluster = new LinkedList<DynamicChunk>();
            this.sized = dynamicChunk.sized;
        }
        this.cluster.add(dynamicChunk);
        this.sized &= dynamicChunk.sized;
    }

    private boolean relocate(int n, boolean bl) {
        if (this.union != null) {
            n = this.union.getOffset();
        }
        if (this.cluster == null) {
            return this.relocateChunk(n, bl);
        }
        return this.relocateCluster(n, bl);
    }

    public boolean relocate(int n) {
        return this.relocate(n, false);
    }

    private boolean relocateCluster(int n, boolean bl) {
        for (DynamicChunk dynamicChunk : this.cluster) {
            if (!dynamicChunk.relocate(n, bl || this.isUsed())) continue;
            int n2 = this.getPhysicalSize();
            if (n2 == 0) {
                this.setOffset(dynamicChunk.getOffset());
            }
            int n3 = this.getOffset();
            int n4 = dynamicChunk.getOffset() + dynamicChunk.getPhysicalSize() - n3;
            if (n4 < n2) {
                n4 = n2;
            }
            n = n3 + n4;
            this.setSize(n4);
        }
        return this.getPhysicalSize() > 0;
    }

    private boolean relocateChunk(int n, boolean bl) {
        if (!bl && !this.isUsed()) {
            return false;
        }
        if (this.isAligned()) {
            int n2;
            int n3 = 16;
            while (n3 > 2) {
                int n4 = n3 / 2;
                if (this.getSize() > n4) break;
                n3 = n4;
            }
            if ((n2 = n % n3) > 0) {
                n += n3 - n2;
            }
        }
        this.setOffset(n);
        this.checkMemoryLimit();
        return true;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isSized() {
        return this.sized;
    }

    public void setUnion(DynamicChunk dynamicChunk) {
        this.union = dynamicChunk;
    }
}

