/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.filehandler;

import com.veryant.cobol.filehandler.ICobolBufferedFileWriterAppend;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class CobolBufferedFileWriter {
    private final ByteBuffer cachedByteBuffer;
    private final int cachedByteBufferLength;
    private final FileChannel fileChannel;
    private final boolean isFixedRecordLength;
    private final int maxRecordLength;
    private final int prefixLength;
    private final int maxRecordLengthWithPrefix;
    private final int maxLineLength;
    private final ByteBuffer recordTerminator;
    private final ICobolBufferedFileWriterAppend appendInterface;
    private static final int minBufferLength = 16384;
    private boolean eof = false;
    private long updateInterval = Long.MAX_VALUE;
    private long lastFlush;
    private boolean flushAgain = false;

    public CobolBufferedFileWriter(FileChannel fileChannel, int n, ByteBuffer byteBuffer) {
        this(fileChannel, n, false, byteBuffer);
    }

    public CobolBufferedFileWriter(FileChannel fileChannel, int n, boolean bl) {
        this(fileChannel, n, bl, null);
    }

    private CobolBufferedFileWriter(FileChannel fileChannel, int n, boolean bl, ByteBuffer byteBuffer) {
        int n2;
        this.fileChannel = fileChannel;
        this.isFixedRecordLength = bl;
        this.maxRecordLength = n;
        this.maxLineLength = n + 2;
        this.recordTerminator = byteBuffer;
        if (this.recordTerminator == null) {
            if (bl) {
                this.prefixLength = 0;
                this.maxRecordLengthWithPrefix = this.maxRecordLength;
                this.appendInterface = this::appendFixedLengthRecord;
            } else {
                this.prefixLength = n <= 65535 ? 2 : 4;
                this.maxRecordLengthWithPrefix = this.prefixLength + this.maxRecordLength;
                this.appendInterface = this.prefixLength == 2 ? this::appendShortRecord : this::appendIntRecord;
            }
            n2 = this.maxRecordLengthWithPrefix * 2;
        } else {
            this.prefixLength = 0;
            this.maxRecordLengthWithPrefix = this.maxRecordLength;
            n2 = this.maxLineLength * 2;
            this.appendInterface = this::appendLine;
        }
        n2 += 8191;
        n2 >>= 13;
        if ((n2 <<= 13) < 16384) {
            n2 = 16384;
        }
        this.cachedByteBufferLength = n2;
        this.cachedByteBuffer = ByteBuffer.allocate(this.cachedByteBufferLength);
        this.lastFlush = System.currentTimeMillis();
    }

    public void close() throws IOException {
        this.fileChannel.close();
    }

    public void append(ByteBuffer byteBuffer) throws IOException {
        this.appendInterface.call(byteBuffer);
    }

    public void appendLine(ByteBuffer byteBuffer) throws IOException {
        int n = byteBuffer.position();
        for (int i = byteBuffer.limit() - 1; i >= n; --i) {
            if (byteBuffer.get(i) == 32) continue;
            byteBuffer.limit(i + 1);
            break;
        }
        this.updateFlushTime();
        if (this.cachedByteBuffer.position() + byteBuffer.limit() + this.recordTerminator.limit() > this.cachedByteBufferLength) {
            this.flush();
        }
        this.cachedByteBuffer.put(byteBuffer);
        this.cachedByteBuffer.put(this.recordTerminator);
        this.recordTerminator.flip();
        this.doFlushAgain();
    }

    private void appendFixedLengthRecord(ByteBuffer byteBuffer) throws IOException {
        this.updateFlushTime();
        if (this.cachedByteBuffer.position() + byteBuffer.limit() > this.cachedByteBufferLength) {
            this.flush();
        }
        this.cachedByteBuffer.put(byteBuffer);
        this.doFlushAgain();
    }

    private void appendShortRecord(ByteBuffer byteBuffer) throws IOException {
        this.updateFlushTime();
        if (this.cachedByteBuffer.position() + 2 + byteBuffer.limit() > this.cachedByteBufferLength) {
            this.flush();
        }
        this.cachedByteBuffer.putShort((short)byteBuffer.limit());
        this.cachedByteBuffer.put(byteBuffer);
        this.doFlushAgain();
    }

    private void appendIntRecord(ByteBuffer byteBuffer) throws IOException {
        this.updateFlushTime();
        if (this.cachedByteBuffer.position() + 4 + byteBuffer.limit() > this.cachedByteBufferLength) {
            this.flush();
        }
        this.cachedByteBuffer.putInt((short)byteBuffer.limit());
        this.cachedByteBuffer.put(byteBuffer);
        this.doFlushAgain();
    }

    public void flush() throws IOException {
        if (this.cachedByteBuffer == null) {
            return;
        }
        this.cachedByteBuffer.flip();
        try {
            if (this.cachedByteBuffer.limit() > 0) {
                this.fileChannel.write(this.cachedByteBuffer);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw iOException;
        }
        finally {
            this.cachedByteBuffer.position(0);
            this.cachedByteBuffer.limit(this.cachedByteBufferLength);
        }
        this.lastFlush = System.currentTimeMillis();
    }

    private void updateFlushTime() {
        long l = System.currentTimeMillis();
        if (l - this.updateInterval >= this.lastFlush) {
            this.flushAgain = true;
        }
    }

    public void doFlushAgain() throws IOException {
        if (!this.flushAgain) {
            return;
        }
        this.flush();
        this.flushAgain = false;
    }

    public void setUpdateInterval(long l) {
        this.updateInterval = l;
    }
}

