/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.vision4j.file;

import com.veryant.vision4j.file.File;
import java.io.IOException;
import java.nio.file.Files;

public class FileTable {
    private final File[] openedFiles;
    private final int[] freeId;
    private int next;

    private boolean locked(File newOpen) {
        if (this.next > 0) {
            try {
                int counter = 0;
                for (File alreadyOpen : this.openedFiles) {
                    if (alreadyOpen == null) continue;
                    if (Files.isSameFile(alreadyOpen.getSegment(0).getPath(), newOpen.getSegment(0).getPath())) {
                        int alreadyOpenMode = alreadyOpen.getOpenMode();
                        int newOpenMode = newOpen.getOpenMode();
                        if ((newOpenMode & 0x200) != 0 || (alreadyOpenMode & 0x200) != 0) {
                            return true;
                        }
                        if ((newOpenMode & 0x100) != 0 && (alreadyOpenMode & 3) != 0) {
                            return true;
                        }
                        if ((alreadyOpenMode & 0x100) != 0 && (newOpenMode & 3) != 0) {
                            return true;
                        }
                    }
                    if (++counter < this.next) {
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public FileTable(int capacity) {
        this.openedFiles = new File[capacity];
        this.freeId = new int[capacity];
        this.next = 0;
    }

    private int nextId() {
        if (this.next < this.freeId.length) {
            int id;
            return (id = this.freeId[this.next++]) == 0 ? this.next : id;
        }
        return 0;
    }

    private void freeId(int id) {
        this.freeId[--this.next] = id;
    }

    public synchronized boolean isFull() {
        return this.next >= this.freeId.length;
    }

    public synchronized File get(int fileId) {
        return this.openedFiles[fileId - 1];
    }

    public synchronized int add(File file, boolean checkLock) {
        if (checkLock && this.locked(file)) {
            return -1;
        }
        int id = this.nextId();
        file.setId(id);
        if (id > 0) {
            this.openedFiles[id - 1] = file;
            return id;
        }
        return 0;
    }

    public synchronized void remove(File file) {
        int id = file.getId();
        this.openedFiles[id - 1] = null;
        this.freeId(id);
        file.setId(0);
    }
}

