/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.vision4j.file.internals;

import com.veryant.vision4j.file.internals.FileAddress;

public class KeyInfo {
    private final FileAddress keyRoot = new FileAddress();
    private short height;
    private final int segments;
    private final boolean duplicate;
    private final int[] offsets;
    private final int[] sizes;
    private int totalSize;

    public int getOffset(int segment) {
        return this.offsets[segment];
    }

    public int getSize(int segment) {
        return this.sizes[segment];
    }

    public short incHeight() {
        this.height = (short)(this.height + 1);
        return this.height;
    }

    public short decHeight() {
        this.height = (short)(this.height - 1);
        return this.height;
    }

    public KeyInfo(boolean duplicate, int[] offsets, int[] sizes) {
        this.duplicate = duplicate;
        this.offsets = offsets;
        this.sizes = sizes;
        this.segments = offsets.length;
        this.totalSize = 0;
        for (int s : sizes) {
            this.totalSize += s;
        }
    }

    public KeyInfo(boolean duplicate, int offset, int size) {
        this(duplicate, new int[]{offset}, new int[]{size});
    }

    public String toString() {
        return "duplicate: " + this.duplicate + ", segments: " + this.segments + ", total size: " + this.totalSize;
    }

    public FileAddress getKeyRoot() {
        return this.keyRoot;
    }

    public short getHeight() {
        return this.height;
    }

    public void setHeight(short height) {
        this.height = height;
    }

    public int getSegments() {
        return this.segments;
    }

    public boolean isDuplicate() {
        return this.duplicate;
    }

    public int getTotalSize() {
        return this.totalSize;
    }
}

