      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.
       PROGRAM-ID.                   MYHOOK.

      *>   This program shows the HOOK feature.
      *>   This program must be found in the CLASSPATH used by the ApplicationServer (even if code_prefix is set)
      *>   The property iscobol.as.hook must be set to this program name.
      *>   The hook class will be executed every time a user opens or closes a client connection.
      *>   The purpose of this sample is to write an access log and shutdown the ApplicationServer
      *>   process every 3 hours if no clients are connected. The entire code is synchronized and 
      *>   a java thread is used to check time and connections.
      *>   The startup of the Application server needs to be set in a loop shell command.
      
       CONFIGURATION SECTION.
       REPOSITORY.  
           class MYHOOKTIMER.
      
       INPUT-OUTPUT SECTION.
       FILE-CONTROL.   
           select logger assign to "access.log"
                  organization line sequential.
      
       FILE SECTION.
       FD logger.
       01 logger-rec                 pic x(146).
      
       WORKING-STORAGE SECTION.
       78 RUNNINGHOURS               value 3.
       77 HOOKTIMER                  object reference MYHOOKTIMER.
       77 as-entering                pic 9.
       77 as-userid                  pic 9(5).
       77 as-username                pic x(16).
       77 as-program                 pic x(32).
       77 as-arguments               pic x(32).
       77 as-host                    pic x(15).
       77 as-time                    pic 9(8).
       77 flag                       pic 9.
       77 usercounter                pic 9(5).
       77 threadid                   pic 9(3).
       77 as-date                    pic 9(8).
       01 timelimit.
          03 hhlimit                 pic 99.
          03 mmlimit                 pic 99.
      
       PROCEDURE DIVISION.
       main.
           synchronized
              perform THE-HOOK
           end-synchronized.
           goback.
      
       THE-HOOK.
      *> These environment variables can be accessed also from outside the HOOK
           accept as-entering  from environment "as.info.entering"
           accept as-userid    from environment "as.info.userid"
           accept as-username  from environment "as.info.username"
           accept as-program   from environment "as.info.program"
           accept as-arguments from environment "as.info.arguments"
           accept as-host      from environment "as.info.host"
           accept as-time      from time
           accept as-date      from century-date
      
           call "A$GETTHREAD" giving threadid
      
           if flag not = 1
              move as-time(1:4) to timelimit
              add RUNNINGHOURS to hhlimit
              if hhlimit > 23
                 subtract 24 from hhlimit
              end-if
              set HOOKTIMER to MYHOOKTIMER:>new(timelimit)
              HOOKTIMER:>start
              move 0 to usercounter
              move 1 to flag
              open output logger
              close logger
           end-if
      
           initialize logger-rec
      
           if as-entering = 1
              string "[" threadid " ENTER -" into logger-rec
              add 1 to usercounter
           else
              string "[" threadid " EXIT  -" into logger-rec
              subtract 1 from usercounter
           end-if
      
           string logger-rec            delimited by trailing spaces
                  " "   as-date(7:2)    delimited by size
                  "/"   as-date(5:2)    delimited by size
                  "/"   as-date(1:4)    delimited by size
                  " "   as-time(1:2)    delimited by size
                  ":"   as-time(3:2)    delimited by size
                  ":"   as-time(5:2)    delimited by size
                  "] "  as-userid       delimited by size
                  " - " as-username     delimited by size
                  " - " as-program      delimited by size
                  " - " as-arguments    delimited by size
                  " - " as-host         delimited by size
             into logger-rec
           end-string
      
           open extend logger
           write logger-rec
           close logger
      
           set HOOKTIMER:>USERCOUNTER to usercounter
           .