var response={
		currentSong:null,
		status: null
}


 /********** Button handlers ****************/
 
function first() {
	callServer('F');
}

function next() {
	callServer('N');
}

function previous() {
	callServer('P');
}

function last() {
	callServer('L');
}	

function deleteSong(){
	callServer('D');
	first();
}

function search() {
	// if we don't have a currentSong yet, create one
	if (response.currentSong==null)
		response.currentSong = new Object();
	// set the id of the song we're looking for
	response.currentSong.id=$('#searchField').val();
	callServer('R');
	$('#searchField').val('');
}	


function updateSong() {
	var song=retrieveSongData();
	var data = new Object();
	data.Operation = "U";
	data.SongData=song;
	callServerWithData('U', data);
}

function insertSong(){
	var song=retrieveSongData();
	var data = new Object();
	data.Operation = "I";
	data.SongData=song;
	callServerWithData('I', data);
}

function clearData() {
	response={
			currentSong:null,
			status: null
	};
	$('#id').val('');
	$('#title').val('');
	$('#album').val('');
	$('#artist').val('');
	$('#length').val('');
	$('#year').val('');
	$('#genre').val('');
	$('#label').val('');
	$('#author1').val('');
	$('#author2').val('');
	$('#author3').val('');
	$('#author4').val('');
	$('#author5').val('');
}

function pdfReport() {
	window.open("servlet/PRINTSONGS?nocache="+Math.random());
}

function retrieveSongData() {
	var song= {
		Id:$('#id').val(),
		Title:$('#title').val(),
		Album:$('#album').val(),
		Artist:$('#artist').val(),
		Length:$('#length').val(),
		Year:$('#year').val(),
		Genre:$('#genre').val(),
		Label:$('#label').val()
	}
	
	var res = JSON.stringify(song);
	song.Authors = new Array();
	song.Authors.push({Author:$('#author1').val()});
	song.Authors.push({Author:$('#author2').val()});
	song.Authors.push({Author:$('#author3').val()});
	song.Authors.push({Author:$('#author4').val()});
	song.Authors.push({Author:$('#author5').val()});
	
	return song;
}

/************* Web service calls and response handlers *******/

function callServer(operation) {
	var url = 'servlet/SONGS'; //?Operation=' + operation;
	// if operation requires the current song id, provide it
	// operations that require an Id are: N, P, I, U, R, D
//	if ('NPIURD'.indexOf(operation)>=0 && response.currentSong!=null)
//		url = url + '&id=' + response.currentSong.Id;
	
	var json = {Request: {Operation: operation, SongData: null}}
	if (response.currentSong!=null)
		json.Request.SongData = response.currentSong;
		
	
    $.ajax(url,
    	{
    		type: 'POST',
    		contentType: "application/json",
    		dataType: 'json',
    		data: JSON.stringify(json),
    		success: handleSuccess,
    		error: handleError
        }
    );
    
}

function callServerWithData(operation, dataToSend) {
	var SongData=JSON.stringify(dataToSend);
    $.ajax('servlet/SONGS?Operation=' + operation,
    	{
    		type: 'POST',
            contentType: "application/json",
    		success: handleSuccess,
    		error: handleError,
    		dataType: 'json',
    		data: SongData
        }
    );
}

function handleError (jqXHR, textStatus, errorThrown) {
    $("#rsperror").html(textStatus +" "+ jqXHR.status + " "+jqXHR.statusText +
                 "\n" + jqXHR.responseText);
 }

 function handleSuccess (data, textStatus, jqXHR) {
	 response.currentSong= data["Response"].SongData;
	 response.status= data["Response"].Status;
	 //debugger;
	
	 if (response.status.ReturnStatus == "OK") {
		 $('#id').val(response.currentSong.Id);
		 $('#title').val(response.currentSong.Title);
		 $('#album').val(response.currentSong.Album);
		 $('#artist').val(response.currentSong.Artist);
		 $('#length').val(response.currentSong.Length);
		 $('#year').val(response.currentSong.Year);
		 $('#genre').val(response.currentSong.Genre);
		 $('#label').val(response.currentSong.Label);
		 for (var i=0;i<5;i++)		
			 	if (i<response.currentSong.Authors.length)
					 document.getElementById('author'+(i+1)).value = response.currentSong.Authors[i].Author;
				else
					document.getElementById('author'+(i+1)).value = '';
	 }
     
	 $("#rsperror").html(response.status.ReturnStatus + " " +response.status.ReturnMessage);
	 return response.status.ReturnStatus == "OK";
 }
 