import com.iscobol.java.IsCobol;
import com.iscobol.java.CobolVarHelper;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.INumericVar;
import com.iscobol.java.StopRunAsException;

/**
 * A simple example showing how to call isCOBOL programs from Java programs.
 */
public class JavaCallIsCOBOL {

   static int rc;

//When the cobol program is compiled with the -cp option,
//use static int opt = CobolVarHelper._CP;
//otherwise use static int opt = 0;
   static int opt = 0;
//   static int opt = CobolVarHelper._CP;

   public static void main(String args[]) {

      /* Pass a configuration to the cobol program */
      System.setProperty("iscobol.conf", "myconfig.properties");

      /* test CALL + CANCEL */
      CallCancel();
      /* end of test */

      /* test CALL with 3 parameters */
      CallWith3Parameter();
      /* end of test */

      /* test CALL + group item + Environment */
      CallGroupItemPlusEnvironment();
      /* end of test */

      /* test to manage a cobol error */
      ManageCobolError();
      /* end of test */

      /* test CALLNOSTOP */
      CallNoStop();
      /* end of test */

      /* Cancels all the COBOL programs previously called. */
      IsCobol.cancelAll();

      /* Shutdown the isCOBOL environment */
      IsCobol.tidy();

   }

   private static void CallCancel() {

      System.out.println("test CALL + CANCEL ");

      CobolVarHelper myNum = new CobolVarHelper(null, opt).pic9("ADDEND", 2, 0);
      ICobolVar Num = myNum.get("ADDEND");
      Num.set(1);
      System.out.println("1st call");
      rc = IsCobol.call("COBPROG1", new Object[] { myNum.get() });
      System.out.println("2nd call");
      rc = IsCobol.call("COBPROG1", new Object[] { myNum.get() });
      System.out.println("3rd call");
      rc = IsCobol.call("COBPROG1", new Object[] { myNum.get() });
      IsCobol.cancel("COBPROG1");
      System.out.println("call after the cancel");
      rc = IsCobol.call("COBPROG1", new Object[] { myNum.get() });

      System.out.println();
      System.out.println("end test CALL + CANCEL ");
   }

   private static void CallWith3Parameter() {
      System.out.println();
      System.out.println("test CALL with 3 parameters ");

      /* First parameter definition */
      CobolVarHelper par1 = new CobolVarHelper(null, opt).picX("wl-par-01", 20);
      ICobolVar Jpar1 = par1.get("wl-par-01");
      Jpar1.set("Param1");

      /* Second parameter definition */
      CobolVarHelper par2 = new CobolVarHelper(null, opt).picX("wl-par-02", 20);
      ICobolVar Jpar2 = par2.get("wl-par-02");
      Jpar2.set("Param2");

      /* Third parameter definition */
      CobolVarHelper par3 = new CobolVarHelper(null, opt).pic9("wl-par-03", 4,0);
      ICobolVar Jpar3 = par3.get("wl-par-03");
      Jpar3.set(1234);

      rc = IsCobol.call("COBPROG2", new Object[] { par1.get(), par2.get(), par3.get() });

      /* end of test */
      System.out.println();
      System.out.println("end test CALL with 3 parameters ");
   }

   private static void CallGroupItemPlusEnvironment() {
      System.out.println();
      System.out.println("test CALL + group item + Environment ");

      /* Gruop item parameter definition */
      CobolVarHelper myVar = new CobolVarHelper(null, opt).picX("VAR-1", 20)
            .picX("VAR-2", 30).justRight(true).group(null)
            .picS9("VAR-4", 5, 2).signSeparate(true).signLeading(true)
            .picS9Comp3("VAR-5", 5, 2)
            .endGroup().pic9("VAR-6", 5, 0).picN("VAR-7", 5)
            .pic9Comp1("VAR-8").picS9Comp2("VAR-9", 5, 2)
            .picS9Comp4("VAR-10", 5, 2).picS9Comp5("VAR-11", 5, 2)
            .pic9Comp6("VAR-12", 5, 2).picS9Comp9("VAR-13", 5, 2)
            .pic9CompN("VAR-14", 3).pic9CompX("VAR-15", 3)
            .picFloat("VAR-16").picDouble("VAR-17").picXAnyLength("VAR-18")
            .picNAnyLength("VAR-19").group("VAR-20").occurs(3)
            .picS9("VAR-21", 2, 0).picS9("VAR-22", 3, 0).occurs(5)
            .group("VAR-23").occurs(7).picS9("VAR-24", 3, 0)
            .picS9("VAR-25", 2, 0).endGroup().endGroup().picX("VAR-99", 1);

      ICobolVar var1 = myVar.get("VAR-1");
      ICobolVar var2 = myVar.get("VAR-2");
      INumericVar var4 = myVar.getNum("VAR-4");
      INumericVar var5 = myVar.getNum("VAR-5");
      INumericVar var6 = myVar.getNum("VAR-6");
      ICobolVar var7 = myVar.get("VAR-7");
      ICobolVar var8 = myVar.get("VAR-8");
      ICobolVar var9 = myVar.get("VAR-9");
      ICobolVar var10 = myVar.get("VAR-10");
      ICobolVar var11 = myVar.get("VAR-11");
      ICobolVar var12 = myVar.get("VAR-12");
      ICobolVar var13 = myVar.get("VAR-13");
      ICobolVar var14 = myVar.get("VAR-14");
      ICobolVar var15 = myVar.get("VAR-15");
      ICobolVar var16 = myVar.get("VAR-16");
      ICobolVar var17 = myVar.get("VAR-17");
      ICobolVar var18 = myVar.get("VAR-18");
      ICobolVar var19 = myVar.get("VAR-19");
      ICobolVar var21 = myVar.get("VAR-21");
      ICobolVar var22 = myVar.get("VAR-22");
      ICobolVar var24 = myVar.get("VAR-24");
      ICobolVar var25 = myVar.get("VAR-25");
      ICobolVar var99 = myVar.get("VAR-99");

      var1.set("SET IN JAVA");
      var2.set("set in java");
      var4.set(12345.67);
      var5.set(23456.78);
      var6.set(34567.89);
      var7.set("123AB");
      var8.set(-12.34);
      var9.set(-12345.67);
      var10.set(-23456.78);
      var11.set(-34567.89);
      var12.set(13579.97);
      var13.set(24680.02);
      var14.set(123456);
      var15.set(234567);
      var16.set(0.1234E13);
      var17.set(5.6789E13);
      var18.set("sEt In JaVa");
      var19.set("AbCdEF123457890");

      for (int i = 1; i <= 3; i++) {
         var21.intIAt(i).set(i);
         for (int j = 1; j <= 5; j++)
            var22.intIAt(new int[] { i, j }).set(i + j);
         for (int j = 1; j <= 7; j++) {
            var24.intIAt(new int[] { i, j }).set(i + j);
            var25.intIAt(new int[] { i, j }).set(0 - i - j);
        }
      }

      var99.set("#");

      /* Set an environment property */
      IsCobol.setEnvironment("myEnv", "environment value from Java");

      rc = IsCobol.call("COBPROG3", new Object[] { myVar.get() });

      System.out.println();
      System.out.println("Inside JAVA program");
      System.out.println("rc=" + rc);
      System.out.println();
      System.out.println(var1);
      System.out.println(var2);
      System.out.println(var4);
      System.out.println(var5);
      System.out.println(var6);
      System.out.println(var7);
      System.out.println(var8);
      System.out.println(var9);
      System.out.println(var10);
      System.out.println(var11);
      System.out.println(var12);
      System.out.println(var13);
      System.out.println(var14);
      System.out.println(var15);
      System.out.println(var16);
      System.out.println(var17);
      System.out.println("[" + var18 + "]");
      System.out.println("[" + var19 + "]");
      System.out.println(var99);

      System.out.println(IsCobol.getEnvironment("myEnv"));

      System.out.println();
      System.out.println("end test CALL + group item + Environment ");

   }

   private static void ManageCobolError() {

       System.out.println();
       System.out.println("test CALL with error ");

          try {
               rc = IsCobol.call("COBPROG4", null, false);
              } catch(Exception ex) {
               System.out.println("error on COBOL program: " + ex.getMessage());
          }

       System.out.println();
       System.out.println("end test CALL with error ");

    }

   private static void CallNoStop() {

      System.out.println();
      System.out.println("test CALLNOSTOP ");
      System.out.println("This should be used for testing purposes only");
      
      try {
          rc = IsCobol.callNoStop("COBPROG5", null);
      } catch (StopRunAsException ex2) {
          rc = ex2.getExitCode();
          System.out.println("executed STOP RUN from cobol, rc=" + rc);
      }

      System.out.println();
      System.out.println("end test CALLNOSTOP");
   }


}
