import com.iscobol.java.IsCobol;

public class MainEnvShared {
    public static void main (String[] args) {
        IsCobol.setEnvironment("file.prefix", "shared-data");
        IsCobol.setEnvironment("myenv", "environment value from Java");
        final Thread iscobolThread = Thread.currentThread();

        Runnable javaThread1 = new Runnable(){
            public void run(){
                System.out.println();
                System.out.println("Java Thread 1");
                IsCobol.duplicateIscobolEnv(iscobolThread, Thread.currentThread());
                IsCobol.call("COBPROG1", new Object[]{});
                IsCobol.destroyIscobolEnv(Thread.currentThread());
            }
        };

        Runnable javaThread2 = new Runnable(){
            public void run(){
                System.out.println();
                System.out.println("Java Thread 2");
                IsCobol.duplicateIscobolEnv(iscobolThread, Thread.currentThread());
                IsCobol.call("COBPROG2", new Object[]{});
                IsCobol.destroyIscobolEnv(Thread.currentThread());
            }
        };
        Thread t1 = new Thread(javaThread1);
        Thread t2 = new Thread(javaThread2);

        t1.start();
        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            System.err.println(e);
        }   
        t2.start();

        try {
            t1.join();
            t2.join();
        } catch (InterruptedException e) {
            System.err.println(e);
        }
        System.exit(0);
    }
}