      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.
      
       PROGRAM-ID. ISUSER.
       configuration section.
       special-names.   
      
       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
           copy "users.sl".
           copy "favrec.sl".
       DATA DIVISION.
       FILE SECTION.
           COPY "users.fd".
           COPY "favrec.fd".
      
       WORKING-STORAGE SECTION.

           copy "common.wrk".
           copy "color.wrk".

       77  STATUS-users                PIC XX.
       77  STATUS-favrec               PIC XX.

       01  screen-value.
           05 scr-id-user              pic x(20).
           05 scr-name-user            pic x(50).
           05 scr-type-user            pic 9.

       01  screen-change-pwd-value.
           05 scr-password             pic x(20).
           05 scr-confirm-password     pic x(20).

       78  id-ef-id-user               value 100.
       78  id-ef-name-user             value 101.
       78  id-cb-type                  value 102.
       78  id-ef-password              value 103.
       78  id-ef-confirm-password      value 104.

       01                              pic 9.
           88 all-ok                   value 1 false zero.

       77  choice                      pic x.
       77  wrk-user                    pic x(20).
       77  e-change-pwd                pic 9.

       77  h-change-pwd                handle of window.

       screen section.
       01  mask-main.
           05 label
              foreground-color RGB 78-lbl-menu-foreground-color
              background-color RGB 78-lbl-menu-background-color
              right
              col 31
              line 1
              lines 2 
              size 76
              height-in-cells
              width-in-cells
              . 
           05 frame 
              raised
              line                 3 
              col                  31
              lines                13 cells
              size                 76 cells
              .
           05 Label, 
              col 32
              line 5
              title r"User_id"
              transparent
              .
           05 Label
              col 32
              line 7
              title r"Name"
              transparent
              .
           05 Label
              col 32
              line 9
              title r"Super_User"
              transparent
              .
           05 ef-id-user Entry-Field
              col 50 
              line 5
              size 20
              id id-ef-id-user
              value scr-id-user
              border-width (0, 0, 2, 0)
              border-color rgb 78-ef-border-color
              after AFT-EF-ID-USER
              .
           05 ef-name-user Entry-Field, 
              col 50
              line 7
              size 50
              value scr-name-user
              id id-ef-name-user
              border-width (0, 0, 2, 0)
              border-color rgb 78-ef-border-color
              .
           05 cb-type-user Check-box, 
              hint R"Super_User"
              col 50
              line 9
              size 5
              value scr-type-user
              id id-cb-type
              transparent
              .
           
           05 pb-change-pwd Push-Button
              col 50 
              line 11
              lines 2.2 cells
              size 16 cells
              exception-value 2003
              title R"&Change_Password"
              self-act
              enabled e-change-pwd
              flat
              background-color     78-pb-background-color
              foreground-color     78-pb-foreground-color
              disabled-background-color 
                                   rgb 78-pb-disabled-background-color
              disabled-foreground-color 
                                   rgb 78-pb-disabled-foreground-color

              rollover-foreground-color 
                                   rgb 78-pb-rollover-foreground-color
               .

       01  mask-change-pwd.
           05 Label
              col 2
              line 2
              title r"Password"
              transparent
              .
           05 Label
              col 2
              line 4
              title r"Confirm_Password"
              transparent
              .
           05 ef-password Entry-Field, 
              COL 20
              LINE 2
              SIZE 20
              VALUE scr-password
              max-text 20
              id id-ef-password
              secure
              border-width (0, 0, 2, 0)
              border-color rgb 78-ef-border-color
              .
           05 ef-confirm-password Entry-Field
              COL 20
              LINE 4
              SIZE 20
              max-text 20
              VALUE scr-confirm-password
              id id-ef-confirm-password
              secure
              border-width (0, 0, 2, 0)
              border-color rgb 78-ef-border-color
              .
           05 Push-Button
              col 10 
              line 7
              lines 2.2 
              cells
              size 20 cells
              bitmap-handle h-tools
              bitmap-width 16
              bitmap-number 78-n-pb-save
              bitmap-rollover 78-n-pb-save-rollover
              exception-value 2001
              title R"Change_Password"
              title-position 2
              self-act
              flat
              background-color     78-pb-background-color
              foreground-color     78-pb-foreground-color
              disabled-background-color 
                                   rgb 78-pb-disabled-background-color
              disabled-foreground-color 
                                   rgb 78-pb-disabled-foreground-color

              rollover-foreground-color 
                                   rgb 78-pb-rollover-foreground-color
              .

           05 Push-Button
              col + 1.2
              line 7
              lines 2.2 cells
              size 14 cells
              bitmap-width 16
              bitmap-handle h-tools
              bitmap-number 78-n-pb-delete
              bitmap-rollover 78-n-pb-delete-rollover
              exception-value 27
              title-position 2
              title R"Cancel"
              self-act
              flat
              background-color     78-pb-background-color
              foreground-color     rgb 78-pb-foreground-color
              disabled-background-color 
                                   rgb 78-pb-disabled-background-color
              disabled-foreground-color 
                                   rgb 78-pb-disabled-foreground-color

              rollover-foreground-color 
                                   rgb 78-pb-rollover-foreground-color
              .

           copy "standard-mask-tool.scr".

       PROCEDURE DIVISION.
       DECLARATIVES.
       USERS-ERR section.
           use after standard error procedure on users.
           perform ERROR-FILE
           .
       FAVREC-ERR section.
           use after standard error procedure on favrec.
           perform ERROR-FILE
           .
       END DECLARATIVES.
       
       MAIN.

           if not user-super
              display message box R"For_Super_user_only!"
              goback
           end-if.
           
           perform OPEN-FILES.
           
           initialize screen-value.
           
           display independent graphical window
                   title R"isCOBOL_Application_Users"
                   lines 15
                   size 107
                   control font h-font
                   background-low
                   handle h-sta
                   visible 0
                   system menu
                   link to thread
                   gradient-color-1 78-pb-foreground-color
                   gradient-color-2 rgb x#F2F6F9 
                   .
           
           call "ISTOOLTIP"
           cancel "ISTOOLTIP".
             
           display tool-bar 
                   lines 2.5 
                   control font h-font 
                   handle h-tool 
                   upon h-sta
           
           display mask-main upon h-sta
           display mask-tool upon h-tool
           
           modify h-sta visible 1
           
           perform until key-status = 27
              accept mask-main
                 on exception 
                    continue
              end-accept
              perform AFTER-ACCEPT
              move 4 to accept-control
           end-perform       
           
           perform EXIT-PRG.
           
           goback.

       AFTER-ACCEPT.
           evaluate key-status
           when 78-exe-new
                initialize users-r
                perform DISPLAY-SCREEN
           when 78-exe-save
                perform SAVE-RECORD
           when 78-exe-delete
                perform DELETE-RECORD
                initialize users-r
                perform DISPLAY-SCREEN
           when 78-exe-first
                perform READ-FIRST
                perform DISPLAY-SCREEN
           when 78-exe-prev
                perform READ-PREV
                perform DISPLAY-SCREEN
           when 78-exe-next
                perform READ-NEXT
                perform DISPLAY-SCREEN
           when 78-exe-last
                perform READ-LAST
                perform DISPLAY-SCREEN
           when 78-exe-zoom
                PERFORM ZOOM-PARAGRAPH
           when w-event
                evaluate event-type
                when cmd-close
                     move 27 to key-status
                end-evaluate
           when 2003
                perform CHANGE-PASSWORD
           end-evaluate.

       DELETE-RECORD.
           display message box 
                          R"Are_you_sure_to_delete_the_selected_record?"
                   type mb-yes-no
                   default mb-no
                   giving choice
           if choice = mb-yes
              inquire ef-id-user  value scr-id-user
              move scr-id-user   to users-id
              delete users record
                 invalid
                    continue
              end-delete
              move scr-id-user   to favrec-user
              delete favrec record
                 invalid
                    continue
              end-delete
           end-if.

       SAVE-RECORD.
           set all-ok  to true
           perform CONTROL-ALL
           
           if all-ok
              move scr-id-user    to users-id   
              move scr-name-user  to users-name 
              move scr-type-user  to users-type 
           
              rewrite users-r
                 invalid
                    write users-r
                       invalid
                          continue
                       not invalid
                          perform CHANGE-PASSWORD
                          move 1 to e-change-pwd
                          modify pb-change-pwd enabled e-change-pwd
                    end-write
              end-rewrite
           end-if.
 
       CONTROL-ALL.
           set all-ok          to true
           inquire ef-id-user  value scr-id-user
           inquire ef-name-user value scr-name-user.
           inquire cb-type-user value scr-type-user.
           
           if scr-id-user = space
              display message box R"User_id_is_mandatory!"
              move id-ef-id-user  to control-id
              set all-ok          to false
           end-if.

       READ-FIRST.
           move low-value  to users-id
           start users key not < users-key
              invalid
                 perform RECORD-NOT-FOUND
                 initialize users-r
              not invalid
                read users next no lock
                   at end
                      perform RECORD-NOT-FOUND
                      initialize users-r
                end-read
           end-start.
 
       READ-LAST.
           move high-value  to users-id
           start users key not > users-key
              invalid
                 perform RECORD-NOT-FOUND
                 initialize users-r
              not invalid
                 read users previous no lock
                    at end
                       perform RECORD-NOT-FOUND
                       initialize users-r
                end-read
           end-start.

       READ-PREV.
           inquire ef-id-user VALUE scr-id-user.
           if scr-id-user = space
              perform READ-LAST
           else
              move scr-id-user  to users-id
              read users no lock
                invalid
                   start users key not < users-key
                      invalid
                         initialize users-r
                   end-start
              end-read
              read users previous no lock
                at end
                   perform RECORD-NOT-FOUND
              end-read
           end-if.

       READ-NEXT.
           inquire ef-id-user VALUE scr-id-user.
           if scr-id-user = space
              perform READ-FIRST
           else
              move scr-id-user  to users-id
              read users no lock
                invalid
                   start users key not > users-key
                      invalid
                         initialize users-r
                   end-start
              end-read
              read users next no lock
                at end
                   perform RECORD-NOT-FOUND
              end-read
           end-if.
 
       RECORD-NOT-FOUND.
           display message box R"Record_not_found".

       DISPLAY-SCREEN.
           move users-id     to scr-id-user
           move users-name   to scr-name-user
           move users-type   to scr-type-user
           
           if scr-id-user not = space
              move 1  to e-change-pwd
           else
              move 0  to e-change-pwd
           end-if
           
           display mask-main.
 
       OPEN-FILES.
           open I-O users.
           open I-O favrec.

       EXIT-PRG.
           perform DESTROY-RESOURCE
           perform CLOSE-FILE
           .

       CLOSE-FILE.
           close users.
           close favrec.

       DESTROY-RESOURCE.
           modify h-sta visible 0
           destroy mask-main mask-tool h-tool 
                   h-sta 
           .

       AFT-EF-ID-USER.
           if key-status = 13
              perform LOAD-RECORD
           end-if.

       LOAD-RECORD.
           move scr-id-user  to users-id
           read users no lock
              invalid
                 perform RECORD-NOT-FOUND
              not invalid
                 perform DISPLAY-SCREEN
           end-read.

       ZOOM-PARAGRAPH.
           evaluate control-id
           when id-ef-id-user
                call "ZUSER" using wrk-user
                cancel "ZUSER"
                if wrk-user not = space
                   move wrk-user   to scr-id-user
                   perform LOAD-RECORD
                end-if
           end-evaluate.

       CHANGE-PASSWORD.
           display floating graphical window
                   system menu 
                   title R"isCOBOL_Application_Change_Password"
                   lines 10 size 51
                   control font h-font
                   visible 1
                   handle h-change-pwd
                   gradient-color-1 rgb 78-gradient-color-1
                   gradient-color-2 rgb 78-gradient-color-2 
                   .
           
           initialize screen-change-pwd-value.
           
           display mask-change-pwd.
           
           perform until key-status = 27
              accept mask-change-pwd
                 on exception continue
              end-accept
              evaluate key-status 
              when 2001
                   perform SAVE-PASSWORD
              when w-event
                   evaluate event-type
                   when cmd-close
                        move 27 to key-status
                   end-evaluate
              end-evaluate
              move 4 to accept-control
           end-perform.
           
           destroy h-change-pwd
           move zero to key-status.
           
       SAVE-PASSWORD.
           set all-ok          to true
           inquire ef-password VALUE scr-password
           inquire ef-confirm-password VALUE scr-confirm-password
           
           if scr-password not = scr-confirm-password
              display message box R"Password_mismatch"
              move id-ef-password to control-id
              set all-ok          to false
           end-if.
           
           if all-ok
              move scr-id-user  to users-id
              read users no lock
                 invalid
                    continue
                 not invalid
                    move scr-password     to password
                    call "C$ENCRYPT" using function trimr(password), 
                                           "Veryant", 
                                           encrypted-data1
                    call "ASCII2HEX" using encrypted-data1, 
                                           encrypted-data2
                    move encrypted-data2   to users-pass
                    rewrite users-r
                       invalid
                          continue
                    end-rewrite  
              end-read
              move 27 to key-status
           end-if.

           copy "dec-file.prd".


