      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.
       IDENTIFICATION DIVISION.
       PROGRAM-ID. AUDITANALYSIS.

       ENVIRONMENT DIVISION.

       CONFIGURATION SECTION.

       SPECIAL-NAMES.

       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
           copy "auditlog.sl".
           copy "auditfilesettings.sl".

       DATA DIVISION.
       FILE SECTION.
           copy "auditlog.fd".
           copy "auditfilesettings.fd".

       working-storage section.
           copy "isgui.def".
           copy "iscobol.def".
           copy "iscrt.def".
           copy "isfonts.def".
           copy "color.wrk".

       77  key-status is special-names crt status pic 9(4) value 0.
       77  w-audit-handle             handle of window.
       77  tb-audit-handle            handle of window.

       77  control-font               handle of font.
       77  tools-png                  pic s9(9) comp-4.

       78  78-exe-delete              value 4.
       78  78-exe-exit                value 27.

       77  idx                        pic 9(3).

       77  status-auditlog            pic x(2).
       77  status-auditfilesettings   pic x(2).

       01  rec-grid-log.
           05 rgl-users-id            pic x(20).
           05 rgl-date                pic 9999/99/99.
           05 rgl-time                pic x(8).
           05 rgl-operation           pic x(50).
           05 rgl-program-name        pic x(20).
           05 rgl-file-name           pic x(20).
           05 rgl-file-key            pic x(256).

       01  rec-grid-segment.
           05 rgs-segment             pic z(2).
           05 rgs-offset              pic z(10).
           05 rgs-size                pic z(3).
           05 rgs-file-key            pic x(100).
           05 rgs-file-key-hex        pic x(512).

       01  ed-time.
           05 ed-hh pic 99.
           05 filler pic x value ":".
           05 ed-mm pic 99.
           05 filler pic x value ":".
           05 ed-ss pic 99.

       77  wrk-from-date              pic 9(8).
       77  wrk-to-date                pic 9(8).
       
       77  check-exception            pic 9(5).

       01  crerr-status.
           03 file-status             pic xx.
           03 ext-status              pic xxx.
       77  rerrname                   pic x(50).

       77  fullname                   pic x any length.
       77  file-handle                handle.

       77  w-segment-handle           handle of window. 
       77  tb-segment-handle          handle of window. 

       01                             pic 9 value 0.
           88 show-key-details        value 1 false 0.

       77  wrk-color                  pic s9(8).
       77  wrk-font-name              pic x any length.
       77  h-font-awsome              handle of font.
       77  toolbar-characters         pic n any length.

       SCREEN SECTION.
       01  screen-audit.
           03 label
              line                 2 
              col                  3 
              size                 20 cells
              title                "From date"
              transparent
              .
           03 de-from-date 
              date-entry
              Numeric
              line                 2 
              col                  14 
              size                 20 cells
              value-format         davf-yyyymmdd
              value                wrk-from-date
              .
           03 label
              line                 2 
              col                  45
              size                 20 cells
              title                "To date"
              transparent
              .
           03 de-to-date 
              date-entry
              Numeric
              line                 2 
              col                  54 
              size                 20 cells
              value-format         davf-yyyymmdd
              value                wrk-to-date
              .
           03 Push-Button
              exception-value 1
              line 2
              column 106
              size 12 cells 
              self-act
              title "&Load"
              flat
              background-color     78-pb-background-color
              foreground-color     78-pb-foreground-color
              disabled-background-color 
                                   rgb 78-pb-disabled-background-color
              disabled-foreground-color 
                                   rgb 78-pb-disabled-foreground-color
              rollover-foreground-color 
                                   rgb 78-pb-rollover-foreground-color
              .
           03 gd-audit
              grid
              line 5
              column 3
              size 115
              lines 32
              width-in-cells
              height-in-cells
              color 513
              boxed
              centered-headings
              column-headings
              use-tab
              vscroll
              adjustable-columns
              reordering-columns
              filterable-columns
              Sortable-Columns
              row-dividers 1
              cursor-background-color rgb x#ffff8e
              cursor-foreground-color rgb x#100000
              row-cursor-background-color rgb x#395a9d
              row-cursor-foreground-color rgb x#cee3f6
              end-color 16
              heading-color 513
              heading-menu-popup 191
              cursor-frame-width 1
              border-color rgb x#acacac
              protection 1
              event GD-AUDIT-EVENT 
              .

       01  screen-tb-audit.
           03 Push-Button
              exception-value 78-exe-exit
              line 1.3
              column 106
              size 12 cells 
              lines 2 cells 
              flat
              self-act
              title "Exit"
              bitmap-handle tools-png
              square
              bitmap-number 2
              bitmap-rollover 4
              bitmap-width 16
              title-position 2
              rollover-foreground-color 
                                   rgb 78-pb-toolbar-rollover-color
              .

       01  screen-key-segment.
           02 gd-segment
              grid
              line 2
              column 3
              size 100
              lines 17 
              width-in-cells
              color 513
              boxed
              centered-headings
              column-headings
              use-tab
              vscroll
              adjustable-columns
              row-dividers 1
              cursor-background-color rgb x#ffff8e
              cursor-foreground-color rgb x#100000
              row-cursor-background-color rgb x#395a9d
              row-cursor-foreground-color rgb x#cee3f6
              end-color 16
              heading-color 513
              cursor-frame-width 1
              num-rows 17
              border-color rgb x#acacac
              protection 1
              .

       01  screen-tb-key-segment.
           03 Push-Button
              exception-value 78-exe-exit
              line 1.3
              column 92
              size 12 cells 
              lines 2 cells 
              flat
              self-act
              title "Exit"
              bitmap-handle tools-png
              square
              bitmap-number 2
              bitmap-rollover 4
              bitmap-width 16
              title-position 2
              .

       PROCEDURE DIVISION.
       DECLARATIVES.
       AUDITLOG-ERR section.
           use after standard error procedure on auditlog.
           perform ERROR-FILE.

       AUDITFILSETTINGS-ERR section.
           use after standard error procedure on auditfilesettings.
           perform ERROR-FILE.

       END DECLARATIVES.

       MAIN-LOGIC.
           call "J$GETFROMLAF" using jget-laf-font
                                     "Label.font" 
                                     control-font

           perform OPEN-FILES.

           perform LOAD-BITMAPS.

           accept wrk-from-date from century-date
           move wrk-from-date   to wrk-to-date
           set show-key-details to false

           display independent graphical window 
                   background-low
                   size 120
                   lines 37
                   cell size is label font control-font
                   label-offset 20
                   control font control-font
                   background-low
                   visible 0
                   modeless
                   system menu
                   title-bar
                   no wrap
                   title "Audit Analysis"
                   handle w-audit-handle
                   gradient-color-1     78-pb-foreground-color
                   gradient-color-2 rgb 78-gradient-color-2 
                   .

           display tool-bar 
                   lines 2.5 
                   control font control-font 
                   handle tb-audit-handle 
                   upon w-audit-handle

           display screen-tb-audit upon tb-audit-handle.
           display screen-audit.

           perform SCREEN-AUDIT-SCREEN-SETTINGS.

           perform LOAD-GRID.

           modify w-audit-handle visible 1

           perform until key-status = 78-exe-exit
              accept screen-audit
                 on exception 
                    continue
              end-accept
              perform AFTER-ACCEPT
              move 4 to accept-control
           end-perform

           perform EXIT-PRG.
           goback
           .

       LOAD-BITMAPS.
           copy resource "../fonts/Font Awesome 5 Free-Solid-900.otf".
           call "w$createfont" 
                       using "Font Awesome 5 Free-Solid-900.otf" 
                             wrk-font-name

           initialize wfont-data
           set wfdevice-console to true
           move wrk-font-name   to wfont-name
           move 10              to wfont-size
           call "W$FONT" using wfont-get-font
                               h-font-awsome
                               wfont-data

           string nx"f2ed" |delete 
                  nx"f2f5" |exit 
                  into toolbar-characters.

           initialize wbitmap-lsf-data
           move h-font-awsome               to wbitmap-lsf-font(1)
                                               wbitmap-lsf-font(2)
           move toolbar-characters          to wbitmap-lsf-characters(1)
                                               wbitmap-lsf-characters(2)
           move 78-toolbar-color            to wbitmap-lsf-color(1)
           move 78-toolbar-rollover-color   to wbitmap-lsf-color(2)
           call "W$BITMAP" using wbitmap-load-symbol-font-ex
                                 16
                                 wbitmap-lsf-data
                          giving tools-png
           .


       EXIT-PRG.
           destroy w-audit-handle.
           destroy tb-audit-handle.
           perform DESTROY-RESOURCE
           perform CLOSE-FILE
           .

       DESTROY-RESOURCE.
           destroy control-font.
           call "w$bitmap" using wbitmap-destroy tools-png.

       CLOSE-FILE.
           close auditlog.
           close auditfilesettings.

       SCREEN-AUDIT-SCREEN-SETTINGS.
           perform GD-FILE-CONTENT.

       GD-FILE-CONTENT.
           modify gd-audit
                  column-dividers (1 1 1 1 1 1 1)
                  data-columns ( record-position of rgl-users-id
                                 record-position of rgl-date
                                 record-position of rgl-time
                                 record-position of rgl-operation
                                 record-position of rgl-program-name
                                 record-position of rgl-file-name
                                 record-position of rgl-file-key
                                )
                  display-columns ( 1 10 25 35 55 70 85 )
                  separation ( 5 5 5 5 5 5 5 )
                  alignment ( "L" "C" "C" "L" "L" "L" "L" )
                  filter-types (2, 2, 3, 2, 2, 2, 3)
                  data-types ( "x(-1)" 
                               "D,yyyy MM dd" 
                               "D,hh:mm:ss" 
                               "X" 
                               "X" 
                               "X" 
                               "X" ).

           modify gd-audit x = 1, y = 1  cell-data "User id".
           modify gd-audit x = 2, y = 1  cell-data "Date".
           modify gd-audit x = 3, y = 1  cell-data "Time".
           modify gd-audit x = 4, y = 1  cell-data "Operation".
           modify gd-audit x = 5, y = 1  cell-data "Program".
           modify gd-audit x = 6, y = 1  cell-data "File".
           modify gd-audit x = 7, y = 1  cell-data "Key".

       AFTER-ACCEPT.
           evaluate key-status
           when 1
                perform LOAD-GRID
           end-evaluate.
           
           if show-key-details 
              perform SHOW-DETAIL
           end-if.

       LOAD-GRID.
           modify gd-audit mass-update 1
                           reset-grid 2

           move 1               to idx
           move low-value       to al-key
           move wrk-from-date   to al-date
           move 0               to al-time
           move space           to al-users-id
           start auditlog key not < al-key-1
              invalid
                 continue
              not invalid
                 perform until 1 = 2
                    read auditlog next no lock
                       at end
                          exit perform
                    end-read
                    if al-date > wrk-to-date
                       exit perform
                    end-if
                    perform ADD-RECORD
                 end-perform
           end-start.
           modify gd-audit mass-update 0.

       ADD-RECORD.
           add 1             to idx
           initialize rec-grid-LOG

           move al-users-id  to rgl-users-id
           move al-date      to rgl-date
           move al-time(1:2) to ed-hh
           move al-time(3:2) to ed-mm
           move al-time(5:2) to ed-ss

           move ed-time                     to rgl-time 

           evaluate true
           when al-login
                move "Login"                to rgl-operation
                move 78-login-color         to wrk-color
           when al-logout
                move "Logout"               to rgl-operation
                move 78-logout-color        to wrk-color
           when al-start-program
                move "Program start"        to rgl-operation
                move 78-start-program-color to wrk-color

           when al-stop-program
                move "Program end"          to rgl-operation
                move 78-stop-program-color  to wrk-color


           when al-open
                move "Open"                 to rgl-operation
                move 78-open-color          to wrk-color
           when al-close
                move "Close"                to rgl-operation
                move 78-close-color         to wrk-color

           when al-delete-record
                move "Delete record"        to rgl-operation
                move 78-delete-record-color to wrk-color

           when al-delete-file
                move "Delete file"          to rgl-operation
                move 78-delete-file-color   to wrk-color
           when al-read
                move "Read"                 to rgl-operation
                move 78-read-color          to wrk-color

           when al-write
                move "Write"                to rgl-operation
                move 78-write-color         to wrk-color

           when al-rewrite
                move "Rewrite"              to rgl-operation
                move 78-rewrite-color       to wrk-color
           end-evaluate

           evaluate true
           when al-start-program
           when al-stop-program
                move al-file-program-name   to rgl-program-name
           when al-open
           when al-close
           when al-delete-file
                move al-file-program-name   to rgl-file-name

           when al-delete-record
           when al-read
           when al-write
           when al-rewrite
                move al-file-program-name   to rgl-file-name
                move al-file-key            to rgl-file-key
           end-evaluate

           modify gd-audit record-to-add rec-grid-log.
           modify gd-audit(idx) row-background-color wrk-color
           .


       GD-AUDIT-EVENT.
           evaluate event-type
           when MSG-GD-DBLCLICK
                if EVENT-DATA-1 = 7
                   inquire gd-audit(event-data-2) 
                             record-data rec-grid-log
                   if rgl-file-key not = space
                      set show-key-details to true
                      set event-action to event-action-terminate
                   end-if
                end-if
           end-evaluate.

       SHOW-DETAIL.
           set show-key-details to false.

           move rgl-users-id to afs-users-id
           move rgl-file-name   to afs-file

           read auditfilesettings no lock
              invalid
                 initialize afs-seg-info
                 move 1   to afs-key-offset(1)
                 move 100 to afs-key-size(1)
           end-read

           display floating graphical window 
                   background-low
                   size 104
                   lines 29
                   cell size is label font control-font
                   label-offset 20
                   control font control-font
                   background-low
                   visible 0
                   modeless
                   system menu
                   title-bar
                   no wrap
                   title "Audit analisys - Key segment"
                   handle w-segment-handle
                   gradient-color-1     78-pb-foreground-color
                   gradient-color-2 rgb 78-gradient-color-2 
                   .

           display tool-bar 
                   lines 2.5 
                   control font control-font 
                   handle tb-segment-handle 
                   upon w-segment-handle

           display screen-tb-key-segment upon tb-segment-handle.
           display screen-key-segment.

           perform GD-SEGMENT-CONTENT.
           perform LOAD-GRID-KEY-SEGMENTS.

           modify w-segment-handle visible 1

           perform until key-status = 78-exe-exit
              accept screen-key-segment
                 on exception continue
              end-accept
              move 4 to accept-control
           end-perform

           destroy w-segment-handle

           initialize key-status.
           .

       GD-SEGMENT-CONTENT.
           modify gd-segment
                  column-dividers ( 1 1 1)
                  data-columns (record-position of rgs-segment
                                record-position of rgs-offset
                                record-position of rgs-size
                                record-position of rgs-file-key
                                record-position of rgs-file-key-hex)
                  display-columns ( 1 10 20 30 60)
                  separation ( 5 5 5 5 5)
                  alignment ( "C" "R" "R" "L" "L")
                  data-types ( "Z" "Z(10)" "Z(3)" "X" "X" )
                  .

           modify gd-segment x = 1, y = 1 cell-data "Segment #".
           modify gd-segment x = 2, y = 1 cell-data "Offset".
           modify gd-segment x = 3, y = 1 cell-data "Size".
           modify gd-segment x = 4, y = 1 cell-data "Value".
           modify gd-segment x = 5, y = 1 cell-data "Hex Value".

       LOAD-GRID-KEY-SEGMENTS.
           perform varying idx from 1 by 1 until idx > 16
              if afs-key-size(idx) = zero
                 exit perform
              end-if
              
              move idx                   to rgs-segment
              move afs-key-offset(idx)   to rgs-offset
              move afs-key-size(idx)     to rgs-size 

              move rgl-file-key(afs-key-offset(idx):afs-key-size(idx))
                    to rgs-file-key

              call "ASCII2HEX" using 
                    rgl-file-key(afs-key-offset(idx):afs-key-size(idx)), 
                    rgs-file-key-hex

              modify gd-segment record-to-add rec-grid-segment
           end-perform.

       OPEN-FILES.
           open input auditlog.
           open input auditfilesettings.

       ERROR-FILE.
           call "C$RERR"     using crerr-status
           call "C$RERRNAME" using rerrname
           display message "Error " file-status "-" 
                           ext-status " on " rerrname  
                   title "Audit Analisys"
                   icon 2.
           goback.
           
