*> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
*> may freely modify and redistribute this program.

PROGRAM-ID. selrgb.
CONFIGURATION SECTION.
SPECIAL-NAMES.


WORKING-STORAGE SECTION.
copy "iscrt.def".
copy "isfonts.def".
copy "isgui.def".   
copy "iscobol.def".   
                                     
77  h-color        pic s9(9) comp-4.     
77  h-sta          usage handle of window.
77  h-font-big     handle of font.
77  h-font         handle of font.
77  crt-status     is special-names crt status pic 9(5).
77  close-win      pic 9 value 0.
77  flag           pic 9 value 0.
77  buffer         pic s9(10).
77  rem            pic 9(5).
77  c              pic 9.
78  title1         value "isCOBOL".

77  w-digit         pic x.
    88 is-hex-digit values "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F".

01  buffer-rgb.
    03  r-color    pic 999 value 0.
    03  g-color    pic 999 value 0.
    03  b-color    pic 999 value 0.
01  copy-rgb.
    03  r-copy     pic 999 value 255.
    03  g-copy     pic 999 value 255.
    03  b-copy     pic 999 value 255.
01  appoggio-rgb.
    03  r-copy     pic 999 value 0.
    03  g-copy     pic 999 value 0.
    03  b-copy     pic 999 value 0.
01  hex-value.
    03  hex-r      pic xx.
    03  hex-g      pic xx.
    03  hex-b      pic xx.

SCREEN SECTION.
01  mask.
    05  frame
        full-height
        line 15.5 col 39
        lines 3 size 40
        lowered.

    05  radio-button group 1
        title "Foreground"
        bitmap-handle h-color
        bitmap-number 3
        bitmap-pressed 4
        bitmap-rollover 4
        bitmap-rollover-selected 4
        bitmap-selected 3
        lines 20 size 100 col 40.5  line 16
        event ev-foreground.

    05  radio-button group 1
        title "Background"
        bitmap-handle h-color
        bitmap-number 1
        bitmap-pressed 2
        bitmap-rollover 2
        bitmap-rollover-selected 2
        bitmap-selected 1
        lines 20 size 100 col 60 line 16
        event ev-background.
                           
    05  preview, 
        label
        height-in-cells
        width-in-cells
        center
        line 1.95 col 3.3
        size 33.6 lines 16.35
        font h-font-big
        Title title1.

    05  label 
        title "Red" 
        line 2 col 40
        foreground-color RGB x#D40202.

    05  r-slider, 
        slider
        show-ticks 
        show-labels
        horizontal
        col 46 line 2
        size 34.5 lines 3.45   
        font small-font
        height-in-cells
        width-in-cells   
        max-val 255
        min-val 0 
        minor-tick-spacing 5
        major-tick-spacing 50
        event ev_slider_red.
   
    05  e-red 
        entry-field
        line 3.7 col 40,  
        size 5 cells
        value r-color
        after red-after.

    05  label 
        title "Green" 
        line 6.5 col 40
        foreground-color RGB x#4AA705.

    05  g-slider, 
        slider
        show-ticks 
        show-labels
        horizontal
        col 46 line 6.5
        size 34.5 lines 3.45
        font small-font
        height-in-cells
        width-in-cells
        max-val 255
        min-val 0       
        minor-tick-spacing 5
        major-tick-spacing 50
        event ev_slider_green.

    05  e-green 
        entry-field
        line 8.2 
        col 40,  
        size 5 cells
        value g-color
        after green-after.

    05  label 
        title "Blue" 
        line 11 col 40
        foreground-color RGB x#110795.

    05  b-slider, 
        slider
        show-ticks 
        show-labels
        horizontal
        col 46 line 11
        size 34.5 lines 3.45  
        font small-font
        height-in-cells
        width-in-cells
        max-val 255
        min-val 0   
        minor-tick-spacing 5
        major-tick-spacing 50
        event ev_slider_blue.

    05  e-blue 
        entry-field  
        3-D
        line 12.7, col 40,  
        size 5 cells
        value b-color
        after blue-after.
         
    05  frame 
        raised
        line 19, col 3.3
        size 76 cells
        lines 3 cells.

    05  label 
        right
        line 20, col 6.9, 
        size 30 cells
        title "Values for COBOL program:" .

    05  label
        line 20, col 39, 
        size 4 cells, 
        title "Hex:".

    05  e-hex 
        entry-field 
        upper 
        max-text 6
        line 20, col 44, 
        size 11 cells
        value hex-value, 
        after reverse-hex, id 101
        notify-change, event ev-ef-hex.

    05  label
        line 20, col 56, 
        size 4 cells
        title "Dec:" .

    05  e-dec 
        entry-field 
        line 20, col 61, 
        size 14 cells
        value buffer, after reverse-dec.


PROCEDURE DIVISION.
MAIN.    
   initialize wfont-data
   move "Verdana" to wfont-name
   move 28 to wfont-size
   call "W$FONT" using wfont-get-font h-font-big wfont-data 

   call "J$GETFROMLAF" using jget-laf-font
                             "Label.font" 
                              h-font

   copy resource "../resources/radio.gif".
   call "w$bitmap" using wbitmap-load 
                         "radio.gif" 
                         giving h-color.  
        
   display floating graphical window
           background-low 
           system menu
           lines 22 size 80
           min-lines 22 min-size 80     
           title "RGB colors sample"
           control font h-font
           handle h-sta
           event  EV-win
   display mask
   modify preview background-color rgb x#FFFFFF
   modify preview foreground-color rgb x#000000
   perform UPDATE-MASK.
   move 0 to close-win
   perform until close-win = 1
      accept mask on exception continue end-accept
      evaluate crt-status
      when 27  move 1 to close-win 
      
      end-evaluate
   end-perform
                             
   call "w$bitmap" using wbitmap-destroy h-color 
   destroy mask 
   destroy h-sta
   destroy h-font h-font-big
   goback.

EV_SLIDER_RED.
   evaluate event-type
      when MSG-SL-THUMB
           inquire r-slider value r-color
           perform UPDATE-MASK
           display e-red
   end-evaluate.

EV_SLIDER_GREEN.
   evaluate event-type
      when MSG-SL-THUMB
           inquire g-slider value g-color
           perform UPDATE-MASK           
           display e-green
   end-evaluate.  

EV_SLIDER_BLUE.
   evaluate event-type
      when MSG-SL-THUMB
           inquire b-slider value b-color
           perform UPDATE-MASK  
           display e-blue
   end-evaluate.  

EV-BACKGROUND.
   evaluate event-type
      when CMD-CLICKED
           if flag not = 1
              move 1 to flag
              perform REVERSE-MARSK
           end-if
   end-evaluate.

EV-FOREGROUND.
   evaluate event-type
      when CMD-CLICKED
           if flag not = 0
              move 0 to flag
              perform REVERSE-MARSK
           end-if
   end-evaluate.

EV-EF-HEX.
   if event-type = ntf-changed
      inquire e-hex value hex-value
      initialize c
      inspect hex-value tallying c for characters before initial trailing space
      move hex-value(c:1) to w-digit
      if not is-hex-digit
         move spaces to hex-value(c:1)
         modify e-hex value hex-value
                      cursor c
      end-if
      set event-action to event-action-continue
   end-if.

 REVERSE-MARSK.
   move copy-rgb     to appoggio-rgb
   move buffer-rgb   to copy-rgb
   move appoggio-rgb to buffer-rgb 
   perform UPDATE-MASK.

 UPDATE-MASK.
   compute buffer = (r-color * 65536 + g-color * 256 + b-color) * -1
   if flag = 0
      modify preview foreground-color buffer
   else
      modify preview background-color buffer
   end-if.                  
   move function dec2hex(r-color) to hex-r
   move function dec2hex(g-color) to hex-g
   move function dec2hex(b-color) to hex-b             
   inspect hex-value replacing all spaces by "0".
   display mask. 
   modify r-slider value r-color.
   modify g-slider value g-color.
   modify b-slider value b-color.

 REVERSE-DEC.
   divide function abs(buffer) by 65536 giving r-color remainder rem.
   divide rem by 256 giving g-color remainder b-color.
   perform UPDATE-MASK.

 REVERSE-HEX.        
   move function hex2dec(hex-r) to r-color.
   move function hex2dec(hex-g) to g-color.
   move function hex2dec(hex-b) to b-color.
   perform UPDATE-MASK.
 
 RED-AFTER.
   if r-color > 255 move 255 to r-color.
   display r-slider.
   perform UPDATE-MASK.

 GREEN-AFTER.   
   if g-color > 255 move 255 to g-color.
   display g-slider.
   perform UPDATE-MASK.

 BLUE-AFTER.      
   if b-color > 255 move 255 to b-color.
   display b-slider.
   perform UPDATE-MASK.
   
 EV-win.
   if event-type = cmd-close
      move 1 to close-win
   end-if.


