      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. capacity.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.

       77  wrk-idx                 usage int.

       01  customer-orders-table.
           05 orders               occurs dynamic.
              10 order-data.
                 15 order-id       pic 9(5).
                 15 items          occurs dynamic.
                    20 item-data.
                       25 item-id  pic 9(5).

       SCREEN SECTION.
       01  Mask.
           03 push-button
              line                 2
              col                  2
              size                 37
              title         "Add element to the nested occurs of Item 1"
              exception-value 1
              self-act
              .
           03 push-button
              line                 4
              col                  2
              size                 37
              title         "Add element to the nested occurs of Item 2"
              exception-value      2
              self-act
              .
           03 push-button
              line                 7
              col                  2
              size                 37
              title                "Show capacity function"
              exception-value      11
              self-act
              .
           03 Pb-exit  
              push-button
              line                 20
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.
           initialize customer-orders-table
           move 1   to order-id(1)
           move 2   to order-id(2).

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "CAPACITY Function"
                   lines 21 
                   min-lines 21 
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept  Mask 
                 on exception
                    continue
              end-accept
              evaluate crt-status
              when 1
                   compute wrk-idx = function capacity (items(1)) + 1
                   move 1 to item-id(1, wrk-idx)
              when 2
                   compute wrk-idx = function capacity (items(2)) + 1
                   move 1 to item-id(2, wrk-idx)
              when 11
                   perform CAPACITY-FUNCTION
              end-evaluate
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font

           GOBACK
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .

       CAPACITY-FUNCTION.
           display message box "Capacity of the main occurs: "
                             function capacity (orders)
                             x"0D0A"
                             "Capacity of the nested occurs of Item 1: "
                             function capacity (items(1))
                             x"0D0A"
                             "Capacity of the nested occurs of Item 2: "
                             function capacity (items(2))
           .
