      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. grid-paged.

       CONFIGURATION SECTION.

       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
       select FILE1 assign to "ISS-PGRID"
           organization indexed
           access dynamic
           record    key an-cod
           alternate key an-name with duplicates
           lock mode is manual
           status file-status
           .
     
       FILE SECTION.
       FD  FILE1.
       01  an-rec.
           03 an-cod               pic 9(9).
           03 an-name              pic x(40).
           03 an-zip               pic 9(5).
           03 an-date              pic 9(8).
           03 an-amount            pic 9(12)v9(6).

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".

       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9    value 0.

       77  base-sorg-path          pic x(20). 
       77  command                 pic x(100).

       77  cont                    pic 9(2) value 0.

       77  file-status             pic xx. 
       77  w-reason                pic x.
       77  total-rows              pic 9(9).
       77  cell-x                  pic 99.   
       77  cell-y                  pic 99.   
       77  total-pixels            pic 9(5).
       77  row-pixels              pic 9(5).
       77  linesgrid               pic 99.
       77  old-linesgrid           pic 99.

       01  gdp-rec.
           03 gdp-cod              pic z(8)9.
           03 gdp-name             pic x(40).
           03 gdp-zip              pic x(5).        
           03 gdp-date             pic 99/99/9999.
           03 gdp-amount           pic zzz,zzz,zzz,zz9.99.

       01  dateGMA                 pic 9(8).
       77  rec-ok                  pic 9.
       77  w-end                   pic 9.
       77  w-remainder             pic 999.
       77  w-temp                  pic 9(8).

       77  an-cod-bk               pic 9(9).

       77  fileprefix              pic x any length.

       01                          pic 9 value 0.
           88 reload-current-page  value 1 false 0.

       77  old-resize-delay        pic 9(3).

      *selection colors
       77  sel-bg-color            pic s9(9).
       77  sel-fg-color            pic s9(9).

       SCREEN SECTION.

       01  Mask.
           03 Gdp
              grid                  paged
              line                  2
              col                   2
              lines                 10 
              size                  68 cells
              display-columns       (1, 11, 31, 37, 47)
              data-columns          (1, 10, 50, 55, 65)
              column-headings 
              centered-headings
              heading-color         257
              border-color rgb      x#ACACAC
              boxed
              tiled-headings
              vscroll
              adjustable-columns
              search-panel          -1
              alignment             ("R", "L", "C", "C", "R")
              data-types            ("P(9)", "X(40)", "P(5)", "D(10)", 
                                     "Z(18)")  
              event                 GDP-EVENT
              Row-Background-Color-Pattern = (0, -14675438)
              .
           03 push-button
              line                 20 
              col                  2 
              size                 20 cells
              title                "View &Source [F2]"
              exception-value      2
              .
           03 Pb-exit-paged-grid  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.   
       MAIN.
           accept base-sorg-path from environment "home_source".
           call  "C$GETENV" USING "user.home"
                                  fileprefix.

           string fileprefix delimited by trailing space
                  x"0A"    delimited by size
                  "."      delimited by size
                  into fileprefix
           set environment "file.prefix" to fileprefix.

           accept old-resize-delay from environment 
                             "gui.ntf_resized_delay"

           set environment "gui.ntf_resized_delay"   to 50

      *retrive list selection color
           call "J$GETFROMLAF" using jget-laf-color
                                     "List.selectionBackground"
                                     sel-bg-color
           call "J$GETFROMLAF" using jget-laf-color
                                     "List.selectionForeground"
                                     sel-fg-color.

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call

           set environment "file.errors_ok" to "1".
           open i-o FILE1
           set environment "file.errors_ok" to "0".
           if file-status = "35"
              perform CREATE-FILE
              open i-o FILE1
           end-if

           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-scale
                   line 2
                   col 65
                   title  "PAGED GRID Control"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   handle hWin
                   event  WIN-EVT
                   control font control-font

           move 10 to linesgrid
                      old-linesgrid
           display mask


           modify Gdp mass-update 1
           perform FILL-HEADINGS
           modify Gdp action action-first-page
           modify Gdp mass-update 0

           move 2   to event-data-2
           perform COLOR-ROW
           perform until crt-status = 27 or close-win = 1
              accept mask
                 exception 
                    continue 
              end-accept
              if reload-current-page
                 set reload-current-page to false
                 inquire gdp row-capacity in linesgrid
                 if linesgrid not = old-linesgrid
                    modify Gdp mass-update 1
                    modify Gdp num-rows = linesgrid
                    move linesgrid  to old-linesgrid
                    inquire Gdp(2, 1) cell-data = gdp-cod 
                    move gdp-cod to an-cod
                    start FILE1 key not < an-cod
                       invalid
                          continue
                    end-start 
                    modify Gdp action action-current-page
                    modify Gdp mass-update 0

                 end-if
              end-if
              if crt-status = 2
                 perform VIEW-SORG
              end-if
              move 4   to accept-control
           end-perform

           destroy mask
           destroy hWin
           destroy control-font
           close FILE1
           set environment "gui.ntf_resized_delay"   to old-resize-delay
           goback
           .

       FILL-HEADINGS.
           modify GDP(1, 1) cell-data = "code"
           modify GDP(1, 2) cell-data = "name"
           modify GDP(1, 3) cell-data = "zip"
           modify GDP(1, 4) cell-data = "date"
           modify GDP(1, 5) cell-data = "price"
           .

       GDP-EVENT.
           evaluate event-type
           when msg-begin-entry 
                perform GDP-MSG-BEGIN-ENTRY
           when msg-paged-first
                perform GDP-MSG-PAGED-FIRST
           when msg-paged-last
                perform GDP-MSG-PAGED-LAST
           when msg-paged-prevpage
           when msg-paged-nextpage
                continue
           when msg-paged-prev 
                perform GDP-MSG-PAGED-PREV
           when msg-paged-next 
                perform GDP-MSG-PAGED-NEXT 
           when msg-goto-cell
           when msg-goto-cell-mouse
           when msg-goto-cell-drag
                perform COLOR-ROW
           end-evaluate
           .

       GDP-MSG-PAGED-NEXT.
           perform event-data-2 times
              perform READ-NEXT
              if w-end = 1
                 set event-action to event-action-fail
                 exit perform
              end-if
           end-perform
           if event-action not = event-action-fail
              perform ADD-ROW
           end-if
           .

       GDP-MSG-PAGED-PREV.
           perform event-data-2 times
              perform READ-PREVIOUS
              if w-end = 1
                 set event-action to event-action-fail
                 exit perform
              end-if
           end-perform
           if event-action not = event-action-fail
              modify GDP insertion-index 2
              perform ADD-ROW
           end-if
           .

       GDP-MSG-PAGED-FIRST. 
           move low-values to an-name
           start FILE1 key is not less an-name
              invalid 
                 set event-action to event-action-fail
           end-start
           .

       GDP-MSG-PAGED-LAST.
           move high-values to an-name
           start FILE1 key is not greater an-name
              invalid 
                 set event-action to event-action-fail
           end-start
           .

       READ-NEXT.
           move 0 to w-end
           perform until 1 = 2
              read FILE1 next
                 at end 
                    move 1 to w-end
                    exit perform
              end-read
              perform CHECK-ITEM
              if rec-ok = 1
                 exit perform
              end-if
           end-perform
           .

       READ-PREVIOUS.
           move 0 to w-end
           perform until 1 = 2
              read FILE1 previous
                 at end 
                    move 1 to w-end
                    exit perform
              end-read
              perform CHECK-ITEM
              if rec-ok = 1
                 exit perform
              end-if
           end-perform
           .

       ADD-ROW.
           move an-cod       to gdp-cod
           move an-name      to gdp-name
           move an-zip       to gdp-zip
           move an-date(1:4) to dateGMA(5:4)
           move an-date(5:2) to dateGMA(3:2)
           move an-date(7:2) to dateGMA(1:2)
           move dateGMA      to gdp-date
           move an-amount    to gdp-amount 
           modify GDP record-to-add gdp-rec
           .

       CHECK-ITEM.
           move 0 to rec-ok
           divide 2 into an-cod giving w-temp remainder w-remainder
           if w-remainder = 0
              move 1 to rec-ok
           else
              move 0 to rec-ok
           end-if
           .

       COLOR-ROW.
           modify GDP start-x =    1 
                      start-y =    event-data-2
                      x =          5 
                      y =          event-data-2
                      region-background-color sel-bg-color
                      region-foreground-color sel-fg-color
           . 

       GDP-MSG-BEGIN-ENTRY.
           set event-action to event-action-fail-terminate
           inquire GDP entry-reason in w-reason  
           evaluate w-reason
           when x"00"
           when x"0D" 
                perform SHOW-SELECTED-ITEM 
           when other
                continue
           end-evaluate
           .

       SHOW-SELECTED-ITEM.
           move an-cod to an-cod-bk.
           inquire GDP(event-data-2, 1) cell-data in an-cod
           read FILE1 key is an-cod
           display message box "You've chosen " an-name
           move an-cod-bk to an-cod.
           read FILE1 key is an-cod
           .

       CREATE-FILE.
           open output FILE1
           initialize an-rec
           perform 1000 times
              add 1          to an-cod
              move "name"    to an-name
              move an-cod    to an-name(6:)
              move 20051231  to an-date
              move 2500      to an-amount 
              write an-rec
           end-perform
           close FILE1
           .

       WIN-EVT.
           evaluate event-type 
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           when ntf-resized
                set reload-current-page to true
           end-evaluate
           .

       VIEW-SORG.
           initialize command
           string base-sorg-path         delimited by trailing space
                  "s-gui"                delimited by space
                  "/GRID-PAGED.cbl"      delimited by size
                                         into command.

           call run "TEXTVIEWER"  using command.
