      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. httpclient.
       ENVIRONMENT DIVISION.

       CONFIGURATION SECTION.

       REPOSITORY.
           CLASS HTTP-CLIENT as "com.iscobol.rts.HTTPClient"
           class HTTP-PARAM as "com.iscobol.rts.HTTPData.Params"
           .

       INPUT-OUTPUT SECTION.

       DATA DIVISION.

       FILE SECTION.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9      value 0. 
       77  url                     pic x(256) value 
                                   "www.google.com".
       77  parameter               pic x(256).
       77  parameter-name          pic x(256).
       77  http object reference http-client.
       77  params object reference http-param.
       77  response-code           pic S9(3).
       77  response-message        pic x any length.
       01                          pic 9.
           88 connection-ok        value 1 false zero.

       SCREEN SECTION.
       01  Mask.   

           03 Lb1 
              label
              line                 2 
              col                  2 
              title                "Type the URL of web resource and cli
      -                    "ck on 'Check' to verify if it is available"
              .
           03 Ef1 
              entry-field
              line                 4
              col                  2
              size                 68 cells
              max-text             256
              value                url
              .  
           03 Lb2 
              label
              line                 6 
              col                  2 
              title                "Parameter name"
              .
           03 Ef2 
              entry-field
              line                 8
              col                  2
              size                 68 cells
              max-text             256
              value                parameter-name
              .
           03 Lb3 
              label
              line                 10 
              col                  2 
              title                "Parameter value"
              .
           03 Ef3 
              entry-field
              line                 12
              col                  2
              size                 68 cells
              max-text             256
              value                parameter
              .
           03 Pb1 
              push-button 
              line                 14 
              col                  2
              size                 11 cells
              title                "&Check"
              exception-value      100
              self-act
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN. 

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "HTTPClient & HTTPData.Params Objects"
                   control font control-font
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   handle hWin
                   event  WIN-EVT

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept  Mask
                 on exception
                    evaluate crt-status 
                    when 100
                         perform TEST-CONNECTION
                    end-evaluate
              end-accept
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .

       TEST-CONNECTION.
           set connection-ok to true
           set http = http-client:>new()
           try 
              if parameter-name = space
                 http:>doGet (url)
              else
                 set params = http-param:>new()
                          :>add(parameter-name, parameter)
                 http:>doGet (url, params)
              end-if
           catch exception
              set connection-ok to false
              display message exception-object
           end-try.

           if connection-ok
              http:>getResponseCode (response-code)
              if response-code = 200
                 display message "Resource found"
                                 x"0D0A"
                                 "Response code: " response-code;;
              else
                 http:>getResponseMessage ( response-message )
                 display message "Resource not found!"
                                 x"0D0A"         
                                 "Response code: " response-code
                                 x"0D0A"
                                 response-message
                                 icon 2
              end-if
           end-if.

