      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. cbldeletedir.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0. 

       77  deldir-status           pic 9(5).
       77  dir-name                pic x(256).
       77  rb-value                pic 9.
       01  execution-type          pic X.
           88 standalone-execution value "A".
           88 client-execution     value "C".
           88 server-execution     value "S".
       77  e-remote                pic 9.
       77  e-standalone            pic 9.

       SCREEN SECTION.
       01  Mask.
           03  radio-button 
               line                 2
               col                  2
               title                "Stand alone"
               group                1
               group-value          1 
               value                rb-value
               exception-value      103
               enabled              e-standalone
               .
           03  radio-button 
               line                 2 
               col                  17
               title                "Run on Client"
               group                1
               group-value          2
               value                rb-value
               exception-value      103
               enabled              e-remote
               .
           03  radio-button
               line                 2 
               col                  34
               title                "Run on Server"
               group                1
               group-value          3
               value                rb-value
               exception-value      103
               enabled              e-remote
               .
           03  label
               line                4 
               col                 2
               title               "Directory: "
               .
           03  ef-dir
               entry-field
               line                6 
               col                 2
               size                68 cells
               value               dir-name
               .
           03  push-button
               line                8 
               col                 2
               title               "&Delete"
               exception-value     100
               self-act
               .
           03  Pb-exit  
               push-button
               line                20
               col                 62
               size                8 cells
               title               "Exit" 
               exception-value     27
               .

       PROCEDURE DIVISION.
       MAIN.
           accept terminal-abilities from terminal-info.
           if is-remote
              move 1                     to e-remote
              move zero                  to e-standalone
              move 2                     to rb-value
              set client-execution       to true
           else
              move zero                  to e-remote
              move 1                     to e-standalone
              move 1                     to rb-value
              set standalone-execution   to true
           end-if
           perform RETRIVE-USER-HOME-DIR

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "CBL_DELETE_DIR routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font
                   handle hWin 
                   event  WIN-EVT

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept Mask
                 on exception 
                    evaluate crt-status 
                    when 100
                         perform DELETE-DIR
                    when 103
                         if rb-value = 2
                            set client-execution   to true
                         else
                            set server-execution   to true
                         end-if
                         perform RETRIVE-USER-HOME-DIR
                         modify ef-dir value dir-name
                 end-evaluate
              end-accept
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       RETRIVE-USER-HOME-DIR.
           evaluate true
           when client-execution
                call client "C$GETENV" using "user.home"
                                              dir-name
           when standalone-execution
           when server-execution
                call "C$GETENV" using "user.home"
                                      dir-name
           end-evaluate
           .

       DELETE-DIR.
           evaluate true
           when client-execution
                call client "CBL_DELETE_DIR" using dir-name
                                            giving deldir-status
           when standalone-execution
           when server-execution
                call "CBL_DELETE_DIR" using dir-name
                                     giving deldir-status
           end-evaluate.

           evaluate deldir-status
           when 0
                display message "Directory successfully deleted"
                        icon     mb-default-icon
           when 14613
                display message "You have selected a Directory"
                        icon    mb-default-icon
           when 14605
                display message "Directory does not exist"
                        icon    mb-default-icon
           when 14628
                display message "The Direcotry already exists"
                        icon    mb-default-icon
           when 14629
                display message "Directory is not empty"
                        icon     mb-error-icon
           end-evaluate 
           .

       WIN-EVT.
           if event-type = cmd-close
              move 1 to close-win
           end-if
           .