      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. CBLDIR.

       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
       select FILE1 assign to "-F cbldir.txt"
           organization line sequential
           status file-status
           .

       FILE SECTION.
       FD  FILE1.
       01  file1-rec   pic x(10).

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              is special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.

       77  wstatus                 pic s9.
       77  initial-dir-name        pic x(256).
       77  current-dir-name        pic x(256).
       77  new-dir-name            pic x(256).
       77  original-dir-name       pic x(256).

       77  flags                   pic x(4) comp-5.
       77  directory-size          pic x(4) comp-5.
       

       77  file-status             pic xx.

       SCREEN SECTION.
       01  Mask.
           03 label
              line                03
              col                 03
              title               "Initial working directory " & 
                                  "(CBL_READ_DIR):" 
              .
           03 entry-field
              size                50 cells
              line                05 
              col                 03 
              value               initial-dir-name
              read-only
              .
           03 label
              line                07
              col                 03
              title               "Current working directory:" 
              .
           03 ef-current-dir
              entry-field
              size                50 cells
              line                09 
              col                 03 
              value               current-dir-name
              read-only
              .
           03 label
              line                11
              col                 03
              title               "New working directory:" 
              .
           03 ef-new-dir
              entry-field
              size                50 cells
              line                13
              col                 03
              value               new-dir-name
              .
           03 push-button  
              line                15
              col                 3
              title               "&Change Directory" 
              exception-value     13
              size                15
              self-act
              .
           03 Pb-exit  
              push-button
              line                20
              col                 62
              size                8 cells
              title               "Exit" 
              exception-value     27
              .

       PROCEDURE DIVISION.
       MAIN.

           initialize new-dir-name

           set directory-size to size of initial-dir-name
           call "cbl_read_dir" using initial-dir-name, 
                                     directory-size

           move 0      to flags
           set directory-size   to size of original-dir-name 
           call "CBL_GET_CURRENT_DIR" using by value flags
                                  by value directory-size
                                           original-dir-name
                                    giving wstatus
                                    
           move original-dir-name to current-dir-name
           call "C$GETENV" USING "user.home"
                                 new-dir-name

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "CBL_GET_CURRENT_DIR, CBL_READ_DIR and " & 
                          "CBL_CHANGE_DIR Routines"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept Mask
                 on exception
                    continue
              end-accept
              evaluate crt-status 
              when 13
                   perform CHANGE-DIR
              end-evaluate
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font

      *    restore the original the working directory 
           call "CBL_CHANGE_DIR" using original-dir-name

           goback
           .

       CHANGE-DIR.

      *    change dir by CBL_CHANGE_DIR
           inquire ef-new-dir value new-dir-name
           call "CBL_CHANGE_DIR" using new-dir-name
                                 giving wstatus
           evaluate wstatus
           when 0
                open output file1
                close file1

                display message "Current working directory: " 
                                function trim(new-dir-name)
                                x"0A" "Check the file cbl.txt "
                                "into the new working directory."
                        title   "Working Directory"   
                move new-dir-name  to current-dir-name
                modify ef-current-dir value current-dir-name
           when other
                display message "CBL_CHANGE_DIR failed" 
                        title   "Working Directory"   
           end-evaluate.

       WIN-EVT.
           if event-type = cmd-close
              move 1 to close-win
           end-if.
   