      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. CBLDIRSCAN.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  crt-status              special-names crt status pic 9(5).
       77  close-win               pic 9 value 0.

       77  hDir                    handle.

       01  pattern.
           03 pattern-length       pic x(2) comp-n.
           03 pattern-content      pic x(128).

       77  search-attribute        pic x(4) comp-n.
       77  search-flags            pic x(4) comp-n.

       01  dir-entry.
           03  dir-attribute       pic x(4) comp-n.
           03  dir-date-stamp.
               05 dir-year         pic x(4) comp-n.
               05 dir-month        pic x(2) comp-n.
               05 dir-day          pic x(2) comp-n.
               05 dir-hour         pic x(2) comp-n.
               05 dir-minute       pic x(2) comp-n.
               05 dir-second       pic x(2) comp-n.
               05 dir-millisec     pic x(2) comp-n.
               05 dir-dst          pic x(1) comp-n.
               05 dir-size         pic x(8) comp-n.
               05 dir-name.
                  07 dir-name-len  pic x(2) comp-n value 32.
                  07 dir-entry-name pic x(32).

       77  dirname                 pic x(128). 
       77  rb-value                pic 9.
       01  execution-type          pic X.
           88 standalone-execution value "A".
           88 client-execution     value "C".
           88 server-execution     value "S".
       77  e-remote                pic 9.
       77  e-standalone            pic 9.

       SCREEN SECTION.
       01  Mask.
           03 radio-button 
              line                 2 
              col                  2
              title                "Stand alone"
              group                1
              group-value          1 
              value                rb-value
              exception-value      103
              enabled              e-standalone
              .
           03 radio-button 
              line                 2 
              col                  17
              title                "Run on Client"
              group                1
              group-value          2
              value                rb-value
              exception-value      103
              enabled              e-remote
              .
           03 radio-button 
              line                 2
              col                  34
              title                "Run on Server"  
              group                1
              group-value          3
              value                rb-value
              exception-value      103
              enabled              e-remote
              .
           03 label
              line                 4
              col                  2
              size                 4 cells
              title                "Dir:"
              .
           03 ef-dir
              entry-field
              line                 4 
              col                  7 
              size                 52 cells
              max-text             256
              value                dirname
              .
           03 push-button 
              default-button
              line                 4
              col                  60
              size                 10 cells
              title                "Content"
              exception-value      100
              self-act
              .
           03 ls-content
              list-box
              line                 6
              col                  2
              lines                13 cells
              size                 68 cells
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       INI.    
           accept terminal-abilities from terminal-info.
           if is-remote
              move 1                     to e-remote
              move zero                  to e-standalone
              move 2                     to rb-value
              set client-execution       to true
           else
              move zero                  to e-remote
              move 1                     to e-standalone
              move 1                     to rb-value
              set standalone-execution   to true
           end-if
           perform RETRIVE-USER-HOME-DIR
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "CBL_DIR_SCAN Routines"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask

           perform DIR-CONTENT

           perform until crt-status = 27 or close-win = 1
              accept Mask
                 on exception
                    evaluate crt-status 
                    when 100
                         perform DIR-CONTENT
                    when 103
                         if rb-value = 2
                            set client-execution   to true
                         else
                            set server-execution   to true
                         end-if
                         perform RETRIVE-USER-HOME-DIR
                         modify ls-content reset-list 1
                    end-evaluate
              end-accept
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           GOBACK
           .

       RETRIVE-USER-HOME-DIR.
           evaluate true
           when client-execution
                call client "C$GETENV" USING "user.home"
                                              dirname
           when standalone-execution
           when server-execution
                call "C$GETENV" USING "user.home"
                                      dirname
           end-evaluate
           .

       DIR-CONTENT.
           modify ls-content reset-list 1
           inquire ef-dir value dirname
           if dirname = space
              modify ls-content item-to-add "<<invalid directory>>"
              exit paragraph
           end-if
           initialize  pattern
           string dirname delimited by trailing space
                  "/*"    delimited by size
                  into pattern-content
           inspect pattern-content tallying pattern-length 
                       for characters before low-value
           move 1         to search-attribute
           move 3         to search-flags
           evaluate true
           when client-execution
                call client "CBL_DIR_SCAN_START" using hDir
                                                       pattern
                                                       search-attribute
                                                       search-flags 
           when standalone-execution
           when server-execution
                call "CBL_DIR_SCAN_START" using hDir
                                                pattern
                                                search-attribute
                                                search-flags 
           end-evaluate
           if return-code not = 0
              modify ls-content item-to-add "<<invalid directory>>"
              exit paragraph
           end-if
           perform until exit
              initialize dir-entry-name
              evaluate true
              when client-execution
                   call client "CBL_DIR_SCAN_READ" using hDir, dir-entry
              when standalone-execution
              when server-execution
                   call "CBL_DIR_SCAN_READ" using hDir, dir-entry
              end-evaluate
              if return-code = 0    
                 modify ls-content item-to-add dir-entry-name
              else
                 exit perform
              end-if
           end-perform
           evaluate true
           when client-execution
                call client "CBL_DIR_SCAN_END" using hDir
           when standalone-execution
           when server-execution
                call "CBL_DIR_SCAN_END" using hDir
           end-evaluate
           .

       WIN-EVT.  
           if event-type = cmd-close
              move 1 to close-win
           end-if
           .
