      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. CPRELOAD.

       WORKING-STORAGE SECTION.
       copy "iscobol.def".   
       copy "isresize.def".
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "isopensave.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.
       77  ret                     pic 9.
       77  v-local                 pic 9.

       77  jar-name                pic x(256).  
       77  folder-name             pic x(256).  
       77  wrk-message             pic x any length.
       77  n-icon                  pic 9.
       77  opensave-status         pic s9.

       SCREEN SECTION.
       01  Mask.
           03 frame
              engraved
              line                 2
              col                  2
              lines                8 cells
              size                 68 cells
              title                "Choose the jar to preload"
              .
           03 label
              line                 4
              col                  3
              size                 66 cells
              title                "The jar file must be in the CLASSPAT
      -                            "H before you start this isCOBOL Samp
      -                            "le"
              .
           03 ef-jar
              entry-field
              line                 6
              col                  3
              size                 61 cells
              value                jar-name
              max-text             256
              . 
           03 push-button
              line                 6
              col                  + 2
              size                 4 cells
              title                "..."
              exception-value      101
              visible              v-local
              .
           03 push-button
              default-button
              line                 8
              col                  3
              size                 8 cells
              title                "&Preload"
              exception-value      100
              .
           03 frame
              engraved
              line                 11
              col                  2
              lines                8 cells
              size                 68 cells
              title                "Choose the Class Folder to preload"
              .
           03 label
              line                 12
              lines                2
              col                  3
              size                 66 cells
              title                "The class folder must be either in t
      -                            "he CLASSPATH or in the Code Prefix f
      -                            "or the preloaded classes to be calla
      -                            "ble by Cobol Programs"
              .
           03 ef-folder
              entry-field
              line                 15
              col                  3
              size                 61 cells
              value                folder-name
              max-text             256
              . 
           03 push-button
              line                 15
              col                  + 2
              size                 4 cells
              title                "..."
              exception-value      201
              visible              v-local
              self-act
              .
           03 push-button
              default-button
              line                 17
              col                  3
              size                 8 cells
              title                "&Preload"
              exception-value      200
              self-act
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.    
           accept terminal-abilities from terminal-info.
           if is-remote
              move zero   to v-local
           else
              move 1      to v-local
           end-if

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "C$PRELOAD Routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept  Mask
                 on exception
                    continue
              end-accept
              evaluate crt-status
              when 100   
                   perform PRELOAD-JAR
              when 101
                   perform SEARCH-JAR
              when 200   
                   perform PRELOAD-FOLDER
              when 201
                   perform SEARCH-FOLDER
              end-evaluate
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .

       SEARCH-JAR.
           move "JAR file (*.jar)|*.jar" to opnsav-filters.
           call "C$OPENSAVEBOX" using opensave-open-box, opensave-data
                               giving opensave-status.
           if opensave-status > 0
              move opnsav-basename to jar-name
              modify ef-jar value jar-name 
           else
              move 0 to crt-status
           end-if
           .

       SEARCH-FOLDER.
           initialize opensave-data
           move "Choose a Class folder" to opnsav-title
           call "C$OPENSAVEBOX" using opensave-browse-folder, 
                                      opensave-data
                               giving opensave-status

           if opensave-status > 0
              move opnsav-filename to folder-name
              modify ef-folder value folder-name
           else
              move 0 to crt-status
           end-if
           .

       PRELOAD-JAR.
           call "C$PRELOAD" using jar-name
                            giving ret

           initialize wrk-message

           evaluate ret
           when 0
                string "An error has occurred, the " 
                                            delimited by size
                       jar-name             delimited by trailing space
                       " cannot be found or has an invalid format"
                                            delimited by size
                       into wrk-message
                move mb-error-icon to n-icon
                
           when 1 
                string "The "               delimited by size
                       jar-name             delimited by trailing space
                       " is going to be preloaded"
                                            delimited by size
                       into wrk-message
                move mb-warning-icon to n-icon

           when 2 
                string "The "               delimited by size
                       jar-name             delimited by trailing space
                       " preloading has not finished yet"
                                            delimited by size
                       into wrk-message
                move mb-warning-icon to n-icon

           when 3 
                string "The "                delimited by size
                       jar-name             delimited by trailing space
                       " has been preloaded" delimited by size
                       into wrk-message
                move mb-default-icon to n-icon
           end-evaluate.
           
           display message wrk-message
                      icon n-icon.

       PRELOAD-FOLDER.
           call "C$PRELOAD" using folder-name
                            giving ret

           initialize wrk-message

           evaluate ret
           when 0
                string "An error has occurred, the '" 
                                            delimited by size
                       folder-name          delimited by trailing space
                       "' cannot be found or has an invalid format"
                                            delimited by size
                       into wrk-message
                move mb-error-icon to n-icon
           when 1 
                string "The '"              delimited by size
                       folder-name          delimited by trailing space
                       "' is going to be preloaded"
                                            delimited by size
                       into wrk-message
                move mb-warning-icon to n-icon
           when 2 
                string "The '"              delimited by size
                       folder-name          delimited by trailing space
                       "' preloading has not finished yet"
                                            delimited by size
                       into wrk-message
                move mb-warning-icon to n-icon
           when 3 
                string "The '"               delimited by size
                       folder-name           delimited by trailing space
                       "' has been preloaded" delimited by size
                       into wrk-message
                move mb-default-icon to n-icon
           end-evaluate.

           display message wrk-message
                      icon n-icon.
