      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. CREGEXP.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.
                                           
       77  source-str              pic x any length.
       77  expression              pic x any length.

       77  h-regex                 handle.
       77  h-match                 handle.

       77  reg-expr                pic x(300).
       77  text-to-parse           pic x(300).
       77  w-error                 pic x any length.

       77  match-start             pic 9(3).
       77  match-end               pic 9(3).

       01  gd-rec.
           05 gd-start             pic 9(3).
           05 gd-end               pic 9(3).
           05 gd-value             pic x(50).

       01                          pic 9.
           88 no-more-match        value 1 false 0.
       01                          pic 9.
           88 one-match-found      value 1 false 0.

       77  num-of-match            pic 9(3).
       77  idx                     pic 9(3).
       
       77  rb-case                 pic 9 value 1.
           88 case-sensitive       value 1.
           88 case-insensitive     value 2.

       77  reg-exp-flag            pic 9.

       SCREEN SECTION.
       01  Mask.
           03 label 
              line                 2
              col                  2
              size                 22 cells
              title                "String to parse:" 
              .
           03 entry-field 
              line                 2
              lines                3
              col                  20
              size                 50 cells
              multiline 
              value                source-str
              .   
           03 label 
              line                 6
              col                  2
              size                 22 cells
              title                "Regular Expression:" 
              .
           03 entry-field 
              line                 6
              col                  20
              size                 50 cells 
              value                expression
              .   
           03 label 
              line                 8
              col                  2
              size                 22 cells
              title                "Search type:" 
              .
           03 radio-button 
              line                 8 
              col                  20
              title                "Case Sensitive"
              group                1
              group-value          1 
              value                rb-case
              . 
           03 radio-button 
              line                 8 
              col                  38
              title                "Case Insensitive"
              group                1
              group-value          2 
              value                rb-case
              . 
           03 push-button
              line                 8
              col                  60
              size                 10 cells
              title                "&Search"
              exception-value      101
              .
           03 frame
              engraved
              title                "Result"
              line                 10
              col                  2
              lines                10
              size                 68
              .
           03 gd
              grid 
              line                 11.5
              col                  3
              lines                5
              size                 66 cells
              display-columns      (1, 10, 20)
              data-columns         (1, 4, 7)
              alignment            ("C", "C", "L")
              data-types           ("9", "9", "X") 
              protection           1
              Row-Background-Color-Pattern (0, -14675438)
              border-color         rgb x#ACACAC
              boxed
              column-headings 
              centered-headings
              tiled-headings
              Vscroll
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "C$REGEXPL Routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           call "c$regexp" using cregexp-get-level.
           if return-code = 0
              display message "Regular expressions not supported."
                      icon mb-warning-icon
              destroy hWin
              goback
           end-if.

           move "Using Regexp is cool. I'm a regexp's Master" 
                          to source-str

           move "regexp" to expression

           display Mask

           modify  gd x 1, y 1, cell-data "Start"
           modify  gd x 2, y 1, cell-data "End"
           modify  gd x 3, y 1, cell-data "Value"

           perform until crt-status = 27 or close-win = 1
              accept Mask 
                 on exception 
                    continue 
              end-accept
              evaluate crt-status 
              when 101 
                   perform REGEXP
              end-evaluate
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       REGEXP.
           modify gd reset-grid = 2

      *compile the regexp
           initialize reg-expr
           string expression delimited by trailing space
                  x"00"      delimited by size 
                  into reg-expr.

           evaluate true
           when case-sensitive 
                move 0 to reg-exp-flag
           when case-insensitive 
                move cregexp-compile-ignorecase   to reg-exp-flag
           end-evaluate

           call "c$regexp" using cregexp-compile, 
                                 reg-expr
                                 reg-exp-flag
                          giving h-regex
           if h-regex = 0
              perform CHECK-ERROR
           else
      *    check the match with the regexp
              move source-str to text-to-parse
              perform CHECK-TEXT
      *    release regexp memory
              call "c$regexp" using cregexp-release, 
                                    h-regex
           end-if.

       CHECK-TEXT.
           move 0 to match-start
                     match-end 

           set no-more-match    to false.
           set one-match-found  to false.

           perform until no-more-match
              call "c$regexp" using cregexp-match, 
                                    h-regex, 
                                    text-to-parse, 
                                    0
                                    match-start, match-end
                             giving h-match
              if h-match = 0
                 perform CHECK-ERROR
                 if no-more-match
                    exit perform
                 end-if
              else
                 perform SHOW-RESULT
      
                 call "c$regexp" using cregexp-release-match, 
                                       h-match
                 move match-end to match-start
                 set one-match-found  to true
              end-if
           end-perform.

           if not one-match-found
              display message "The regular expression did not find a"
                              " match in the given string"
           end-if.

       SHOW-RESULT.

           move match-start  to gd-start
           move match-end    to gd-end
           move text-to-parse (match-start:match-end - match-start)
                             to gd-value
           modify gd record-to-add gd-rec
           .

       CHECK-ERROR.
           call "c$regexp" using cregexp-last-error, 
                                 w-error

           evaluate return-code
           when cregexp-error-unexpected        
                display message "An unknown error occurred"
                                x"0D0A" w-error
           when cREGEXP-ERROR-INVALID-RANGE     
                display message "An invalid range was given"
                                x"0D0A" w-error
           when cregexp-error-invalid-handle    
                display message "The handle is not a regular expression"
                                " handle or a match handle"
                                x"0D0A" w-error
           when cregexp-error-no-match          
                set no-more-match to true
           when other
                display message "Error " return-code 
                                x"0D0A" w-error
           end-evaluate
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
