      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. CSOCKET.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscoblib.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status                 special-names crt status pic 9(5).
       77  hWin                       handle of window.
       77  control-font               handle of font.
       77  close-win                  pic 9 value 0.
                                            
       77  server-name                pic x(128).
       77  server-port                pic x(5).
       77  Socket-handle              handle.
       
       77  data-to-send               pic x any length.
       77  first-byte                 pic x.
       77  segment-of-data-received   pic x(10).
       77  data-received              pic x any length.

       77  op-time                    pic 9(8).

       01  gd-operation-rec.
           05 time-operation          pic x(5).
           05 kind-operation          pic x(10).
           05 result-operation        pic x(50). 

       77  data-length                pic 9(3) value 100.
       77  read-amount                pic s999.

       77  returncode                 pic s9.
       77  e-disconnect               pic 9 value zero.
       77  e-connect                  pic 9 value 1.

       77  num-of-packet              pic 9(10).
       77  size-of-last-packet        pic 9(2).

       01  kind-of-result             pic x.
           88 type-error              value "e".
           88 type-ok                 value "o".
           88 type-description        value "d".

       78  78-red                  value x#C40000.
       78  78-green                value x#00AE00.

       SCREEN SECTION.
       01  Mask.
           03 frame
              engraved
              title                "Server"
              line                 2
              col                  2
              lines                4
              size                 68
              .
           03 label
              line                 4
              col                  3
              size                 10 cells
              title                "Name:"
              .
           03 entry-field
              line                 4
              col                  10
              size                 20 cells 
              value                server-name
              enabled              e-connect
              .
           03 label
              line                 4
              col                  33 
              size                 10 cells
              title                "Port:"
              .
           03 entry-field 
              line                 4 
              col                  40 
              size                 6 cells
              max-text             5
              value                server-port
              enabled              e-connect
              .
           03 pb-conect
              push-button 
              line                 4 
              col                  48
              size                 10 cells   
              title                "Connect"
              exception-value      101
              enabled              e-connect
              .
           03 pb-disconect
              push-button
              line                 4 
              col                  59
              size                 10 cells   
              title                "Disconnect"
              exception-value      102
              enabled              e-disconnect
              .
           03 frame
              engraved
              title                "Data to send (send 'QUIT' to close t
      -                            "he server)"
              line                 7
              col                  2
              lines                4
              size                 68
              .
           03 label 
              line                 9
              col                  3 
              size                 10 cells
              title                "Data:"
              .
           03 entry-field 
              line                 9 
              col                  10 
              size                 50 cells
              value                data-to-send
              upper
              enabled              e-disconnect
              .
           03 push-button
              line                 9 
              col                  61
              size                 8 cells   
              title                "Send"
              exception-value      103
              enabled              e-disconnect
              .
           03 frame
              engraved
              title                "Log"
              line                 12
              col                  2
              lines                7.5
              size                 68
              .
           03 gd
              grid 
              line                 14
              col                  3
              lines                3
              size                 66 cells
              display-columns      (1, 10, 20)
              data-columns         (1, 6, 16)
              alignment            ("C", "L", "L")
              data-types           ("X(5)", "X(10)", "X(50)") 
              protection           1
              Row-Background-Color-Pattern (0, -14675438)
              border-color         rgb x#ACACAC
              Vscroll
              .
           03 push-button
              line                 20 
              col                  2 
              size                 20 cells
              title                "Run server" 
              exception-value      201
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  61 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.
           move "127.0.0.1"  to server-name
           move "8765"       to server-port

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "C$SOCKET Routine (CLIENT)"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept Mask 
                 on exception 
                    continue 
              end-accept
              evaluate crt-status 
              when 101
                   perform CONNECT-SERVER
              when 102
                   perform DISCONNECT-SERVER
              when 103
                   if data-to-send = "QUIT"
                      perform DISCONNECT-SERVER
                   else
                      perform SEND-TO-SERVER
                   end-if
              when 201
                   perform LAUNCH-SERVER
              end-evaluate
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       CONNECT-SERVER.
           modify gd reset-grid = 1

           call "C$SOCKET" using csocket-create-client
                                 server-port, 
                                 server-name
                          giving socket-handle

           move "CONNNECT" to kind-operation
           initialize result-operation 

           if Socket-handle > 0
              set type-ok    to true
              string "Something is listening on port " delimited by size
                     server-port                       delimited by size
                     " of "                            delimited by size
                     server-name                       delimited by size
                     into result-operation
              move zero   to e-connect
              move 1      to e-disconnect
              display mask
           else                             
              set type-error to true
              string "Cannot connect on port "         delimited by size 
                     server-port                       delimited by size
                     " of "                            delimited by size 
                     server-name                       delimited by size
                     into result-operation
           end-if
           perform SHOW-RESULT.

       DISCONNECT-SERVER.
           move "QUIT" to data-to-send
           perform SEND-TO-SERVER
           perform CLOSE-CLIENT
           move 1      to e-connect
           move zero   to e-disconnect
           display mask
           .

       CLOSE-CLIENT.
           call "C$SOCKET" using csocket-close
                                 Socket-handle.
           move "CLOSE" to kind-operation
           move "Connection closed" to  result-operation.
           set type-ok to true.
           perform  SHOW-RESULT.

       SEND-TO-SERVER.
           set data-length to size of data-to-send

           call "C$SOCKET" using csocket-write, 
                                 socket-handle,
                                 data-to-send, 
                                 data-length
                          giving returnCode

           move "SEND"                   to kind-operation
           if returnCode < 0
              set type-error             to true
              move "Failed to send data" to result-operation
              perform SHOW-RESULT
           else
              set type-ok       to true
              move data-to-send to result-operation
              perform SHOW-RESULT
              perform RECEIVE-DATA
           end-if.

       RECEIVE-DATA.
           move 1   to data-length
           call "C$SOCKET" using csocket-read, 
                                 socket-handle,
                                 first-byte
                                 data-length
                          giving read-amount

           move "RECEIVE"  to kind-operation
           if read-amount < 0
              set type-error                to true
              move "Failed to receive data" to result-operation
           else
              perform READ-DATA-FROM-SERVER
              move data-received            to result-operation
           end-if.
           perform SHOW-RESULT.

       READ-DATA-FROM-SERVER.
           move first-byte to data-received

      *    Retreive the size of the buffer to read
           move 0   to data-length
           call "C$SOCKET" using CSOCKET-READ, 
                                 socket-handle,
                                 segment-of-data-received 
                                 data-length
                          giving read-amount

           divide read-amount   by 10 giving num-of-packet
                                      remainder size-of-last-packet

           perform num-of-packet times
              move 10 to data-length
              call "C$SOCKET" using CSOCKET-READ, 
                                    socket-handle,
                                    segment-of-data-received, 
                                    data-length
                             giving read-amount
              string data-received             delimited by size
                     segment-of-data-received  delimited by size
                     into data-received
           end-perform.

           if size-of-last-packet not = zero
              move size-of-last-packet   to DATA-LENGTH
              call "C$SOCKET" 
                   using CSOCKET-READ, 
                         socket-handle,
                         segment-of-data-received(1:size-of-last-packet)
                         data-length
                  giving read-amount
              string data-received delimited by size
                     segment-of-data-received(1:size-of-last-packet)
                                   delimited by size
                     into data-received
           end-if.

       LAUNCH-SERVER.
           call run "CSOCSERVER"  using server-port.

       SHOW-RESULT.
           accept op-time  from time
           initialize time-operation
           string op-time(1:2)   delimited by size
                  ":"            delimited by size
                  op-time(3:2)   delimited by size
                  into time-operation

           modify Gd insertion-index 1.
           modify Gd record-to-add gd-operation-rec
                     cursor-x= 1
                     x = 1.

           evaluate true
           when type-error
                modify gd(1) row-foreground-color rgb 78-red
           when type-ok
                modify gd(1) row-foreground-color rgb 78-green
           end-evaluate.

           set type-description to true.


       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
