      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. WIMAGESIZE.

       WORKING-STORAGE SECTION. 
       copy "iscrt.def".
       copy "isfonts.def".
       copy "isgui.def".        
       copy "isopensave.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(3).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.

       77  w-lar                   pic 9(5)v99.
       77  w-alt                   pic 9(5)v99.
       77  hBmp                    pic s9(9) comp-4.
       77  v-local                 pic 9.
       77  bitmap-path             pic x(256).

       SCREEN SECTION.
       01  Mask.
           03 Ef1
              entry-field 
              line                 2 
              col                  2 
              size                 60 cells
              value                bitmap-path
              .
           03 Pb1  
              push-button
              line                 2 
              col                  62 
              size                 8 cells
              title                "..." 
              exception-value      101
              visible              v-local
              self-act
              .
           03 Pb-image  
              push-button
              line                 4 
              col                  2 
              size                 12 cells
              title                "Get size" 
              exception-value      102
              self-act
              .
           03 label
              line                 6
              col                  2
              size                 8 cells
              title                "Width:"
              .
           03 lb-w
              label
              line                 6
              col                  12
              .
           03 label
              line                 8
              col                  2
              size                 8 cells
              title                "Height:"
              . 
           03 lb-h
              label
              line                 8
              col                  12
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.
           accept terminal-abilities from terminal-info.
           if is-remote
              move zero   to v-local
           else
              move 1      to v-local
           end-if
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "W$IMAGESIZE Routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           move "files/img.png" to bitmap-path

           display Mask 
           perform GET-SIZE
 
           perform until crt-status = 27  or close-win = 1
              accept Mask 
                     on exception 
                        continue 
              end-accept
              evaluate 
              crt-status 
              when 101
                   perform BROWSE-IMG
              when 102
                   perform GET-SIZE
              end-evaluate
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           GOBACK
           .

       BROWSE-IMG.   
           initialize opensave-data
           string "BMP Files (*.bmp)|*.bmp|"
                  "JPG Files (*.jpg)|*.jpg|"
                  "GIF Files (*.gif)|*.gif|"
                  "PNG Files (*.png)|*.png|"
                  "All images (*.bmp;*.jpg;*.gif;*.png)|"
                  "*.bmp;*.jpg;*.gif;*.png"
                  delimited by size
                  into opnsav-filters.

           move 5   to opnsav-default-filter

           call "C$OPENSAVEBOX" using opensave-open-box, opensave-data

           if return-code not < 0
              move opnsav-filename to bitmap-path 
              modify ef1 value bitmap-path
              perform GET-SIZE
           end-if
           .

       GET-SIZE.
           move zero   to w-lar 
                          w-alt
           call "W$BITMAP" using wbitmap-load, bitmap-path
                          giving hBmp

           evaluate hBmp
           when -1
                display message "W$BITMAP Error: "
                                "File not found or not readable"
                                icon mb-error-icon
           when -2
                display message "W$BITMAP Error: "
                                "Out of memory loading the bitmap"
                                icon mb-error-icon
           when -3
                display message "W$BITMAP Error: "
                                "Not a valid bitmap"
                                icon mb-error-icon
           when -4
                display message "W$BITMAP Error: "
                                "Format not supported"
                                icon mb-error-icon
           when other
                call "W$IMAGESIZE" using hBmp, w-lar, w-alt
           end-evaluate
    
           modify lb-w title w-lar
           modify lb-h title w-alt
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
