      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       IDENTIFICATION DIVISION.
       PROGRAM-ID. print-csv-data-client.
       ENVIRONMENT DIVISION.
       CONFIGURATION SECTION.
       SPECIAL-NAMES.
       REPOSITORY.
           class fileinputstream 
                           as "java.io.FileInputStream"
           class HashMap   as "java.util.HashMap"
           class ioexception 
                           as "java.io.IOException"
           class isCobolJbean 
                           as "com.iscobol.gui.server.CobolGUIJavaBean"
           class jboolean  as "java.lang.Boolean"
           class jf        as "java.io.File"
           class jobject   as "java.lang.Object"
           class Map       as "java.util.Map"
           class vbyte     as "byte[]"
           class vstring   as "java.lang.String[]"
           .

       input-output section.
       file-control.
       data division.
       file section.
       working-storage section.
       copy "isgui.def".
       copy "iscobol.def".
       copy "iscrt.def".
       copy "isfonts.def".
       copy "isresize.def".

       77  contents          object reference vbyte.
       77  myJR              object reference isCobolJbean.
       77  columnname        object reference vstring.
       77  parameters        object reference Map.
       77  instream          object reference fileinputstream.

       77  crt-status        is special-names crt status pic 9(5).

       77  hWin                      handle of window.
       77  control-font              handle of font.
       77  close-win                 pic 9 value 0.
       77  report-name               pic x any length.
       77  csv-name                  pic x any length.
       77  logo-name                 pic x any length.
       77  server-logo-name          pic x any length.
       77  filename                  pic x any length.
       77  path-copy-client-image    pic x any length.

       01  file-info.
           02 file-size              pic x(8) comp-x.
           02 file-date              pic 9(8) comp-x.
           02 file-time              pic 9(8) comp-x.
       77  wstatus                   pic s9.

       linkage section.
           copy "PRINT-CSV.lnk".

       screen section.

       01  mask.
           03 screen-1-jb-1 Java-Bean
              line 2
              column 2
              size 143 cells 
              lines 43 cells 
              id 1
              layout-data 17
              boxed
              clsid "com.veryant.javabeans.jasperreport.ReportViewer"
              object in myJR
              .
           03 pb-exit 
              Push-Button
              exception-value 27
              line 47
              column 68
              size 12 cells 
              lines 3 cells 
              title "exit"
              .
       PROCEDURE DIVISION USING kind-of-print string-parameters.
       main.

           accept report-name from environment "report_source_path"
           string report-name  delimited by size
                               "reportCSV.jrxml" delimited by size
                  into report-name

           accept csv-name from environment "data_source_path"
           string csv-name      delimited by size
                  "product.csv" delimited by size
                  into csv-name

           perform PREPARE-LOGO

           call "J$GETFROMLAF" using jget-laf-font
                                     "Label.font" 
                                     control-font
           display independent graphical window 
                   background-low  
                   resizable 
                   layout-manager lm-scale
                   title "isCOBOL - Print CSV file with Jasper preview"
                   lines 50
                   min-lines 50
                   size 145
                   min-size 80
                   color 257
                   visible 0
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT
                   .

           display Mask

           perform INITIALIZE-MASK

           perform until crt-status = 27 or close-win = 1
              accept Mask 
                 on exception 
                    continue 
              end-accept
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       INITIALIZE-MASK.
           move report-name  to filename.
           perform read-file-contents.
           myjr:>callMethod("setReport" contents)
     
           move csv-name to filename.
           perform read-file-contents.
           myjr:>callMethod("setDataSource" contents)
     
           set columnname to vstring:>new(5)
           set columnname(0) to "Brand"
           set columnname(1) to "Code"
           set columnname(2) to "Name"
           set columnname(3) to "Description"
           set columnname(4) to "Price"
           myjr:>setProperty("dataSourceColumnNames" columnname)
     
           myjr:>setProperty("dataSourceUseFirstRowAsHeader" 
                             jboolean:>TRUE)
     
           myjr:>setProperty("dataSourceFieldDelimiter" ";" as string)
     
           set parameters to HashMap:>new
           parameters:>put("param1" as string, 
                           string-parameters as string)
           parameters:>put("logo-path" as string, 
                           logo-name as string)

           myjr:>setProperty("reportParameters" parameters as jobject)

           evaluate true
           when to-printer
      *>   Print the report
                myjr:>callMethod("printReport")
                move 27  to crt-status
           when to-preview
      *>   Preview the report
                myjr:>callMethod("showReport")
                modify hWin visible 1
           end-evaluate
           .

       READ-FILE-CONTENTS.
           try
              set instream to fileinputstream:>new(filename as string)
              set contents to vbyte:>new(instream:>available)
              instream:>read(contents)
              instream:>close
           catch ioexception
             exception-object:>printStackTrace
           end-try.

       WIN-EVT.
           if event-type = cmd-close
              move 1 to close-win
           end-if
           .
           
       PREPARE-LOGO.

           call client "C$GETENV" USING "user.home"
                                        logo-name

           string logo-name          delimited by trailing space
                  "/VeryantLogo.gif" delimited by size
                  into logo-name

           call client "C$FILEINFO" using logo-name, file-info
                                   giving wstatus
           evaluate wstatus
           when 0
                continue
           when 1
                accept server-logo-name from environment
                                                      "resources_path"
                string server-logo-name          delimited by size
                       "VeryantLogo.gif"  delimited by size
                       into server-logo-name

                initialize path-copy-client-image
                string "@[DISPLAY]:" delimited by size
                       logo-name     delimited by size
                       into path-copy-client-image

               call "C$COPY" USING server-logo-name 
                                   path-copy-client-image
           end-evaluate.

           