Vue.component('notification', {
  props: {
    notification: {
      type: Object
    },
    index: Number
  },
  template:` <div>
    <a href="#"  @click="toggleExpand($event)" class="dropdown-item">
      <i v-bind:class="notificationIcon()" class="fas mr-2"></i> {{notification.entries.length}} new {{notification.type}}
      <span class="float-right text-muted text-sm">
        <i v-if="notification.expanded" class="fas fa-chevron-up"></i>
        <i v-if="!notification.expanded" class="fas fa-chevron-down"></i>
      </span>
    </a>
    
  <div class="d-flex flex-column" v-if="notification.expanded">
  <div v-for="(entry,index) in notification.entries" class="ml-4 p-2 visible-on-hover">
    {{entry.label}}
    <span class="float-right text-muted text-sm ml-2"
    @click="deleteNotification($event, index)"> 
      <i class="fas fa-times" alt="delete notification" title="delete notification"></i>
    </span>
  </div>
  </div>

<div class="dropdown-divider"></div>
</div>
`,

  methods:{
    countElements(){
      return this.notification.entries.length;
    },
    notificationIcon(){
      return 'fas 2x ' + this.notification.icon;
    },
    toggleExpand(event){
      event.preventDefault();
      event.stopPropagation();
      this.notification.expanded = !this.notification.expanded;
    },
    deleteNotification(event,index){
      event.preventDefault();
      event.stopPropagation();
      this.$emit('delete-notification', {notificationType: this.notification.type, index:index});
    }

  }
})
