      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       program-id.                 menurun.

       working-storage section.
       copy "iscrt.def".

       77  key-status     is special-names crt status pic 9(5).
       77  prg-to-lunch   pic x(15).
       77  hWin           handle of window.
       77  close-win      pic 9 value 0.
       77  external-var   pic x(20) external.
       77  link-var       pic x(20).
       77  num-program    pic 9(3).

       screen section.
       01  mask.
           03 Pb1 
              push-button
              line              3
              col               7
              size              20
              title             "Progam 1"
              exception-value   101
              .
           03 Pb2 
              push-button
              line              6
              size              20
              col               7
              title             "Program 2"
              exception-value   102
              .
           03 Pb-exit  
              push-button
              line              9 
              col               7 
              size              20
              title             "Exit" 
              exception-value   27
              .

       procedure division.
       MAIN.
           set environment "gui.quit_mode"  to 27
           set environment "my_environment" to "My Environment".
           move "External"                  to external-var

           display standard graphical window
                   background-low  
                   line 2
                   col 65
                   title  "Menu with 'call run'"
                   lines 11 
                   size 34
                   handle hWin
                   .

           display Mask upon hWin

           perform until key-status = 27
              accept mask
                 on exception continue
              end-accept
              evaluate key-status
              when 101
                   move "program1" to prg-to-lunch
                   perform CALL-PGM
              when 102
                   move "program2" to prg-to-lunch
                   perform CALL-PGM
              when 27
                   perform VERIFY-PROGRAM-EXECUTION
                   if num-program > 0
                      move zero to key-status
                   end-if
              end-evaluate
              move 4 to accept-control
           end-perform       

           modify hwin visible 0
           destroy mask
                   hWin 

           goback
           .

       CALL-PGM.
           initialize link-var
           string "link " 
                  prg-to-lunch
                  into link-var
           call run prg-to-lunch using link-var
              on overflow
                       perform CALL-NOT-FOUND
           end-call.

       CALL-NOT-FOUND.
           display message box "Program not Found!".

       VERIFY-PROGRAM-EXECUTION.
           call "C$NCALLRUN" giving num-program
           if num-program > 0
              display message "Close all called programs before exit!"
           end-if
           .

