/*
 * Decompiled with CFR 0.152.
 */
package IT.picosoft.isam;

import IT.picosoft.isam.FLock;
import IT.picosoft.isam.ILocking;
import IT.picosoft.isam.IsamException;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class OSFile {
    public static final int O_RDONLY = 0;
    public static final int O_WRONLY = 1;
    public static final int O_RDWR = 2;
    public static final int O_CREAT = 64;
    public static final int O_EXCL = 128;
    public static final int O_TRUNC = 512;
    public static final int O_SYNC = 4096;
    private RandomAccessFile osFile;
    private ILocking channel;
    private String jMode;
    private File theFile;
    public boolean encrypt = false;
    public static final Class LOCK_CLASS;

    private void checkReopen() throws IsamException {
        int status = 0;
        try {
            status = this.osFile.getFD().valid() ? 1 : 0;
            status += this.channel.isOpen() ? 2 : 0;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            switch (status) {
                case 0: {
                    this.osFile = new RandomAccessFile(this.theFile, this.jMode);
                    this.channel.init(this.osFile);
                    break;
                }
                case 2: {
                    this.channel.close();
                    this.osFile = new RandomAccessFile(this.theFile, this.jMode);
                    this.channel.init(this.osFile);
                    break;
                }
                case 1: {
                    try {
                        this.osFile.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.osFile = new RandomAccessFile(this.theFile, this.jMode);
                    this.channel.init(this.osFile);
                    break;
                }
            }
        }
        catch (IOException ex) {
            throw new IsamException(ex);
        }
    }

    public synchronized void open(String name, int mode) throws IsamException {
        switch (mode & 3) {
            default: {
                this.jMode = "r";
                break;
            }
            case 1: 
            case 2: {
                this.jMode = (mode & 0x1000) != 0 ? "rws" : "rw";
            }
        }
        this.theFile = new File(name);
        try {
            if ((mode & 0x40) != 0) {
                if ((mode & 0x200) != 0) {
                    this.theFile.delete();
                }
                boolean isNew = this.theFile.createNewFile();
                if ((mode & 0x280) != 0 && !isNew) {
                    throw new IsamException(132);
                }
            }
            if (!this.theFile.exists()) {
                throw new IsamException(130);
            }
            this.osFile = new RandomAccessFile(this.theFile, this.jMode);
            this.channel = (ILocking)LOCK_CLASS.newInstance();
            this.channel.init(this.osFile);
        }
        catch (NullPointerException ex) {
            throw new IsamException(133, ex);
        }
        catch (InstantiationException ex) {
            throw new IsamException(133, ex);
        }
        catch (IllegalAccessException ex) {
            throw new IsamException(133, ex);
        }
        catch (FileNotFoundException ex) {
            if (this.theFile.exists()) {
                throw new IsamException(113, ex);
            }
            throw new IsamException(130, ex);
        }
        catch (IOException ex) {
            throw new IsamException(133, ex);
        }
    }

    public int read(byte[] b) throws IsamException {
        return this.read(b, 0, b.length);
    }

    public synchronized int read(byte[] b, int offs, int len) throws IsamException {
        try {
            return this.osFile.read(b, offs, len);
        }
        catch (EOFException ex) {
            throw new IsamException(110, ex);
        }
        catch (IOException ex) {
            throw new IsamException(ex);
        }
    }

    public synchronized int readBlk(byte[] b, int offs, int len) throws IsamException {
        try {
            return this.osFile.read(b, offs, len);
        }
        catch (EOFException ex) {
            throw new IsamException(110, ex);
        }
        catch (IOException ex) {
            throw new IsamException(ex);
        }
    }

    public synchronized char readChar() throws IsamException {
        try {
            return this.osFile.readChar();
        }
        catch (EOFException ex) {
            throw new IsamException(110, ex);
        }
        catch (IOException ex) {
            throw new IsamException(ex);
        }
    }

    public synchronized int readInt() throws IsamException {
        try {
            return this.osFile.readInt();
        }
        catch (EOFException ex) {
            throw new IsamException(110, ex);
        }
        catch (IOException ex) {
            throw new IsamException(ex);
        }
    }

    public synchronized long tell() throws IsamException {
        try {
            return this.osFile.getFilePointer();
        }
        catch (EOFException ex) {
            throw new IsamException(110, ex);
        }
        catch (IOException ex) {
            throw new IsamException(ex);
        }
    }

    public synchronized long length() throws IsamException {
        try {
            return this.osFile.length();
        }
        catch (IOException ex) {
            throw new IsamException(ex);
        }
    }

    public synchronized void setLength(long nlen) throws IsamException {
        try {
            this.osFile.setLength(nlen);
        }
        catch (IOException ex) {
            throw new IsamException(ex);
        }
    }

    public synchronized void seek(long pos) throws IsamException {
        try {
            this.osFile.seek(pos);
        }
        catch (EOFException ex) {
            throw new IsamException(110, ex);
        }
        catch (IOException ex) {
            throw new IsamException(ex);
        }
    }

    public void write(byte[] b) throws IsamException {
        this.write(b, 0, b.length);
    }

    public synchronized void write(byte[] b, int offset, int len) throws IsamException {
        try {
            this.osFile.write(b, offset, len);
        }
        catch (IOException ex) {
            throw new IsamException(ex);
        }
    }

    public synchronized void writeBlk(byte[] b, int offset, int len) throws IsamException {
        try {
            this.osFile.write(b, offset, len);
        }
        catch (IOException ex) {
            throw new IsamException(ex);
        }
    }

    public synchronized void writeChar(int v) throws IsamException {
        try {
            this.osFile.writeChar(v);
        }
        catch (IOException ex) {
            throw new IsamException(ex);
        }
    }

    public synchronized void writeInt(int v) throws IsamException {
        try {
            this.osFile.writeInt(v);
        }
        catch (IOException ex) {
            throw new IsamException(ex);
        }
    }

    public synchronized void close() throws IsamException {
        try {
            this.channel.close();
            this.osFile.close();
        }
        catch (IOException ex) {
            throw new IsamException(ex);
        }
    }

    public synchronized void fcntl(int cmd, FLock arg) throws IsamException {
        try {
            this.channel.fcntl(cmd, arg);
        }
        finally {
            this.checkReopen();
        }
    }

    public static void unlink(String name) throws IsamException {
        File f = new File(name);
        if (!f.exists()) {
            throw new IsamException(130);
        }
        if (!f.delete()) {
            throw new IsamException(133);
        }
    }

    public static void rename(String src, String dst) throws IsamException {
        File fs = new File(src);
        File fd = new File(dst);
        if (!fs.exists()) {
            throw new IsamException(130);
        }
        if (!fs.renameTo(fd)) {
            throw new IsamException(133);
        }
    }

    public static OSFile get() {
        return new OSFile();
    }

    public static OSFile get(String passwd) {
        if (passwd != null && passwd.length() > 0) {
            return new Encrypted(passwd);
        }
        return new OSFile();
    }

    public byte[] decrypt(byte[] b, int offs, int len) throws IsamException {
        if (this instanceof Encrypted) {
            return ((Encrypted)this).realDecrypt(b, offs, len);
        }
        return b;
    }

    public void setEncrypt() {
        this.encrypt = true;
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("IT.picosoft.isam.RealLocking");
        }
        catch (Throwable _ex) {
            try {
                clazz = Class.forName("IT.picosoft.isam.DummyLocking");
            }
            catch (ClassNotFoundException _ex1) {
                clazz = null;
            }
        }
        LOCK_CLASS = clazz;
    }

    static class Encrypted
    extends OSFile {
        private int blkLen = 0;
        private final Cipher cipher;
        private final SecretKeySpec password;
        private final IvParameterSpec iv = new IvParameterSpec(new byte[]{126, -56, -18, -103, -57, 115, 33, -116});

        private Encrypted(String key) {
            try {
                this.cipher = Cipher.getInstance("Blowfish/CFB/NoPadding");
                byte[] bKey = key.getBytes();
                this.password = new SecretKeySpec(bKey, 0, bKey.length, "Blowfish");
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public void writeBlk(byte[] b, int offset, int len) throws IsamException {
            if (this.blkLen != len) {
                if (this.blkLen == 0) {
                    this.blkLen = len;
                } else {
                    throw new IsamException(102, "" + len + "!=" + this.blkLen);
                }
            }
            try {
                this.cipher.init(1, (Key)this.password, this.iv);
                super.writeBlk(this.cipher.doFinal(b, offset, len), 0, len);
            }
            catch (InvalidKeyException ex) {
                throw new IsamException(ex);
            }
            catch (IllegalBlockSizeException ex) {
                throw new IsamException(ex);
            }
            catch (BadPaddingException ex) {
                throw new IsamException(ex);
            }
            catch (InvalidAlgorithmParameterException ex) {
                throw new IsamException(ex);
            }
        }

        @Override
        public int readBlk(byte[] b, int offs, int len) throws IsamException {
            int Return2 = 0;
            if (this.blkLen != len) {
                if (this.blkLen == 0) {
                    this.blkLen = len;
                } else {
                    throw new IsamException(102, "" + len + "!=" + this.blkLen);
                }
            }
            try {
                byte[] in = new byte[len];
                this.cipher.init(2, (Key)this.password, this.iv);
                Return2 = super.readBlk(in, 0, len);
                if (Return2 > 0) {
                    this.cipher.doFinal(in, 0, Return2, b, offs);
                }
            }
            catch (InvalidKeyException ex) {
                throw new IsamException(ex);
            }
            catch (IllegalBlockSizeException ex) {
                throw new IsamException(ex);
            }
            catch (BadPaddingException ex) {
                throw new IsamException(ex);
            }
            catch (ShortBufferException ex) {
                throw new IsamException(ex);
            }
            catch (InvalidAlgorithmParameterException ex) {
                throw new IsamException(ex);
            }
            return Return2;
        }

        public byte[] realDecrypt(byte[] b, int offs, int len) throws IsamException {
            byte[] Return2 = new byte[len];
            try {
                this.cipher.init(2, (Key)this.password, this.iv);
                this.cipher.doFinal(b, offs, len, Return2, 0);
            }
            catch (InvalidKeyException ex) {
                throw new IsamException(ex);
            }
            catch (IllegalBlockSizeException ex) {
                throw new IsamException(ex);
            }
            catch (BadPaddingException ex) {
                throw new IsamException(ex);
            }
            catch (ShortBufferException ex) {
                throw new IsamException(ex);
            }
            catch (InvalidAlgorithmParameterException ex) {
                throw new IsamException(ex);
            }
            return Return2;
        }
    }
}

