/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.AmbiguousException;
import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.MissingClassException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Set;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenList;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UndefinedException;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableDeclarationList;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.VariableNameList;
import com.iscobol.compiler.Verb;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;

public class Declare
extends Verb
implements CobolToken,
ErrorsNumbers {
    static final String INLINE_CLASS_PFX = "LocalVars$";
    static final String INLINE_OBJECT_PFX = "locVars$";
    private static int declUniqueId;
    private VariableDeclarationList varList = new VariableDeclarationList();
    private ArrayList<Set> values = new ArrayList();

    public Declare(Token kw, Block par, Pcc p, TokenManager t, Errors err, VariableDeclarationList varList) {
        super(kw, par, p, t, err);
        this.varList = varList;
        int n = varList.getItemNum();
        for (int i = 0; i < n; ++i) {
            this.values.add(null);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public Declare(Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        Token tk = this.tm.getToken();
        if (tk.getToknum() != 10009) {
            throw new GeneralErrorException(24, 4, tk, tk.getWord(), this.error);
        }
        this.checkAlreadyDefined();
        TokenList tl = new TokenList();
        tl.addItem(tk);
        while ((tk = this.tm.getToken()).getToknum() == 10009) {
            this.checkAlreadyDefined();
            tl.addItem(tk);
        }
        this.tm.ungetToken();
        Token varName = tl.getFirst();
        while (varName != null) {
            VariableDeclaration var;
            Set set;
            TokenManager.Marker mk;
            block30: {
                block29: {
                    block28: {
                        mk = this.tm.getMarker();
                        this.tm.setMarker(mk);
                        tk = this.tm.getToken();
                        set = null;
                        if (tk.getToknum() != 280) break block28;
                        this.tm.ungetToken();
                        var = Declare.loadParam(t, err, this.pc, this.pc.parent, varName);
                        var.error = this.error;
                        tk = t.getToken();
                        if (tk.getToknum() != 61) break block29;
                        VariableNameList vnl = new VariableNameList();
                        vnl.addItem(new VariableName(var));
                        set = new Set(this.getKeyWord(), this.parent, this.pc, this.tm, this.error, vnl, var.isObjectReference());
                        break block30;
                    }
                    if (tk.getToknum() != 61) {
                        throw new UnexpectedTokenException(tk, this.error);
                    }
                    var = VariableDeclaration.getObject(this.pc, varName, this.tm, "java.lang.Object", false);
                    VariableNameList vnl = new VariableNameList();
                    vnl.addItem(new VariableName(var));
                    set = new Set(this.getKeyWord(), this.parent, this.pc, this.tm, this.error, vnl, var.isObjectReference());
                    var.setUsed();
                    break block30;
                }
                block21: while (true) {
                    switch (tk.getToknum()) {
                        case 609: {
                            var.occurs(tk);
                            if (var.isDynamic()) {
                                var.dyDimension = 1;
                                break;
                            }
                            var.dimension = 1;
                            break;
                        }
                        case 548: 
                        case 549: {
                            var.justified(tk);
                            break;
                        }
                        case 304: {
                            var.blank(tk);
                            break;
                        }
                        default: {
                            this.tm.ungetToken();
                            break block21;
                        }
                    }
                    tk = this.tm.getToken();
                }
            }
            var.setModifier(0);
            if (set != null) {
                set.check();
            } else if (var.isObjectReference()) {
                int ln = kw.getFLN();
                int offs = kw.getOffset();
                String fn = kw.getFileName();
                switch (var.getClassName()) {
                    case "boolean": {
                        var.setValueToken(new Token(481, "FALSE", ln, offs, fn));
                        break;
                    }
                    case "byte": 
                    case "short": 
                    case "int": 
                    case "long": 
                    case "char": 
                    case "float": 
                    case "double": {
                        var.setValueToken(new Token(10002, "0", ln, offs, fn));
                        break;
                    }
                    default: {
                        Token v = new Token(601, "NULL", ln, offs, fn);
                        v.setNullFlag();
                        var.setValueToken(v);
                    }
                }
            }
            this.varList.addItem(var);
            this.values.add(set);
            this.parent.putLocalVariable(var);
            varName = tl.getNext();
            if (varName == null) break;
            this.tm.rewindToMarker(mk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAlreadyDefined() throws GeneralErrorException, EndOfProgramException {
        this.tm.ungetToken();
        boolean ie = this.error.ignoreErrors;
        VariableName vn = null;
        try {
            this.error.ignoreErrors = true;
            vn = VariableName.getAny(this.tm, this.error, this.parent, this.pc);
        }
        catch (UndefinedException undefinedException) {
        }
        finally {
            this.error.ignoreErrors = ie;
        }
        if (vn != null) {
            throw new AmbiguousException(vn.getNameToken(), this.error, vn.getName());
        }
    }

    static VariableDeclaration loadParam(TokenManager tm, Errors error, Pcc pc, Pcc parent, Token tk) throws GeneralErrorException, EndOfProgramException {
        return Declare.loadParam(tm, error, pc, parent, tk, new Token[1]);
    }

    static VariableDeclaration loadParam(TokenManager tm, Errors error, Pcc pc, Pcc parent, Token tk, Token[] varargs) throws GeneralErrorException, EndOfProgramException {
        Token argName = tk;
        tk = tm.getToken();
        if (tk.getToknum() != 280) {
            throw new ExpectedFoundException(tk, error, "AS");
        }
        tk = tm.getToken();
        String className = null;
        VariableDeclaration typedef = null;
        boolean findGenerics = false;
        if (tk.getToknum() == 10009) {
            if ("ACTIVE-CLASS".equals(tk.getWord())) {
                className = "java.lang.Object";
            } else {
                typedef = pc.getTypedefVar(tk.getWord());
                if (typedef != null) {
                    if (typedef.hasRealChildren()) {
                        throw new GeneralErrorException(320, 4, typedef.getNameToken(), typedef.getName(), error);
                    }
                    VariableDeclaration arg = VariableDeclaration.get(pc, tm, argName, typedef);
                    arg.setUsed();
                    return arg;
                }
                tm.ungetToken();
                VariableName vn = VariableName.getObject(tm, error, null, parent);
                if (vn == null || !vn.getVarDecl().isFactory) {
                    throw new MissingClassException(tk.getWord(), tk, error);
                }
                className = vn.getVarDecl().getClassName();
                findGenerics = true;
            }
        } else if (tk.getToknum() == 10001) {
            className = tk.getWord().substring(1, tk.getWord().length() - 1);
            try {
                parent.existsClass(className);
            }
            catch (ClassNotFoundException e) {
                if (className.endsWith("...")) {
                    String cn = className.substring(0, className.length() - 3) + "[]";
                    try {
                        parent.existsClass(cn);
                        className = cn;
                        varargs[0] = tk;
                    }
                    catch (ClassNotFoundException e1) {
                        throw new MissingClassException(tk.getWord(), tk, error);
                    }
                }
                throw new MissingClassException(tk.getWord(), tk, error);
            }
            findGenerics = true;
        } else {
            throw new UnexpectedTokenException(tk, error);
        }
        if (findGenerics && className.indexOf(60) < 0) {
            boolean b;
            tk = tm.getToken();
            boolean bl = b = tk.getToknum() == 60;
            if (b || tk.getToknum() == 91) {
                String args = "<";
                int target = b ? 62 : 93;
                tk = tm.getToken();
                while (tk.getToknum() != target) {
                    if (args.length() > 1) {
                        args = args + ",";
                    }
                    args = args + Declare.getClassName(tk, tm, error, pc);
                    tk = tm.getToken();
                }
                args = args + ">";
                int idx = className.indexOf(91);
                className = idx >= 0 ? className.substring(0, idx) + args + className.substring(idx) : className + args;
            } else {
                tm.ungetToken();
            }
        }
        VariableDeclaration arg = VariableDeclaration.getObject(pc, argName, tm, className, false);
        arg.setUsed();
        return arg;
    }

    private static String getClassName(Token tk, TokenManager tm, Errors error, Pcc pc) throws GeneralErrorException, EndOfProgramException {
        String Return2;
        if (tk.getToknum() == 10009) {
            tm.ungetToken();
            VariableName vn = VariableName.getObject(tm, error, null, pc);
            if (vn == null || !vn.getVarDecl().isFactory) {
                throw new MissingClassException(tk.getWord(), tk, error);
            }
            Return2 = vn.getVarDecl().getClassName();
        } else if (tk.getToknum() == 10001) {
            Return2 = tk.getWord().substring(1, tk.getWord().length() - 1);
            try {
                pc.existsClass(Return2);
            }
            catch (ClassNotFoundException e) {
                throw new MissingClassException(tk.getWord(), tk, error);
            }
        } else {
            throw new UnexpectedTokenException(tk, error);
        }
        if (Return2.indexOf(60) < 0) {
            boolean b;
            tk = tm.getToken();
            boolean bl = b = tk.getToknum() == 60;
            if (b || tk.getToknum() == 91) {
                String args = "<";
                int target = b ? 62 : 93;
                tk = tm.getToken();
                while (tk.getToknum() != target) {
                    if (args.length() > 1) {
                        args = args + ",";
                    }
                    args = args + Declare.getClassName(tk, tm, error, pc);
                    tk = tm.getToken();
                }
                args = args + ">";
                int idx = Return2.indexOf(91);
                Return2 = idx >= 0 ? Return2.substring(0, idx) + args + Return2.substring(idx) : Return2 + args;
            } else {
                tm.ungetToken();
            }
        }
        return Return2;
    }

    void moveVarsBefore(Declare d) {
        VariableDeclarationList vl = d.varList;
        VariableDeclarationList tmp = this.varList;
        this.varList = new VariableDeclarationList();
        VariableDeclaration vd = vl.getFirst();
        while (vd != null) {
            this.varList.addItem(vd);
            vd = vl.getNext();
        }
        vl.reset();
        vd = tmp.getFirst();
        while (vd != null) {
            this.varList.addItem(vd);
            vd = tmp.getNext();
        }
        this.values.addAll(0, d.values);
        d.values.clear();
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    public static void resetCounters() {
        declUniqueId = 0;
    }

    @Override
    public String getCode() {
        StringBuffer Return2 = new StringBuffer();
        if (this.varList.getItemNum() > 0) {
            StringBuffer sb = new StringBuffer();
            StringBuffer dynPart = new StringBuffer();
            for (int i = 0; i < this.varList.getItemNum(); ++i) {
                VariableDeclaration vd = this.varList.getAt(i);
                sb.append(vd.getCode(dynPart));
                Set set = this.values.get(i);
                if (set == null) continue;
                dynPart.append(set.getCode());
            }
            boolean dOpt = this.pc.getOption("-d") != null;
            boolean snsOpt = this.pc.getOption("-sns=") != null;
            String indent = this.parent.getIndent();
            String declClsName = null;
            String declObjName = null;
            if (dOpt || snsOpt) {
                int uid = ++declUniqueId;
                declClsName = INLINE_CLASS_PFX + uid;
                declObjName = INLINE_OBJECT_PFX + uid;
                VariableDeclaration vd = this.varList.getFirst();
                while (vd != null) {
                    vd.inlineUid = uid;
                    vd = this.varList.getNext();
                }
                StringBuffer declCode = new StringBuffer();
                declCode.append("   private class " + declClsName + "{");
                declCode.append(eol);
                this.append(declCode, sb, "      ");
                declCode.append("      ");
                declCode.append(declClsName);
                declCode.append("() {");
                declCode.append(eol);
                this.append(declCode, dynPart, "         ");
                declCode.append("      }");
                declCode.append(eol);
                declCode.append("   }");
                declCode.append(eol);
                this.pc.addInlineDeclarationCode(declCode.toString());
                Return2.append(indent);
                Return2.append(declClsName);
                Return2.append(" ");
                Return2.append(declObjName);
                Return2.append(" = new ");
                Return2.append(declClsName);
                Return2.append("();");
                Return2.append(eol);
            } else {
                this.append(Return2, sb.append(dynPart), indent);
            }
            if (dOpt) {
                Return2.append(indent);
                Return2.append("$localVarsStack$.get().push(" + declObjName + ");");
                Return2.append(eol);
                Return2.append(indent);
                Return2.append("try {");
                Return2.append(eol);
                ++this.parent.nesting;
            }
        }
        return Return2.toString();
    }

    static String getEndBlockCode(String indent) {
        return indent + "} finally {" + eol + indent + "   " + "$localVarsStack$" + ".get().pop();" + eol + indent + "}" + eol;
    }

    private void append(StringBuffer Return2, StringBuffer sb, String indent) {
        BufferedReader r = new BufferedReader(new StringReader(sb.toString()));
        try {
            String line = r.readLine();
            while (line != null) {
                Return2.append(indent);
                Return2.append(line.trim());
                Return2.append(eol);
                line = r.readLine();
            }
            r.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public VariableDeclarationList getVars() {
        return this.varList;
    }
}

