/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.SyntaxErrorException;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.interfaces.compiler.IKeyExtension2;
import com.iscobol.interfaces.compiler.IVariableName;
import java.util.Vector;

public class Key
implements CobolToken,
ErrorsNumbers,
IKeyExtension2 {
    TokenManager tm;
    Errors error;
    VariableName keyName;
    Vector segments = new Vector();
    boolean duplicates;

    public Key(TokenManager t, Errors err, boolean primary) throws GeneralErrorException, EndOfProgramException {
        this.duplicates = primary ? false : t.getOptionList().getOption("-ci") != null;
        this.error = err;
        this.tm = t;
        this.keyName = VariableName.get(this.tm, this.error);
        Token tk = this.tm.getToken();
        if (this.keyName == null) {
            tk = this.tm.getToken();
            throw new UnexpectedTokenException(tk, this.error);
        }
        if (this.keyName.hasIndexes()) {
            throw new GeneralErrorException(55, 4, this.keyName.name, this.keyName.name.getWord(), this.error);
        }
        if (tk.getToknum() == 61) {
            this.getSegments();
        } else {
            this.tm.ungetToken();
        }
        tk = this.tm.getToken();
        if (tk.getToknum() == 814) {
            tk = this.tm.getToken();
        }
        if (tk.getToknum() == 597) {
            tk = this.tm.getToken();
            if (tk.getToknum() != 414) {
                throw new ExpectedFoundException(tk, this.error, "DUPLICATES");
            }
            this.duplicates = false;
        } else if (tk.getToknum() == 414) {
            this.duplicates = true;
        } else {
            this.tm.ungetToken();
        }
    }

    private void getSegments() throws GeneralErrorException, EndOfProgramException {
        VariableName vn;
        while ((vn = VariableName.get(this.tm, this.error)) != null) {
            if (vn.hasIndexes()) {
                throw new GeneralErrorException(55, 4, vn.name, vn.name.getWord(), this.error);
            }
            this.segments.addElement(vn);
        }
        if (this.segments.size() == 0) {
            Token tk = this.tm.getToken();
            throw new SyntaxErrorException(tk, tk.getWord(), this.error);
        }
    }

    void check(Pcc pc, VariableDeclaration vp) throws GeneralErrorException {
        if (this.segments.size() > 0) {
            for (int i = 0; i < this.segments.size(); ++i) {
                VariableName vn = (VariableName)this.segments.elementAt(i);
                if (vn.getOf() == null) {
                    vn.setOf(new VariableName(vp));
                }
                vn.check(pc);
                if (vn.getVarDecl().isIn(vp)) continue;
                throw new GeneralErrorException(168, 4, vn.name, vn.name.getWord(), this.error);
            }
        } else {
            if (this.keyName.getOf() == null) {
                this.keyName.setOf(new VariableName(vp));
            }
            this.keyName.check(pc);
            if (!this.keyName.getVarDecl().isIn(vp)) {
                throw new GeneralErrorException(168, 4, this.keyName.name, this.keyName.name.getWord(), this.error);
            }
            if ((this.tm.getOptionList().getOption("-efd") != null || this.tm.getOptionList().getOption("-efc") != null || this.tm.getOptionList().getOption("-efo=") != null) && this.keyName.getVarDecl().redefines != null) {
                this.error.print(167, 2, this.keyName.getNameToken(), this.keyName.getName());
            }
        }
    }

    public String getCode() {
        StringBuffer Return2 = new StringBuffer();
        Return2.append("/* [KEY] */" + eol);
        if (this.keyName != null) {
            Return2.append("/* keyName */" + eol + this.keyName.getCode());
            if (this.segments.size() > 0) {
                Return2.append("/* segments */" + eol);
                for (int i = 0; i < this.segments.size(); ++i) {
                    Return2.append("/* segment " + i + " */" + eol + ((VariableName)this.segments.elementAt(i)).getCode());
                }
            }
        }
        return Return2.toString();
    }

    public VariableDeclaration[] getVars() {
        VariableDeclaration[] Return2;
        if (this.segments.size() > 0) {
            Return2 = new VariableDeclaration[this.segments.size()];
            for (int i = 0; i < this.segments.size(); ++i) {
                Return2[i] = ((VariableName)this.segments.elementAt(i)).getVarDecl();
            }
        } else {
            Return2 = new VariableDeclaration[]{this.keyName.getVarDecl()};
        }
        return Return2;
    }

    public VariableName[] getVarNames() {
        VariableName[] Return2;
        if (this.segments.size() > 0) {
            Return2 = new VariableName[this.segments.size()];
            for (int i = 0; i < this.segments.size(); ++i) {
                Return2[i] = (VariableName)this.segments.elementAt(i);
            }
        } else {
            Return2 = new VariableName[]{this.keyName};
        }
        return Return2;
    }

    @Override
    public boolean isDuplicates() {
        return this.duplicates;
    }

    @Override
    public IVariableName getKeyName() {
        return this.keyName;
    }
}

