/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.DefaultClass;
import com.iscobol.compiler.InternalErrorException;
import com.iscobol.compiler.LambdaExpression;
import com.iscobol.compiler.MyField;
import com.iscobol.compiler.MyMethod;
import com.iscobol.compiler.Pcc;
import com.iscobol.interfaces.compiler.IClass;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public abstract class MyClass
implements IClass {
    static final Map<String, String> autoboxingClassNames = new HashMap<String, String>();
    static final Hashtable<Object, MyClass> myclassCache;

    public static MyClass getInstance(Pcc pc, int d) {
        return new DefaultClass(pc, d);
    }

    public static MyClass getInstance(String className) throws ClassNotFoundException {
        return MyClass.getInstance(className, null, 0);
    }

    public static MyClass getInstance(Class e) {
        MyClass c = myclassCache.get(e);
        if (c == null) {
            c = new DefaultClass(e);
            myclassCache.put(e, c);
        }
        return c;
    }

    public static MyClass getInstance(String className, Pcc pc) throws ClassNotFoundException {
        return MyClass.getInstance(className, pc, 0);
    }

    public static MyClass getInstance(String className, Pcc pc, int d) throws ClassNotFoundException {
        MyClass c = myclassCache.get(className);
        if (c == null) {
            if (pc != null) {
                return new DefaultClass(className, pc, d);
            }
            c = new DefaultClass(className, null, 0);
            myclassCache.put(className, c);
        }
        return c;
    }

    public static MyClass getInstance(MyMethod m) {
        String className = LambdaExpression.getName(m);
        MyClass c = myclassCache.get(className);
        if (c == null) {
            c = new LambdaExpression(m);
            myclassCache.put(className, c);
        }
        return c;
    }

    public abstract String getName(boolean var1);

    public abstract String getNotParameterizedName();

    public static String getAutoboxingName(String origName) {
        String s = autoboxingClassNames.get(origName);
        return s != null ? s : origName;
    }

    public abstract MyMethod[] getConstructors();

    public abstract MyMethod[] retrieveConstructors();

    public abstract MyClass[] getInterfaces();

    @Override
    public abstract MyClass getSuperclass();

    public abstract MyMethod[] getMethods(boolean var1);

    public abstract MyField[] getFields(boolean var1);

    public abstract MyField getField(String var1, boolean var2) throws NoSuchFieldException;

    @Override
    public final boolean isString(Class c) {
        return c.equals(String.class);
    }

    @Override
    public final boolean isBoolean(Class c) {
        return c.equals(Boolean.TYPE) || c.equals(Boolean.class);
    }

    @Override
    public final boolean isPrimitiveOrString(Class c) {
        return c.equals(String.class) || MyClass.isPrimitive(c);
    }

    public static boolean isPrimitive(Class c) {
        return c.isPrimitive() || MyClass.isPrimitiveWrapper(c);
    }

    public static boolean isPrimitiveWrapper(Class c) {
        return MyClass.isPrimitiveNumericWrapper(c) || c == Boolean.class || c == Character.class;
    }

    public static boolean isPrimitiveNumericWrapper(Class c) {
        return c == Byte.class || c == Short.class || c == Integer.class || c == Long.class || c == Float.class || c == Double.class;
    }

    public static boolean isPrimitiveInteger(Class c) {
        return c == Byte.TYPE || c == Short.TYPE || c == Integer.TYPE || c == Long.TYPE || c == Byte.class || c == Short.class || c == Integer.class || c == Long.class;
    }

    public static boolean isPrimitive(String c) {
        return "boolean".equals(c) || "byte".equals(c) || "short".equals(c) || "int".equals(c) || "long".equals(c) || "float".equals(c) || "double".equals(c) || "char".equals(c) || "java.lang.Boolean".equals(c) || "java.lang.Byte".equals(c) || "java.lang.Short".equals(c) || "java.lang.Integer".equals(c) || "java.lang.Long".equals(c) || "java.lang.Float".equals(c) || "java.lang.Double".equals(c) || "java.lang.Character".equals(c);
    }

    public abstract boolean isStrictPrimitive();

    public abstract boolean isPrimitiveWrapper();

    public abstract boolean isPrimitiveNumericWrapper();

    public abstract boolean isPrimitiveInteger();

    public static boolean isPrimitiveAssignableFrom(Class dst, Class src) {
        if (dst == Boolean.TYPE || dst == Boolean.class) {
            return src == Boolean.TYPE || src == Boolean.class;
        }
        if (dst == Byte.TYPE || dst == Byte.class) {
            return src == Byte.TYPE || src == Byte.class;
        }
        if (dst == Character.TYPE || dst == Character.class) {
            return src == Character.TYPE || src == Character.class;
        }
        if (dst == Short.TYPE) {
            return src == Short.TYPE || src == Short.class || src == Byte.TYPE || src == Byte.class || src == Character.TYPE || src == Character.class;
        }
        if (dst == Short.class) {
            return src == Short.TYPE || src == Short.class;
        }
        if (dst == Integer.TYPE) {
            return src == Integer.TYPE || src == Integer.class || src == Short.TYPE || src == Short.class || src == Byte.TYPE || src == Byte.class || src == Character.TYPE || src == Character.class;
        }
        if (dst == Integer.class) {
            return src == Integer.TYPE || src == Integer.class;
        }
        if (dst == Long.TYPE) {
            return src == Long.TYPE || src == Long.class || src == Integer.TYPE || src == Integer.class || src == Short.TYPE || src == Short.class || src == Byte.TYPE || src == Byte.class || src == Character.TYPE || src == Character.class;
        }
        if (dst == Long.class) {
            return src == Long.TYPE || src == Long.class;
        }
        if (dst == Float.TYPE) {
            return src == Float.TYPE || src == Float.class || src == Long.TYPE || src == Long.class || src == Integer.TYPE || src == Integer.class || src == Short.TYPE || src == Short.class || src == Byte.TYPE || src == Byte.class || src == Character.TYPE || src == Character.class;
        }
        if (dst == Float.class) {
            return src == Float.TYPE || src == Float.class;
        }
        if (dst == Double.TYPE) {
            return src == Double.TYPE || src == Double.class || src == Float.TYPE || src == Float.class || src == Long.TYPE || src == Long.class || src == Integer.TYPE || src == Integer.class || src == Short.TYPE || src == Short.class || src == Byte.TYPE || src == Byte.class || src == Character.TYPE || src == Character.class;
        }
        if (dst == Double.class) {
            return src == Double.TYPE || src == Double.class;
        }
        return false;
    }

    public abstract MyClass getWrappedType();

    public abstract boolean isAssignableFrom(MyClass var1);

    public abstract boolean isAssignableFrom(MyClass var1, boolean var2);

    public static boolean isNumericVar(String clazz) {
        try {
            return MyClass.isNumericVar(MyClass.forName(clazz));
        }
        catch (NoClassDefFoundError _ex) {
            return false;
        }
        catch (ClassNotFoundException _ex) {
            return false;
        }
    }

    public static boolean isNumericVar(Class c) {
        try {
            return MyClass.forName(Pcc.TYPES_PACKAGE + ".NumericVar").isAssignableFrom(c);
        }
        catch (ClassNotFoundException _ex) {
            throw new InternalErrorException("" + _ex);
        }
    }

    public static boolean isCobolVar(String clazz) {
        try {
            return MyClass.isCobolVar(MyClass.forName(clazz));
        }
        catch (ClassNotFoundException _ex) {
            return false;
        }
    }

    public static boolean isCobolVar(Class c) {
        try {
            return MyClass.forName(Pcc.TYPES_PACKAGE + ".CobolVar").isAssignableFrom(c);
        }
        catch (ClassNotFoundException _ex) {
            throw new InternalErrorException("" + _ex);
        }
    }

    public static boolean isNumericEditedVar(Class c) {
        try {
            return MyClass.forName(Pcc.TYPES_PACKAGE + ".PicNumEdit").isAssignableFrom(c);
        }
        catch (ClassNotFoundException _ex) {
            throw new InternalErrorException("" + _ex);
        }
    }

    public abstract boolean isNumericEditedVar();

    public abstract boolean isAssignableTo(MyClass var1, boolean var2);

    public abstract boolean isAssignableTo(MyClass var1);

    public final boolean isAssignableTo(String clazz) {
        try {
            Class c = MyClass.forName(clazz);
            return this.isAssignableTo(c);
        }
        catch (ClassNotFoundException _ex) {
            throw new InternalErrorException("" + _ex);
        }
    }

    public static boolean isAssignableFrom(Class dst, Class src) {
        if (dst.isAssignableFrom(src)) {
            return true;
        }
        if (MyClass.isPrimitive(dst) && MyClass.isPrimitive(src)) {
            return MyClass.isPrimitiveAssignableFrom(dst, src);
        }
        return false;
    }

    public abstract boolean isAbstract();

    @Override
    public abstract MyClass getComponentType();

    public abstract MyClass[] getParameters();

    public abstract String[] getParametersNames();

    public abstract MyClass getParameter(String var1);

    /*
     * Loose catch block
     */
    static Class forName(String className) throws ClassNotFoundException {
        ClassNotFoundException fe = null;
        while (true) {
            try {
                return Class.forName(className, false, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException _ex) {
                int i;
                if (fe == null) {
                    fe = _ex;
                }
                if ((i = className.lastIndexOf(46)) >= 0) {
                    className = className.substring(0, i) + '$' + className.substring(i + 1);
                    continue;
                }
                throw fe;
            }
            break;
        }
        catch (NoClassDefFoundError _ex) {
            throw new ClassNotFoundException(_ex.getMessage());
        }
    }

    public static boolean isClassAccessible(Pcc pc, MyClass clazz) {
        if (pc.getPackageName().equals(clazz.getPackageName())) {
            return true;
        }
        return clazz.isPublic();
    }

    public abstract boolean isClassAccessible(MyClass var1);

    public abstract boolean isInterface();

    public static MyClass removeDimension(MyClass mc, int dim) {
        if (!(mc instanceof DefaultClass)) {
            return MyClass.getInstance(WrongDimension.class);
        }
        DefaultClass clazz = (DefaultClass)mc;
        if (clazz.extClass != null) {
            return MyClass.getInstance(MyClass.removeDimension(clazz.extClass, dim));
        }
        if (dim <= clazz.dimensions) {
            return MyClass.getInstance(clazz.intClass, clazz.dimensions - dim);
        }
        return MyClass.getInstance(WrongDimension.class);
    }

    private static Class removeDimension(Class clazz, int dim) {
        String nc;
        int i;
        String oc = clazz.getName();
        for (i = 0; i < oc.length() && oc.charAt(i) == '['; ++i) {
            --dim;
        }
        if (dim < 0) {
            return WrongDimension.class;
        }
        String nbraces = "";
        String braces = "";
        for (int j = 0; j < dim; ++j) {
            braces = braces + "[]";
            nbraces = nbraces + "[";
        }
        if (i < oc.length() && oc.charAt(i) == 'L') {
            nc = MyClass.getClassNameCode(oc.substring(i + 1, oc.length() - 1)) + braces;
        } else {
            if (nbraces.equals("")) {
                switch (oc.charAt(i)) {
                    case 'B': {
                        return Byte.TYPE;
                    }
                    case 'C': {
                        return Character.TYPE;
                    }
                    case 'S': {
                        return Short.TYPE;
                    }
                    case 'I': {
                        return Integer.TYPE;
                    }
                    case 'J': {
                        return Long.TYPE;
                    }
                    case 'F': {
                        return Float.TYPE;
                    }
                    case 'D': {
                        return Double.TYPE;
                    }
                    case 'Z': {
                        return Boolean.TYPE;
                    }
                }
            }
            nc = nbraces + oc.charAt(i);
        }
        try {
            return MyClass.forName(nc);
        }
        catch (ClassNotFoundException _ex) {
            return clazz;
        }
    }

    public abstract boolean isFunctionalInterface();

    public abstract boolean isEnclosedClass();

    public abstract MyMethod getFunctionalMethod();

    static String getClassNameCode(String className) {
        try {
            MyClass mc = MyClass.getInstance(className);
            if (mc.isEnclosedClass()) {
                return className.replace('$', '.');
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return className;
    }

    static {
        autoboxingClassNames.put("java.lang.Boolean", "boolean");
        autoboxingClassNames.put("java.lang.Byte", "byte");
        autoboxingClassNames.put("java.lang.Short", "short");
        autoboxingClassNames.put("java.lang.Integer", "int");
        autoboxingClassNames.put("java.lang.Long", "long");
        autoboxingClassNames.put("java.lang.Float", "float");
        autoboxingClassNames.put("java.lang.Double", "double");
        autoboxingClassNames.put("java.lang.Character", "char");
        myclassCache = new Hashtable();
    }

    private static class WrongDimension {
        private WrongDimension() {
        }
    }
}

