/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ExecSql;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.SqlStatement;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;

public class SqlSavepoint
extends SqlStatement {
    private boolean unique = false;
    private boolean retainCursors = false;
    private boolean retainLocks = false;
    private String name = "";
    private Pcc pc;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SqlSavepoint(ExecSql es, Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(es, kw, par, p, t, err);
        Token tk = this.getSqlToken();
        this.pc = p;
        this.name = tk.getWord();
        tk = this.getSqlToken();
        if ("UNIQUE".equals(tk.getWord().toUpperCase())) {
            this.unique = true;
            tk = this.getSqlToken();
        }
        while (tk.getToknum() == 614) {
            tk = this.getSqlToken();
            if (tk.getToknum() != 702) throw new GeneralErrorException(31, 4, tk, "ROLLBACK/" + tk.getWord(), this.error);
            tk = this.getSqlToken();
            if (!tk.getWord().toUpperCase().equals("RETAIN")) throw new GeneralErrorException(31, 4, tk, "RETAIN/" + tk.getWord(), this.error);
            tk = this.getSqlToken();
            if (tk.getWord().toUpperCase().equals("CURSORS")) {
                this.retainCursors = true;
            } else {
                if (!tk.getWord().toUpperCase().equals("LOCKS")) throw new GeneralErrorException(31, 4, tk, "CURSORS or LOCKS/" + tk.getWord(), this.error);
                this.retainLocks = true;
            }
            tk = this.getSqlToken();
        }
        this.ungetSqlToken();
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    @Override
    public String getCode() {
        StringBuffer Return2 = new StringBuffer();
        Return2.append(this.parent.getIndent());
        this.getCodeDebug(Return2);
        Return2.append(this.getReturnCode());
        Return2.append(".set(Esql.SAVEPOINT(new Object[] {" + this.sqlcapfx + this.pc.sqlca.SQLCA + ", \"" + this.name + "\", " + this.unique + ", " + this.retainCursors + ", " + this.retainLocks + "}));");
        Return2.append(eol);
        this.addWhenever(Return2);
        this.getCodeDebugEnd(Return2);
        return Return2.toString();
    }
}

