/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.ClauseClashException;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.VariableNameList;
import com.iscobol.compiler.Verb;

public class Stop
extends Verb
implements CobolToken,
ErrorsNumbers {
    private Token label;
    private Token rCode;
    private VariableName retCode;
    private VariableNameList threadHandles;
    boolean guiWd2UnsupportedLog;

    public Stop(Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        this.guiWd2UnsupportedLog = this.pc.getOption("-wd2") != null;
        Token tk = this.tm.getToken();
        if (tk.getToknum() == 704) {
            if (this.guiWd2UnsupportedLog) {
                this.error.print(179, 2, kw, kw.getWord().toUpperCase() + " " + tk.getWord());
            }
            if ((tk = this.tm.getToken()).getToknum() == 506 || tk.getToknum() == 695) {
                tk = this.tm.getToken();
            }
            if (Token.isIntLit(tk)) {
                this.rCode = tk;
            } else if (tk.getToknum() == 10009) {
                this.tm.ungetToken();
                this.retCode = VariableName.get(this.tm, this.error, this.pc, new GetVarOpts(this, 1));
            } else {
                this.tm.ungetToken();
            }
        } else if (tk.getToknum() == 10001 || tk.getToknum() == 10002 || tk.getToknum() == 10017) {
            this.label = tk;
        } else if (tk.getToknum() == 10009) {
            this.label = tk;
            this.tm.ungetToken();
            this.retCode = VariableName.get(this.tm, this.error, this.pc, new GetVarOpts(this, 1));
        } else if (tk.getToknum() == 764) {
            this.threadHandles = new VariableNameList();
            while ((tk = this.tm.getToken()).getToknum() == 10009) {
                this.tm.ungetToken();
                VariableName threadHandle = VariableName.get(this.tm, this.error, this.pc);
                if (threadHandle == null) {
                    tk = this.tm.getToken();
                    throw new UnexpectedTokenException(tk, this.error);
                }
                if (!threadHandle.getVarDecl().isValidThreadHandle()) {
                    throw new ClauseClashException(tk, this.error, threadHandle.getName());
                }
                this.threadHandles.addItem(threadHandle);
            }
            this.tm.ungetToken();
            if (this.pc.getOption("-ca") != null) {
                this.error.print(148, 2, this.keyWord, "STOP THREAD");
            }
        } else {
            throw new UnexpectedTokenException(tk, this.error);
        }
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    @Override
    public String getCode() {
        String str;
        StringBuffer Return2 = new StringBuffer();
        Return2.append(this.parent.getIndent());
        boolean debug = this.pc.getOption("-d") != null;
        String[] outdd = this.pc.getOutddProperty();
        if (this.label != null && debug) {
            str = this.label.getToknum() != 10009 ? "\"" + this.label.getCode() + "\"" : this.retCode.getCode() + ".toString()";
            Return2.append("Debugger.stop(");
            Return2.append(Pcc.getInddProperty());
            Return2.append(',');
            Return2.append(outdd[0]);
            Return2.append(',');
            Return2.append(outdd[1]);
            Return2.append(',');
            Return2.append(outdd[2]);
            Return2.append(',');
            Return2.append(str);
            Return2.append(");");
            Return2.append(eol);
            Return2.append(this.parent.getIndent());
        }
        this.getCodeDebug(Return2);
        if (this.threadHandles != null) {
            int nt = this.threadHandles.getItemNum();
            if (nt > 0) {
                for (int i = 0; i < nt; ++i) {
                    Return2.append(eol);
                    Return2.append(this.parent.getIndent());
                    Return2.append("Factory.stopThread (");
                    Return2.append(this.threadHandles.getAt(i).getCode());
                    Return2.append(");");
                }
            } else {
                Return2.append("Factory.stopThread (null);");
            }
            Return2.append(eol);
        } else if (this.label == null) {
            if (!this.pc.isFactory()) {
                if (this.pc.getSplitFlag()) {
                    Return2.append(this.pc.getClassName() + ".this.");
                } else {
                    Pcc rootPcc = this.pc.getRoot();
                    if (rootPcc != this.pc) {
                        if (this.pc.isDefault()) {
                            Return2.append("$This$.");
                        } else {
                            Return2.append(rootPcc.getFullClassName() + ".this.");
                        }
                    }
                }
                Return2.append("finalize();" + eol);
            }
            Return2.append(this.parent.getIndent());
            Stop.getStopRunCode(Return2, this.pc.capitalizeNames, this.retCode, this.rCode);
            Return2.append(eol);
        } else if (!debug) {
            str = this.label.getToknum() != 10009 ? "\"" + this.label.getCode() + "\"" : this.retCode.getCode() + ".toString()";
            Return2.append("Factory.displayUponSysOut(");
            Return2.append(outdd[0]);
            Return2.append(',');
            Return2.append(outdd[1]);
            Return2.append(',');
            Return2.append(outdd[2]);
            Return2.append(",false,");
            Return2.append(str);
            Return2.append(");");
            Return2.append(eol);
            Return2.append(this.parent.getIndent());
            Return2.append("Factory.acceptFromConsole(");
            Return2.append(Pcc.getInddProperty());
            Return2.append(");");
            Return2.append(eol);
        }
        this.getCodeDebugEnd(Return2);
        return Return2.toString();
    }

    public static void getStopRunCode(StringBuffer Return2, boolean capitalize, VariableName rcv, Token rc) {
        Return2.append("if(true) throw new StopRunException(");
        if (rcv == null) {
            if (rc == null) {
                Return2.append(Stop.getReturnCode(capitalize) + ".toint()");
            } else {
                Return2.append(rc.getAsInt());
            }
        } else {
            Return2.append(rcv.getCode() + ".num().intValue()");
        }
        Return2.append(");" + eol);
    }

    public boolean isStopRun() {
        if (this.threadHandles != null) {
            return false;
        }
        return this.label == null;
    }

    public boolean isStopThread() {
        if (this.threadHandles != null) {
            return true;
        }
        if (this.label == null) {
            return false;
        }
        return false;
    }

    public Token getLabel() {
        return this.label;
    }

    public VariableName getRetCode() {
        return this.retCode;
    }

    public Token getRCode() {
        return this.rCode;
    }
}

