/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.coverage;

import com.iscobol.coverage.CoverageProgram;
import java.util.Collection;
import java.util.LinkedHashMap;

public class CoverageSession {
    private LinkedHashMap<String, CoverageProgram> programs = new LinkedHashMap();
    private LinkedHashMap<Long, Name> appended = new LinkedHashMap();
    public Name name = new Name();

    public Collection<CoverageProgram> getPrograms() {
        return this.programs.values();
    }

    public void addProgram(CoverageProgram program) {
        this.programs.put(program.name, program);
    }

    public CoverageProgram getProgram(String name) {
        return this.programs.get(name);
    }

    public CoverageProgram removeProgram(String name) {
        return (CoverageProgram)this.programs.remove(name);
    }

    public Collection<Name> getAppended() {
        return this.appended.values();
    }

    public void addAppend(Name n) {
        this.appended.put(n.timestamp, n);
    }

    public Name getAppend(long time) {
        return this.appended.get(time);
    }

    public Name removeAppend(long time) {
        return (Name)this.appended.remove(time);
    }

    public int getTotalParagraphs() {
        Collection<CoverageProgram> programs = this.getPrograms();
        int total = 0;
        for (CoverageProgram p : programs) {
            total += p.getTotalParagraphs();
        }
        return total;
    }

    public int getMissedParagraphs() {
        Collection<CoverageProgram> programs = this.getPrograms();
        int missed = 0;
        for (CoverageProgram p : programs) {
            missed += p.getMissedParagraphs();
        }
        return missed;
    }

    public int getTotalStatements() {
        Collection<CoverageProgram> programs = this.getPrograms();
        int total = 0;
        for (CoverageProgram p : programs) {
            total += p.getTotalStatements();
        }
        return total;
    }

    public int getMissedStatements() {
        Collection<CoverageProgram> programs = this.getPrograms();
        int missed = 0;
        for (CoverageProgram p : programs) {
            missed += p.getMissedStatements();
        }
        return missed;
    }

    public double getStatementCoverageRatio() {
        int missed = this.getMissedStatements();
        int total = this.getTotalStatements();
        double covRatio = 0.0;
        if (total > 0) {
            covRatio = 1.0 - (double)missed / (double)total;
        }
        return covRatio;
    }

    public double getParagraphCoverageRatio() {
        int missed = this.getMissedParagraphs();
        int total = this.getTotalParagraphs();
        double covRatio = 0.0;
        if (total > 0) {
            covRatio = 1.0 - (double)missed / (double)total;
        }
        return covRatio;
    }

    public static class Name {
        public long timestamp;
        public String name;
    }
}

