/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.debugger.Condition;
import com.iscobol.debugger.DataExternalizable;
import com.iscobol.debugger.DebugUtilities;
import com.iscobol.debugger.Debugger;
import com.iscobol.debugger.DebuggerConstants;
import com.iscobol.debugger.DebuggerException;
import com.iscobol.debugger.Level88;
import com.iscobol.debugger.VarName;
import com.iscobol.interfaces.debugger.IWatch;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.INumericVar;
import com.iscobol.rts.RtsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class Watch
implements IWatch,
DataExternalizable {
    private static final long serialVersionUID = 1000007L;
    private String fullName;
    private String className;
    private String propName;
    private String value;
    private String envProperty;
    private boolean activated;
    private boolean enabled = true;
    private boolean hexadecimal;
    private boolean _88val;
    private Condition cond;
    private transient INumericVar handleVar;
    private transient VarName varname;
    private transient Debugger.IscobolField isField;

    public Watch() {
    }

    public Watch(VarName v, Debugger.IscobolField field, Condition c, String cls, String propName, boolean hex, boolean en) {
        this.varname = v;
        this.fullName = v.getFullName();
        this.cond = c;
        this.className = cls;
        this.activated = false;
        this.propName = propName;
        this.isField = field;
        this.hexadecimal = hex;
        this.enabled = en;
    }

    public Watch(VarName v, Debugger.IscobolField field, Object var, String fullName, Condition cond, String cls, boolean hex, boolean en) {
        this.varname = v;
        this.isField = field;
        this.fullName = v.getFullName();
        this.className = cls;
        if (var instanceof ICobolVar) {
            this.cond = cond;
        } else if (var instanceof Level88) {
            this.cond = cond;
            this._88val = ((Level88)var).getValue();
        }
        this.activated = true;
        this.hexadecimal = hex;
        try {
            this.value = hex && var instanceof ICobolVar ? DebugUtilities.toHexString((ICobolVar)var) : var.toString();
        }
        catch (Exception ex) {
            this.value = DebuggerConstants.NULL_VALUE;
        }
        this.enabled = en;
    }

    public Watch(INumericVar handleVar, String fullName, Condition c, String cls, String propName, String currValue, boolean hex, boolean en) {
        this.handleVar = handleVar;
        this.propName = propName;
        this.value = currValue;
        this.fullName = fullName;
        this.className = cls;
        this.cond = c;
        this.activated = true;
        this.hexadecimal = hex;
        this.enabled = en;
    }

    public Watch(String envproperty, String currValue, Condition cond, boolean en) {
        this.envProperty = envproperty;
        this.cond = cond;
        this.value = currValue;
        this.activated = true;
        this.enabled = en;
    }

    public void setActive(boolean a) {
        if (this.envProperty != null) {
            a = true;
        }
        this.activated = a;
    }

    @Override
    public boolean isActive() {
        return this.activated;
    }

    public void setEnabled(boolean en) {
        this.enabled = en;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isHexadecimal() {
        return this.hexadecimal;
    }

    @Override
    public String getEnvProperty() {
        return this.envProperty;
    }

    @Override
    public VarName getVarName() {
        return this.varname;
    }

    public Debugger.IscobolField getField() {
        return this.isField;
    }

    public boolean shouldNotifyChange(Debugger dbg) {
        boolean Return2;
        if (!this.enabled || !this.activated) {
            return false;
        }
        Debugger.IscobolField field = this.isField;
        if (field != null) {
            Return2 = this.refresh(dbg, field, false);
        } else {
            if (this.varname != null) {
                try {
                    field = dbg.findVar(this.varname, false);
                }
                catch (DebuggerException debuggerException) {
                    // empty catch block
                }
            }
            Return2 = this.refresh(dbg, field, true);
        }
        if (Return2 && this.cond != null) {
            Return2 = field != null ? (Return2 &= this.cond.evaluate(field.getVar())) : (Return2 &= this.cond.evaluate(dbg.getHelper().getStrLiteral(this.value)));
        }
        return Return2;
    }

    protected boolean refresh(Debugger dbg, Debugger.IscobolField field, boolean refresh) {
        String tmp;
        boolean Return2;
        if (!this.activated) {
            return false;
        }
        if (field instanceof Debugger.IscobolProp) {
            refresh = true;
        }
        if (field != null && field.getType() == Level88.class) {
            Object v = refresh ? field.refresh(dbg) : field.getVar();
            boolean b = ((Level88)v).getValue();
            Return2 = b != this._88val;
            this._88val = b;
            tmp = field.toString();
        } else {
            if (this.handleVar != null) {
                tmp = DebugUtilities.inquireProp(this.handleVar, this.propName, dbg.getCurrClass(), false, false);
            } else if (this.envProperty != null) {
                tmp = dbg.getHelper().acceptFromEnv(this.envProperty);
            } else if (field != null) {
                Object v;
                Object object = v = refresh ? field.refresh(dbg) : field.getVar();
                tmp = v != null ? (this.hexadecimal && ICobolVar.class.isAssignableFrom(field.getType()) ? DebugUtilities.toHexString((ICobolVar)v) : DebugUtilities.toString(v)) : Debugger.NULL_OBJECT.toString();
            } else {
                tmp = DebuggerConstants.NULL_VALUE;
            }
            boolean bl = Return2 = !tmp.equals(this.value);
        }
        if (Return2) {
            this.value = tmp;
        }
        return Return2;
    }

    @Override
    public String getPropName() {
        return this.propName;
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public String getClassname() {
        return this.className;
    }

    @Override
    public Condition getCondition() {
        return this.cond;
    }

    @Override
    public String getDebugCommand() {
        StringBuffer Return2 = new StringBuffer("monitor");
        if (this.enabled) {
            Return2.append(" -e ");
        } else {
            Return2.append(" -d ");
        }
        if (this.envProperty != null) {
            Return2.append(" -env " + this.envProperty);
        } else {
            Return2.append(" -c " + this.className);
            if (this.hexadecimal) {
                Return2.append(" -x ");
            }
            Return2.append(" " + this.fullName);
            if (this.propName != null) {
                Return2.append(" property " + this.propName);
            }
        }
        if (this.cond != null) {
            Return2.append(" when " + this.cond.toString());
        }
        return Return2.toString();
    }

    @Override
    public String getDebugDelCommand() {
        StringBuffer Return2 = new StringBuffer("unmonitor");
        if (this.envProperty != null) {
            Return2.append(" -env " + this.envProperty);
        } else {
            Return2.append(" -c " + this.className);
            Return2.append(" " + this.fullName);
            if (this.propName != null) {
                Return2.append(" property " + this.propName);
            }
        }
        return Return2.toString();
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public void setValue(String v) {
        this.value = v;
    }

    public String toString() {
        StringBuffer Return2 = new StringBuffer();
        if (this.envProperty != null) {
            Return2.append("iscobol." + this.envProperty);
        } else {
            Return2.append(this.fullName);
            if (this.className != null) {
                Return2.append(" [");
                Return2.append(this.className);
                Return2.append("]");
            }
            if (this.propName != null) {
                Return2.append("::" + this.propName);
            }
        }
        Return2.append(" = ");
        if (this.activated) {
            Return2.append(this.value);
        } else {
            Return2.append(DebuggerConstants.NULL_VALUE);
        }
        return Return2.toString();
    }

    private int compare(String s1, String s2, int nullVal) {
        if (s1 != null) {
            if (s2 != null) {
                return s1.compareTo(s2);
            }
            return nullVal;
        }
        if (s2 != null) {
            return -nullVal;
        }
        return 0;
    }

    public int compareTo(Object o) throws ClassCastException {
        Watch w = (Watch)o;
        int Return2 = this.compare(this.envProperty, w.envProperty, -1);
        if (Return2 != 0) {
            return Return2;
        }
        Return2 = this.compare(this.fullName, w.fullName, 1);
        if (Return2 != 0) {
            return Return2;
        }
        Return2 = this.compare(this.className, w.className, 1);
        if (Return2 != 0) {
            return Return2;
        }
        Return2 = this.compare(this.propName, w.propName, 1);
        if (Return2 != 0) {
            return Return2;
        }
        return 0;
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        RtsUtil.writeUTFOptmz(this.fullName, out);
        RtsUtil.writeUTFOptmz(this.className, out);
        RtsUtil.writeUTFOptmz(this.propName, out);
        RtsUtil.writeUTFOptmz(this.envProperty, out);
        RtsUtil.writeUTF(this.value, out);
        out.writeBoolean(this.enabled);
        out.writeBoolean(this.activated);
        out.writeBoolean(this.hexadecimal);
        out.writeBoolean(this._88val);
        out.writeBoolean(this.cond != null);
        if (this.cond != null) {
            this.cond.writeExternal(out);
        }
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.fullName = RtsUtil.readUTFOptmz(in);
        this.className = RtsUtil.readUTFOptmz(in);
        this.propName = RtsUtil.readUTFOptmz(in);
        this.envProperty = RtsUtil.readUTFOptmz(in);
        this.value = RtsUtil.readUTF(in);
        this.enabled = in.readBoolean();
        this.activated = in.readBoolean();
        this.hexadecimal = in.readBoolean();
        this._88val = in.readBoolean();
        if (in.readBoolean()) {
            this.cond = new Condition();
            this.cond.readExternal(in);
        }
    }
}

