/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.commands;

import com.iscobol.debugger.commands.DebugCommand;
import com.iscobol.rts.RtsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public abstract class BreakpointCommand
implements DebugCommand {
    private static final long serialVersionUID = 1000007L;
    int lineNo;
    int fileIndex;
    String paragraph;
    String filename;
    String progName;
    private String absolutePath;

    public BreakpointCommand() {
    }

    public BreakpointCommand(int line, String file, int fileIndex, String prog, String path) {
        this.lineNo = line;
        this.filename = file;
        this.progName = prog;
        this.absolutePath = path;
        this.fileIndex = fileIndex;
    }

    public BreakpointCommand(String par, String file, int fileIndex, String prog, String path) {
        this.paragraph = par;
        this.filename = file;
        this.progName = prog;
        this.absolutePath = path;
        this.fileIndex = fileIndex;
    }

    public int getFileIndex() {
        return this.fileIndex;
    }

    public int getLineNumber() {
        return this.lineNo;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getProgName() {
        return this.progName;
    }

    public String getParagraph() {
        return this.paragraph;
    }

    public String getPath() {
        return this.absolutePath;
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        out.writeInt(this.lineNo);
        out.writeInt(this.fileIndex);
        RtsUtil.writeUTFOptmz(this.paragraph, out);
        RtsUtil.writeUTFOptmz(this.filename, out);
        RtsUtil.writeUTFOptmz(this.progName, out);
        RtsUtil.writeUTFOptmz(this.absolutePath, out);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.lineNo = in.readInt();
        this.fileIndex = in.readInt();
        this.paragraph = RtsUtil.readUTFOptmz(in);
        this.filename = RtsUtil.readUTFOptmz(in);
        this.progName = RtsUtil.readUTFOptmz(in);
        this.absolutePath = RtsUtil.readUTFOptmz(in);
    }
}

