/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.commands;

import com.iscobol.debugger.Condition;
import com.iscobol.debugger.DebugTM;
import com.iscobol.debugger.DebuggerException;
import com.iscobol.debugger.VarName;
import com.iscobol.debugger.commands.DebugCommand;
import com.iscobol.interfaces.debugger.IVariableCommand;
import com.iscobol.rts.RtsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class SetMonitorCommand
implements DebugCommand,
IVariableCommand {
    private static final long serialVersionUID = 1000007L;
    public static final int ID = 13;
    public static final String SHORT_DESCRIPTION = " : set a monitor on a specified variable (-l print list of monitors)";
    public static final String STRING_ID = "monitor";
    public static final String HELP_PAGE = "monitor.html";
    public static final String USAGE = " usage:" + eol + "   monitor [" + "-d" + "] [" + "-x" + "] [-c class-name[:>method-name]] variable-name [when [=|!=|<|>|<=|>= const]|always|never]" + eol + "or monitor [" + "-d" + "] [-c class-name[:>method-name]] control-name|control-handle|window-handle " + "prop" + "|" + "property" + " property-name [when [=|!=|<|>|<=|>= const]|always|never]" + eol + "or monitor [" + "-d" + "] " + "-env" + " env-name" + eol + "or monitor " + "-l" + " (to list monitors)" + eol;
    private VarName varname;
    private String propertyName;
    private String className;
    private boolean hexadecimal;
    private String envName;
    private Condition condition;
    private boolean listing;
    private boolean enabled;

    public SetMonitorCommand() {
    }

    public SetMonitorCommand(VarName vn, String cls, boolean hex, Condition cond, boolean en) {
        this.varname = vn;
        this.className = cls;
        this.hexadecimal = hex;
        this.condition = cond;
        this.enabled = en;
    }

    public SetMonitorCommand(VarName vn, String cls, String prop, Condition cond, boolean en) {
        this.varname = vn;
        this.className = cls;
        this.propertyName = prop;
        this.condition = cond;
        this.enabled = en;
    }

    public SetMonitorCommand(String envProp, Condition cond, boolean en) {
        this.condition = cond;
        this.envName = envProp;
        this.enabled = en;
    }

    public SetMonitorCommand(boolean listing) {
        this.listing = listing;
    }

    @Override
    public VarName getVarName() {
        return this.varname;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isHexadecimal() {
        return this.hexadecimal;
    }

    public String getEnvName() {
        return this.envName;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public boolean isListing() {
        return this.listing;
    }

    @Override
    public int getId() {
        return 13;
    }

    @Override
    public String getStringId() {
        return STRING_ID;
    }

    @Override
    public String getShortDescription() {
        return SHORT_DESCRIPTION;
    }

    @Override
    public String getUsage() {
        return USAGE;
    }

    @Override
    public String getHelpPage() {
        return HELP_PAGE;
    }

    @Override
    public boolean isWholeWord() {
        return false;
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        out.writeBoolean(this.listing);
        if (!this.listing) {
            out.writeBoolean(this.varname != null);
            if (this.varname != null) {
                this.varname.writeExternal(out);
            }
            RtsUtil.writeUTFOptmz(this.className, out);
            RtsUtil.writeUTFOptmz(this.propertyName, out);
            out.writeBoolean(this.hexadecimal);
            out.writeBoolean(this.enabled);
            RtsUtil.writeUTFOptmz(this.envName, out);
            if (this.condition != null) {
                out.writeByte(1);
                this.condition.writeExternal(out);
            } else {
                out.writeByte(0);
            }
        }
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.listing = in.readBoolean();
        if (!this.listing) {
            if (in.readBoolean()) {
                this.varname = new VarName();
                this.varname.readExternal(in);
            } else {
                this.varname = new VarName();
            }
            this.className = RtsUtil.readUTFOptmz(in);
            this.propertyName = RtsUtil.readUTFOptmz(in);
            this.hexadecimal = in.readBoolean();
            this.enabled = in.readBoolean();
            this.envName = RtsUtil.readUTFOptmz(in);
            switch (in.readByte()) {
                default: {
                    break;
                }
                case 1: {
                    this.condition = new Condition();
                    this.condition.readExternal(in);
                    break;
                }
                case 2: {
                    try {
                        this.condition = new Condition(new DebugTM(RtsUtil.readUTFOptmz(in)), this.hexadecimal);
                        break;
                    }
                    catch (DebuggerException e) {
                        throw new IOException(e);
                    }
                }
            }
        }
    }
}

