/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.dialogs;

import com.iscobol.debugger.Settings;
import com.iscobol.debugger.dialogs.DebugDialog;
import com.iscobol.debugger.dialogs.LMResize;
import com.iscobol.debugger.dialogs.LMResizeData;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public abstract class AbstractSettingsDialog
extends DebugDialog {
    private static final long serialVersionUID = 1L;
    private JButton applyBtn;
    private JButton cancelBtn;
    private JButton okBtn;
    private boolean dirty;

    public AbstractSettingsDialog(JFrame parent, String title, boolean modal) {
        super(parent, title, modal);
        this.configureDialog();
        this.getContentPane().setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel();
        this.createContents(mainPanel);
        this.getContentPane().add((Component)mainPanel, "Center");
        LMResize buttonLayout = new LMResize(10, 10, 5, 0);
        JPanel buttonPanel = new JPanel(buttonLayout);
        this.okBtn = this.createOkButton();
        this.cancelBtn = this.createCancelButton();
        this.applyBtn = this.createApplyButton();
        this.applyBtn.setEnabled(false);
        int mainPanelW = mainPanel.getLayout().preferredLayoutSize((Container)mainPanel).width;
        Dimension d = buttonLayout.getPreferredSize(this.cancelBtn);
        mainPanelW = Math.max(mainPanelW, d.width * 3 + 40);
        this.applyBtn.setBounds(mainPanelW - 10 - d.width, 10, d.width, d.height);
        buttonPanel.add((Component)this.applyBtn, new LMResizeData(10));
        this.cancelBtn.setBounds(LMResize.getLeft(this.applyBtn) - 10 - d.width, LMResize.getTop(this.applyBtn), d.width, d.height);
        buttonPanel.add((Component)this.cancelBtn, new LMResizeData(10));
        this.okBtn.setBounds(LMResize.getLeft(this.cancelBtn) - 10 - d.width, LMResize.getTop(this.applyBtn), d.width, d.height);
        buttonPanel.add((Component)this.okBtn, new LMResizeData(10));
        this.getContentPane().add((Component)buttonPanel, "South");
        this.setDefaultButton(this.okBtn);
        this.pack();
    }

    protected abstract void createContents(JPanel var1);

    protected void configureDialog() {
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
        this.applyBtn.setEnabled(dirty);
    }

    private JButton createApplyButton() {
        JButton btn = new JButton("Apply");
        btn.addActionListener(e -> {
            String err = this.validateInput();
            if (err != null) {
                JOptionPane.showMessageDialog(this, err, this.getTitle(), 0);
            } else {
                this.performApply();
            }
        });
        btn.setMnemonic(97);
        return btn;
    }

    private JButton createOkButton() {
        JButton btn = new JButton("Ok");
        btn.setMnemonic(111);
        btn.addActionListener(e -> {
            String err = this.validateInput();
            if (err != null) {
                JOptionPane.showMessageDialog(this, err, this.getTitle(), 0);
            } else {
                this.performOK();
            }
        });
        return btn;
    }

    private JButton createCancelButton() {
        JButton btn = new JButton("Cancel");
        btn.addActionListener(e -> this.performCancel());
        btn.setMnemonic(99);
        return btn;
    }

    protected void performApply() {
        Settings.saveSettings();
        this.setDirty(false);
    }

    protected void performCancel() {
        this.closeDialog();
    }

    protected void performOK() {
        this.performApply();
        this.closeDialog();
    }

    protected String validateInput() {
        return null;
    }
}

