/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.dialogs;

import com.iscobol.debugger.GraphDebugger;
import com.iscobol.debugger.Settings;
import com.iscobol.debugger.dialogs.AbstractSettingsDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;

public class CustomizeShortcutsDialog
extends AbstractSettingsDialog {
    private static final long serialVersionUID = 1L;
    private static final String[][] shortcutNames = new String[][]{{"Back", "graphdebugger.shortcut.gotoback"}, {"Change value of Variable", "graphdebugger.shortcut.let"}, {"Clear Output", "graphdebugger.shortcut.clearout"}, {"Continue", "graphdebugger.shortcut.continue"}, {"Copy source code", "graphdebugger.shortcut.copy_source"}, {"Current Line", "graphdebugger.shortcut.curr_line"}, {"Decrement Font Size", "graphdebugger.shortcut.decfont"}, {"Display Variable", "graphdebugger.shortcut.display"}, {"Display Variables On Selected Line", "graphdebugger.shortcut.displayonselline"}, {"Exit", "graphdebugger.shortcut.exit"}, {"Find", "graphdebugger.shortcut.find"}, {"Find Backwards", "graphdebugger.shortcut.fb"}, {"Find Forwards", "graphdebugger.shortcut.ff"}, {"Find From Top", "graphdebugger.shortcut.ft"}, {"Finish Session", "graphdebugger.shortcut.quit"}, {"First Executable Line", "graphdebugger.shortcut.first_exec_line"}, {"First Line", "graphdebugger.shortcut.first_line"}, {"Forward", "graphdebugger.shortcut.gotoforw"}, {"Go To", "graphdebugger.shortcut.goto"}, {"Go To Declaration", "graphdebugger.shortcut.gotodecl"}, {"Help", "graphdebugger.shortcut.help"}, {"Increment Font Size", "graphdebugger.shortcut.incfont"}, {"Jump", "graphdebugger.shortcut.jump"}, {"Jump Out Paragraph", "graphdebugger.shortcut.jumpoutpar"}, {"Jump Out Program", "graphdebugger.shortcut.jumpoutprog"}, {"Jump Over", "graphdebugger.shortcut.jumpnext"}, {"Jump To Selected Line", "graphdebugger.shortcut.jumptoline"}, {"Last Line", "graphdebugger.shortcut.last_line"}, {"Load File", "graphdebugger.shortcut.loadfile"}, {"Quick Watch", "graphdebugger.shortcut.quickwatch"}, {"Refresh Variables Area", "graphdebugger.shortcut.refreshvararea"}, {"Repeat Find", "graphdebugger.shortcut.repfind"}, {"Run To Line Number", "graphdebugger.shortcut.to"}, {"Run To Next Program", "graphdebugger.shortcut.prog"}, {"Run To Selected Line", "graphdebugger.shortcut.toline"}, {"Set Breakpoint", "graphdebugger.shortcut.break"}, {"Set Monitor", "graphdebugger.shortcut.monitor"}, {"Show Last Command", "graphdebugger.shortcut.lastcmd"}, {"Show Next Command", "graphdebugger.shortcut.nextcmd"}, {"Show Previous Command", "graphdebugger.shortcut.prevcmd"}, {"Start Autostep", "graphdebugger.shortcut.ston"}, {"Start Session", "graphdebugger.shortcut.run"}, {"Start Tracing", "graphdebugger.shortcut.tron"}, {"Step Into", "graphdebugger.shortcut.step"}, {"Step Out Paragraph", "graphdebugger.shortcut.outpar"}, {"Step Out Program", "graphdebugger.shortcut.outprog"}, {"Step Over", "graphdebugger.shortcut.next"}, {"Stop Autostep", "graphdebugger.shortcut.stoff"}, {"Stop Tracing", "graphdebugger.shortcut.troff"}, {"Toggle Breakpoint", "graphdebugger.shortcut.togglebreak"}, {"Unload File", "graphdebugger.shortcut.unloadfile"}};
    private JTable shortcutTable;
    private DefaultTableModel shortcutTableModel;
    private String[] shortcuts;
    private GraphDebugger gd;

    public CustomizeShortcutsDialog(JFrame parent, String title, GraphDebugger gd) {
        super(parent, title, true);
        this.gd = gd;
    }

    @Override
    protected void createContents(JPanel mainPanel) {
        this.shortcutTableModel = new DefaultTableModel();
        this.shortcutTableModel.addColumn("Action");
        this.shortcutTableModel.addColumn("Shortcut");
        this.shortcuts = new String[shortcutNames.length];
        for (int i = 0; i < shortcutNames.length; ++i) {
            this.shortcuts[i] = Settings.getShortcut(shortcutNames[i][1]);
            int[] params = Settings.getShortcutParams(this.shortcuts[i]);
            int modifiers = params[0];
            int keyCode = params[1];
            String text = "";
            if ((modifiers & 2) == 2) {
                text = text + "Ctrl ";
            }
            if ((modifiers & 8) == 8) {
                text = text + "Alt ";
            }
            if ((modifiers & 1) == 1) {
                text = text + "Shift ";
            }
            text = text + KeyEvent.getKeyText(keyCode);
            this.shortcutTableModel.addRow(new Object[]{shortcutNames[i][0], text});
        }
        this.shortcutTable = new JTable(this.shortcutTableModel){
            MyTableEditor editor;
            {
                this.editor = new MyTableEditor();
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 1;
            }

            @Override
            public TableCellEditor getCellEditor(int row, int column) {
                if (column == 1) {
                    return this.editor;
                }
                return null;
            }
        };
        this.shortcutTable.setFont(this.getFont().deriveFont(13.0f));
        this.shortcutTable.setShowGrid(true);
        this.shortcutTable.setRowSelectionAllowed(true);
        this.shortcutTable.setSurrendersFocusOnKeystroke(true);
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)new JScrollPane(this.shortcutTable), "Center");
    }

    @Override
    protected void performApply() {
        for (int i = 0; i < this.shortcutTable.getRowCount(); ++i) {
            Settings.setShortcut(shortcutNames[i][1], this.shortcuts[i]);
        }
        this.gd.setAccelerators();
        super.performApply();
    }

    private class MyTableEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JTextField tf = new JTextField();
        KeyListener kl;

        MyTableEditor() {
            this.tf.setBorder(null);
            this.tf.setToolTipText("Press a key");
            this.tf.setEditable(false);
        }

        @Override
        public Object getCellEditorValue() {
            return this.tf != null ? this.tf.getText() : null;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, final int row, int column) {
            if (value != null) {
                this.tf.setText(value.toString());
            }
            if (this.kl != null) {
                this.tf.removeKeyListener(this.kl);
            }
            this.kl = new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    int keyCode = e.getKeyCode();
                    switch (keyCode) {
                        case 16: 
                        case 17: 
                        case 18: 
                        case 65406: {
                            break;
                        }
                        default: {
                            int modifiers = 0;
                            String text = "";
                            if (e.isControlDown()) {
                                modifiers |= 2;
                                text = text + "Ctrl ";
                            }
                            if (e.isAltDown()) {
                                modifiers |= 8;
                                text = text + "Alt ";
                            }
                            if (e.isShiftDown()) {
                                modifiers |= 1;
                                text = text + "Shift ";
                            }
                            String shortcut = "";
                            if (modifiers > 0) {
                                shortcut = shortcut + modifiers + " ";
                            }
                            shortcut = shortcut + keyCode;
                            text = text + KeyEvent.getKeyText(keyCode);
                            MyTableEditor.this.tf.setText(text);
                            for (int i = 0; i < CustomizeShortcutsDialog.this.shortcuts.length; ++i) {
                                if (i == row || !CustomizeShortcutsDialog.this.shortcuts[i].equals(shortcut)) continue;
                                ((CustomizeShortcutsDialog)CustomizeShortcutsDialog.this).shortcuts[i] = CustomizeShortcutsDialog.this.shortcuts[row];
                                CustomizeShortcutsDialog.this.shortcutTable.setValueAt(CustomizeShortcutsDialog.this.shortcutTable.getValueAt(row, 1), i, 1);
                                break;
                            }
                            ((CustomizeShortcutsDialog)CustomizeShortcutsDialog.this).shortcuts[row] = shortcut;
                            MyTableEditor.this.fireEditingStopped();
                            e.consume();
                            CustomizeShortcutsDialog.this.setDirty(true);
                        }
                    }
                }
            };
            this.tf.addKeyListener(this.kl);
            return this.tf;
        }
    }
}

