/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.tree;

import com.iscobol.debugger.DataExternalizable;
import com.iscobol.interfaces.debugger.ITreeNodeExtension;
import com.iscobol.rts.RtsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;

public class TreeNode
implements ITreeNodeExtension,
DataExternalizable {
    private static final long serialVersionUID = 1000007L;
    private static final String eol = System.getProperty("line.separator", "\n");
    private String varName;
    private String varValue;
    private int varOffset;
    private int varLength;
    private boolean hasChildren;
    private ArrayList<TreeNode> children;
    private transient TreeNode parent;

    public TreeNode() {
    }

    public TreeNode(String name, String value) {
        this(name, value, 0, 0);
    }

    public TreeNode(String name, String value, int offset, int length) {
        this.varName = name;
        this.varValue = value;
        this.varOffset = offset;
        this.varLength = length;
        this.children = new ArrayList();
    }

    public boolean hasChildren() {
        return this.hasChildren;
    }

    public void setHasChildren(boolean b) {
        this.hasChildren = b;
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public String getVarName() {
        return this.varName;
    }

    @Override
    public String getVarValue() {
        return this.varValue;
    }

    public void setVarValue(String v) {
        this.varValue = v;
    }

    public void setVarName(String n) {
        this.varName = n;
    }

    @Override
    public int getVarLength() {
        return this.varLength;
    }

    @Override
    public int getVarOffset() {
        return this.varOffset;
    }

    public TreeNode[] getChildren() {
        return this.children.toArray(new TreeNode[this.children.size()]);
    }

    public void addNode(TreeNode n) {
        this.children.add(n);
        n.parent = this;
    }

    private int getDepth() {
        if (this.parent == null) {
            return 0;
        }
        int depth = 0;
        TreeNode par = this.parent;
        while (par != null) {
            par = par.parent;
            ++depth;
        }
        return depth;
    }

    public String toString() {
        StringBuffer Return2 = new StringBuffer();
        int depth = this.getDepth();
        if (depth > 0) {
            for (int i = 1; i < depth; ++i) {
                Return2.append("  ");
            }
            Return2.append("- " + this.varName);
            if (this.varValue != null) {
                Return2.append(" = " + this.varValue);
            }
            Return2.append(eol);
        }
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            Return2.append(this.children.get(i));
        }
        return Return2.toString();
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        RtsUtil.writeUTFOptmz(this.varName, out);
        RtsUtil.writeUTF(this.varValue, out);
        out.writeInt(this.varOffset);
        out.writeInt(this.varLength);
        out.writeInt(this.children.size());
        for (TreeNode n : this.children) {
            n.writeExternal(out);
        }
        out.writeBoolean(this.hasChildren);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.varName = RtsUtil.readUTFOptmz(in);
        this.varValue = RtsUtil.readUTF(in);
        this.varOffset = in.readInt();
        this.varLength = in.readInt();
        int s = in.readInt();
        this.children = new ArrayList();
        for (int i = 0; i < s; ++i) {
            TreeNode n = new TreeNode();
            n.readExternal(in);
            this.children.add(n);
        }
        this.hasChildren = in.readBoolean();
    }
}

