/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client;

import com.iscobol.gui.AppFactory;
import com.iscobol.gui.GuiFactory;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.client.AbstractGuiFactoryImpl;
import com.iscobol.gui.client.Client;
import com.iscobol.gui.client.CsProperty;
import com.iscobol.gui.client.swing.SwingErrorBox;
import com.iscobol.gui.server.ScrFactory;
import com.iscobol.rmi.Remote;
import com.iscobol.rmi.server.UnicastRemoteObject;
import com.iscobol.rts.Config;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts_n.Factory;
import com.iscobol.types_n.PicX;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class AppFactoryImpl
extends UnicastRemoteObject
implements Remote,
AppFactory {
    boolean noexit;
    transient Object synch;
    String[][] isconfig;
    private GuiFactory gfssh;
    private boolean nodisconnecterr;

    public AppFactoryImpl() {
        String threadName = Thread.currentThread().getName();
        Config.markNoIscobolRuntimeThread();
        Config cfg = new Config();
        Thread.currentThread().setName(threadName);
        String tmOut = Config.getProperty(cfg, "iscobol.as.check_alive_interval", "", null);
        if (tmOut != null) {
            int timeout;
            StringTokenizer st = new StringTokenizer(tmOut);
            if (st.hasMoreTokens()) {
                st.nextToken();
                if (st.hasMoreTokens()) {
                    try {
                        timeout = Integer.parseInt(st.nextToken());
                    }
                    catch (NumberFormatException _ex) {
                        timeout = 60;
                    }
                } else {
                    timeout = 60;
                }
            } else {
                timeout = 60;
            }
            this.setCallTimeout(timeout);
        } else {
            this.setCallTimeout(60);
        }
    }

    public AppFactoryImpl(Object synch, boolean noexit, String[][] isconfig, boolean nodisconnecterr, GuiFactory gfssh) {
        this.synch = synch;
        this.noexit = noexit;
        this.isconfig = isconfig;
        this.nodisconnecterr = nodisconnecterr;
        this.gfssh = gfssh;
    }

    @Override
    public final String activateLic(byte[] s, String hID, int flag) throws IOException {
        return Config.srl(s, hID, flag);
    }

    @Override
    public void exit(final String errStr) throws IOException {
        boolean isErrorCode = false;
        int errorCode = 0;
        try {
            errorCode = Integer.parseInt(errStr);
            isErrorCode = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        final int c = errorCode;
        final boolean fnoexit = this.noexit;
        final Object fsynch = this.synch;
        final boolean ec = isErrorCode;
        if (!this.noexit) {
            Client.setExiting(true);
        }
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (!ec && errStr != null) {
                    SwingErrorBox.message(errStr, errStr, false);
                }
                try {
                    1.sleep(100L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                if (!fnoexit) {
                    System.exit(c);
                } else {
                    Object object = fsynch;
                    synchronized (object) {
                        fsynch.notify();
                    }
                }
            }
        }.start();
    }

    @Override
    public void killedByServer(final int errorCode) throws IOException {
        final boolean fnoexit = this.noexit;
        final Object fsynch = this.synch;
        if (!this.noexit) {
            Client.setExiting(true);
        }
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (!AppFactoryImpl.this.nodisconnecterr) {
                    String title = "Session terminated";
                    String msg = "Session terminated by the Server";
                    SwingErrorBox.optionPaneMessage("Session terminated", "Session terminated by the Server");
                }
                if (!fnoexit) {
                    System.exit(errorCode);
                } else {
                    Object object = fsynch;
                    synchronized (object) {
                        fsynch.notify();
                    }
                }
            }
        }.start();
    }

    @Override
    public GuiFactory newGuiFactory() throws IOException {
        String className = Config.getProperty("iscobol.guifactory.class", "com.iscobol.gui.client.swing.GuiFactoryImpl");
        GuiFactory gf = null;
        try {
            gf = this.gfssh == null ? (GuiFactory)Class.forName(className).newInstance() : this.gfssh;
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
        }
        catch (InstantiationException ie) {
            ie.printStackTrace();
        }
        return gf;
    }

    @Override
    public boolean getNoexit() throws IOException {
        return this.noexit;
    }

    @Override
    public String[][] getIsconfig() throws IOException {
        return this.isconfig;
    }

    public void setObjSynch(Object synch) throws IOException {
        this.synch = synch;
    }

    @Override
    public final void sendMessage(String msg, String title, boolean isCp) throws IOException {
        new Thread(() -> {
            try {
                this.showMessage(msg, title, isCp);
            }
            finally {
                IscobolSystem.destroyEnv(Thread.currentThread());
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void showMessage(String msg, String title, boolean isCp) {
        boolean modalityType;
        CsProperty csProperty;
        GuiFactory gf = ScreenUtility.getGuiFactory();
        if (gf instanceof AbstractGuiFactoryImpl) {
            csProperty = ((AbstractGuiFactoryImpl)gf).getCsProperty();
            modalityType = csProperty.get("iscobol.gui.windows_modality", true);
            csProperty.set("iscobol.gui.windows_modality", "false");
        } else {
            csProperty = null;
            modalityType = false;
        }
        try {
            ArrayList<ICobolVar> args = new ArrayList<ICobolVar>();
            if (isCp) {
                args.add(PicX.literal(msg));
                if (title != null) {
                    args.add(PicX.literal(title));
                }
                Factory.call("A$CUSTOM_MESSAGE", null, args.toArray(), false);
            } else {
                args.add(com.iscobol.types.PicX.literal(msg));
                if (title != null) {
                    args.add(com.iscobol.types.PicX.literal(title));
                }
                com.iscobol.rts.Factory.call("A$CUSTOM_MESSAGE", null, args.toArray(), false);
            }
        }
        catch (IscobolRuntimeException _ex) {
            ScrFactory.getGUIMessageBox().setTitle(title != null ? title : "A$SEND_MESSAGE").setText(msg).setAttributes("CENTERED").show();
        }
        finally {
            if (csProperty != null) {
                csProperty.set("iscobol.gui.windows_modality", "" + modalityType);
            }
        }
    }
}

